/*
 * Notesfile specific processing
 */
insertart(io, hp, rawnews)
	struct io_f *io;
	struct hbuf *hp;
	FILE *rawnews;
{
	struct note_f note;
	struct note_f note2;
	struct number_f nfindex;
	char psys[IDSZ], puniq[IDSZ];
	char firstref[IDSZ];
	char *p;

	parseid(hp->ident, puniq, psys);
	getperms(io, 1, psys);
	if (allow(io, WRITOK) == 0) {
		log("%s: %s: %s may not write notes", io->nf, hp->ident, psys);
		return(-1);
	}

	strcpy(note.n_title, title);
	note.n_msg.m_stat = FRMNEWS;		/* came from news system */


	d = dbm_fetch(
	

	lock(io, 'n');
	notenum = chknote(io, hp->ident, &note2);
	if (notenum > 0) {
		if ((note2.n_msg.m_stat & ORPHND) == 0) {
			if (verbose_log)
			    log("%s: %s: duplicate note", io->nf, hp->ident); 
			io->nnotdrop++;
			unlock(io, 'n');
			return(-1);
		}
		/* replace foster parent */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);   /* collect text */
		safecpy(note2.n_title,hp->title,TITLEN);
		note2.n_msg = note.n_msg;
		note2.n_lmod = hp->rectime;
		putnrec(io, notenum, &note2);	/* and replace */
		unlock(io, 'n');
#ifdef MSGID_INDEX
		putmsgid(io, notenum, 0, &note2.n_msg);
#endif /* MSGID_INDEX */		
		log("%s: %s: orphan replaced", io->nf, hp->ident);
		return(0);
	}

#ifdef notdef
#ifdef FULLREFS
	/* Reference line stuff */

	if (strlen(hp->followid) != 0) { /* Has References: line */
	    nfindex = chkref(io, hp->followid, &note2);
	    if (nfindex.note != -1) {  /* Reference found, insert response */
                if(chkresp(io, hp->ident, &note2, nfindex.note)) {
		    /* We already have a copy of this response */
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s duplicate response", io->nf, hp->ident);
                    io->nrspdrop++;
		    return(-1);
		} else {
		    /* This response is new to us */
                    puthdr(io, &note.n_msg, hp);
                    pagein(io, rawnews, &note.n_msg.m_addr);
                    putresp(io, nfindex.note, &note2, &note.n_msg, ADDTIME);
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s response inserted", io->nf, hp->ident);
                    io->nrsprcvd++;
                    return(0);
                }
	    } else {
		/* Referenced note does not exist.  Response is an Orphan. */
		struct hbuf hfake;

		/* Zero out header struct */
		bzero((char *)&hfake, sizeof hfake);
		
		/* Fill in the fields from the response */
		strcpy(hfake.ident, firstref);
		safecpy(note2.n_title, hp->title, TITLEN); /* Use same title */
		strcpy(hfake.nbuf, io->nf);
		sprintf(hfake.from, "Unknown");
		hfake.subtime = hp->subtime;
		hfake.rectime = hp->rectime;
		note2.n_msg.m_stat |= ORPHND;
		note2.n_nresp = 0;
		note2.n_msg.m_addr.addr = 0;

		puthdr(io, &note2.n_msg, &hfake);
		notenum = putnote(io, &note2, NOPOLICY, ADDTIME);

		/* bump count of recieved orphans */
		if (verbose_log)
		    log("loadem: %s: orphan %s created",
			hp->ident, firstref);
		io->norphans++;

		/* insert response */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		unlock(io, 'n');
		if (verbose_log)
		    log("%s: %s response inserted", io->nf, hp->ident);
		io->nrsprcvd++;
		return(0);
	    }
	}
#else /* FULLREFS */
	/*
	 * If we can match the first msg-ID in the "References:"
	 * field to a basenote, then tack it on as a response.
	 * Otherwise, insert it as an Orphan.
	 */

        /* We cut the line down to one Message-ID */
	safecpy(firstref, hp->followid, IDSZ);
	p = index(firstref, '>');
	if (p != NULL)
	    *++p = '\0';
	else
	    firstref[0] = '\0';		/* Malformed Message-ID.  Ignore. */
	
        if( strlen(firstref) != 0 ) {	/* Has "References:" field */
            notenum = chknote(io, firstref, &note2);
            fseek(rawnews, savepos, 0);
            if (notenum > 0) {		/* Referenced note exists */
                if(chkresp(io, hp->ident, &note2, notenum)) {
		    /* We already have a copy of this response */
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s duplicate response", io->nf, hp->ident);
                    io->nrspdrop++;
		    return(-1);
		} else {
		    /* This response is new to us */
                    puthdr(io, &note.n_msg, hp);
                    pagein(io, rawnews, &note.n_msg.m_addr);
                    putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
                    unlock(io, 'n');
                    if (verbose_log)
                        log("%s: %s response inserted", io->nf, hp->ident);
                    io->nrsprcvd++;
                    return(0);
                }
	    } else {
		/* Referenced note does not exist.  Response is an Orphan. */
		struct hbuf hfake;

		/* Zero out header struct */
		bzero((char *)&hfake, sizeof hfake);
		
		/* Fill in the fields from the response */
		strcpy(hfake.ident, firstref);
		safecpy(note2.n_title, hp->title, TITLEN); /* Use same title */
		strcpy(hfake.nbuf, io->nf);
		sprintf(hfake.from, "Unknown");
		hfake.subtime = hp->subtime;
		hfake.rectime = hp->rectime;
		note2.n_msg.m_stat |= ORPHND;
		note2.n_nresp = 0;
		note2.n_msg.m_addr.addr = 0;

		puthdr(io, &note2.n_msg, &hfake);
		notenum = putnote(io, &note2, NOPOLICY, ADDTIME);

		/* bump count of recieved orphans */
		if (verbose_log)
		    log("loadem: %s: orphan %s created",
			hp->ident, firstref);
		io->norphans++;

		/* insert response */
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		unlock(io, 'n');
		if (verbose_log)
		    log("%s: %s response inserted", io->nf, hp->ident);
		io->nrsprcvd++;
		return(0);
	    }
      	}
#endif /* FULLREFS */
#endif /* notdef */	
	/*
	 * For notesfiles where we always post with the same title!
	 *	e.g., ai-list or news
	 */
	if (re_seen) {
		strcpy(io->xstring, title);
		notenum = findtitle(io, io->descr.d_nnote);
		if (notenum > 0)
			getnrec(io, notenum, &note2);
	}
	fseek(rawnews, savepos, 0);
	if (re_seen == 0 || notenum <= 0) {
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		notenum = putnote(io, &note, NOPOLICY, ADDTIME);
		/* count as networked in */
		if (verbose_log)
		    log("%s: %s note inserted", io->nf, hp->ident);
		io->nnotrcvd++;
	} else if (notenum > 0 && !chkresp(io, hp->ident, &note2, notenum)) {
		puthdr(io, &note.n_msg, hp);
		pagein(io, rawnews, &note.n_msg.m_addr);
		putresp(io, notenum, &note2, &note.n_msg, ADDTIME);
		if (verbose_log)
		    log("%s: %s response inserted (title matched)", io->nf, hp->ident);
		io->nrsprcvd++;
	} else {
		if (verbose_log)
			log("%s: %s duplicate response", io->nf, hp->ident);
	}
	unlock(io, 'n');
	return(0);
}
