/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/parseid.c,v 2.0 89/04/16 01:00:53 gore Exp $ */

#include "parms.h"
#include "structs.h"

#include <ctype.h>

/*
 * parseid() breaks a message-ID into a system name and unique number,
 *    for use in OldNotes format.  Colons are changed to dots to
 *    protect the OldNotes headers.
 *
 *	<123@newsvax.FOO>         -->    newsvax:123
 *	<23feb1986-004@newsvax>   -->    23feb1986-004@newsvax:-1
 *	<stuf:4@newsvax>          -->    stuf.4@newsvax:-1
 *
 *  Recoded:	Walter Underwood, April 1986
 */

parseid(id, uniq, sys)
	char *id;
	char *sys;
	char *uniq;
{
	int i;
	int is_a_num();
	char *p;
	char *index();

	i = sscanf(id, "<%[^@]@%[^>]>", uniq, sys);
	if (i == 2) {
		if (p = index(sys, '.'))
			*p = '\0';
	}

	if(!is_a_num(uniq)) {
	        strcpy(uniq, "-1");
		i = sscanf(id, "<%[^>]>", sys);
	}

	for( p = sys ; *p != '\0' ; p++ )
	        if( *p == ':' )
		        *p = '.';
}

is_a_num(str)
     char *str;
{
  char *p;

  p = str;
  if (*p == '-')
    p++;

  while (isdigit(*p))
    p++;

  if( (p-str) == strlen(str) )
    return 1;
  else
    return 0;
}

buildid(id, uniq, sys)
	char *id;
	char *sys;
	char *uniq;
{
	sprintf(id, "<%s@%s>", uniq, sys);
}

/*
 * fixnotesid() is exactly like buildid(), except that it tries to
 *    reconstruct the original message-id if it appears to have
 *    been munged by an older News->Notes gateway.
 *
 *    These gateways have done several different transformations
 *    at different times in history.  We attempt to undo each
 *    of the following transformations (in approximate order of
 *    popularity):
 *
 *	(A)  <123@newsvax>           -->    newsvax:-12300
 *      (B)  <123@newsvax>           -->    newsvax:-12301
 *      (C)  <123@newsvax>           -->    newsvax:-123
 *      (D)  <agf.1985@newsvax.EDU>  -->    agf.1985@newsvax.EDU:-1
 *      (E)  <2705dc7@newsvax.UK>    -->    dc7@newsvax.UK:2705
 *
 *    No attempt is made to rescue a Message-ID munged by
 *    transformation (E).
 *
 *    In transformation (D), the "-1" is used as a flag
 *    to indicate that the unique ID part of the News Message-ID
 *    could not be converted to a number.  Thus the entire ID is
 *    stored as the systemname.
 *
 *    Most News->Notes gateways also strip the domain from the
 *    systemname part of the Message-ID.  We do not add a domain
 *    to the reconstructed Message-ID, because there is no good
 *    default.
 *
 *    Luckily, this kludge only needs to be called from the nfrcv
 *    code.
 *
 *		W. Underwood, February 1986
 */


fixnotesid(id, uniq, sys)
       char *id;
       char *sys;
       char *uniq;
{
	long   uniq_num;

	if (*uniq != '-')
		buildid(id, uniq, sys);	/* Ahhh, a normal ID */
	else {
		uniq_num = atol(uniq);

		if (uniq_num == -1) {	/* Handle case (D) */
			sprintf(id, "<%s>", sys);
			return;
		}

		uniq_num = -uniq_num;	/* Let's get positive */

		switch (uniq_num%100)  {
		case 1:			/* Handle case (B) */
		  uniq_num --;
		  /* FALL THROUGH */
		case 0:			/* Handle case (A) */
		  uniq_num /= 100;
		  break;
		default:		/* Handle case (C) */
		  break;
		}
		sprintf(id, "<%d@%s>", uniq_num, sys);
	}
	return;
}

/*
 * stripid() removes all domains from the system part of a
 *   message-ID.  A message which has passed through an
 *   old notes system has had the domain stripped, so we
 *   need to compare without respect to domain.
 *
 * stripid() returns a one if it found a domain, -1 if it did not
 *   find an '@', and zero otherwise.  No '@' means that the
 *   article cannot be translated to OldNotes format.
 *
 *            Walter Underwood  February 1986
 */

int stripid(id)
	char *id;
{
	char *p;		/* scratch pointer */
	int  hasdomain = 0;

	/* skip any dots in first half */
	if ((p = index(id, '@')) == NULL) {
	  if (verbose_log)
	    log("stripid: message-id has no '@': \"%s\"", id);
	  p = id;		/* OK, strip the whole thing */
	  hasdomain = -1;
	}

	if (p = index(p, '.')) {
		*p++ = '>';
		*p   = '\0';
		hasdomain = 1;
	}

	return hasdomain;
}

char *
makeid(io)
	struct io_f *io;
{
	static char id[IDSZ];
	int i, j;

	lock(io, 'n');
	getdscr(io, &io->descr);
	i = io->descr.d_nfnum;
	j = ++io->descr.d_id;
#ifdef	notdef
	/* would like this, but it would break all old notes sites... */
	sprintf(id, "<%d-%d@%s>", i, j, full_hostname);
#else /* not notdef */
	/* Used to use "%d%04d" for i and j, but that made leading  */
	/* zeroes with i==0.  Also breaks old notes. */
	sprintf(id, "<%d@%s>", i*10000+j, full_hostname);
#endif notdef
	putdscr(io, &io->descr);
	unlock(io, 'n');
	return(id);
}
