/* $Header: resp.c,v 1.2 86/06/17 15:46:11 notes Exp $ */

#include "parms.h"
#include "structs.h"

/*
 * putresp(io, text, status, noteno, anon)
 *
 *	writes out a response to noteno in the last position.
 *	returns 0 to indicate note has been deleted,
 *	otherwise it returns the response number it inserted.
 *
 *
 * delresp(io, noteno, resprec, resphys)
 *
 *	Deletes PHYSICAL response located at resprec (record id)
 *	resphys (internal subscript), updates note's response count
 *
 *
 * getfrsp(io) gets the next free response index -- simple free list chained
 *   off first two bytes of file, currently.
 */

long lseek();				/* declare for type checking */

putresp(io, noteno, note, msgp, addtime)
/* all input params */
struct io_f *io;
struct note_f *note;
struct msg_f *msgp;
/* addtime - whether to modify time stamps - useed for compression */
{
	int i, phys;
	/* physical subscript number */
	int lastin;			/* address of resp record in memory */
	struct resp_f resp;

	getdscr(io, &io->descr);
	if (io->descr.d_stat & NFINVALID) {
		closenf(io);
		opennf(io, io->nf);
		getdscr(io, &io->descr);	/* and updated descriptor */
		return(0);
	}
	getnrec(io, noteno, note);
	if (note->n_stat & DELETED) {	/* is this note deleted? */
		/*
		 * see, it could be deleted by someone
		 * else in the intermediary
		 */
		return(0);				/* putresp failed */
	}
	/* is there an attached response record ? */
	if (note->n_rindx < 0) {
		lastin = note->n_rindx = getfrsp(io);	/* no, make one */
		/* mark all as undeleted at start */
		for (i = 0; i < RESPSZ; i++) {
			resp.r_msg[i].m_stat = 0;
		}
	} else {
		/* get 1st resp record */
		getrrec(io, lastin = note->n_rindx, &resp);
	}
	i = phys = 0;			/* logical/phys records start here */
	while (i < note->n_nresp) {		/* until we get to end */
		if (phys >= RESPSZ) {		/* end? -- need next recd */
			phys = 0;		/* beginning of next one */
			/* next recd */
			getrrec(io, lastin = resp.r_next, &resp);
		}
		if ((resp.r_msg[phys].m_stat & DELETED) == 0)
			i++;	/* count this entry if undeleted */
		phys++;				/* always count these */
	}
	/* could have gone off end with last phys++ */
	if (phys >= RESPSZ) {
		phys = 0;
		resp.r_next = getfrsp(io);
		putrrec(io, lastin, &resp);	/* out w/modified link */
		lastin = resp.r_next;
		resp.r_next = -1;		/* helps debugging */
		for (i = 0; i < RESPSZ; i++) {
			resp.r_msg[i].m_stat = 0;	/* mark all as undeleted */
		}
	}
	note->n_nresp++;			/* one more response! */
	resp.r_msg[phys] = *msgp;
	if (addtime) {
		time(&note->n_lmod);		/* last modified entire note */
		io->descr.d_lastm = note->n_lmod;
	}

	/* order of these three keeps disk consistent */
	putrrec(io, lastin, &resp);
	putnrec(io, noteno, note);
	putdscr(io, &io->descr);
#ifdef MSGID_INDEX
	putmsgid(io, noteno, note->n_nresp, &note->n_msg);
#endif /* MSGID_INDEX */

	io->nrspwrit++;				/* add count of writes */
	return(note->n_nresp);			/* success */
}

getfrsp(io)
struct io_f *io;
{
	int i;			/* will contain the free pointer */

	x(lseek(io->fidrdx, 0L, 0) < 0, "getfrsp: seek I");
	x(read(io->fidrdx, (char *)&i, sizeof(i)) < sizeof(i), "getfrsp: read");
	i++;				/* next free */
	x(lseek(io->fidrdx, 0L, 0) < 0, "getfrsp: seek II");
	x(write(io->fidrdx, (char *)&i, sizeof(i)) < sizeof(i), "getfrsp: write");
	return(i-1);
}

delresp(io, noteno, resprec, resphys, lockit)
struct io_f *io;
int noteno;
int resprec;
int resphys;
int lockit;
{
	struct resp_f resp;
	struct note_f note;
	if (lockit)
		lock(io, 'n');
	getrrec(io, resprec, &resp);
	if ((resp.r_msg[resphys].m_stat & DELETED) == 0) {
		/* makes sure that someone hasn't zapped at same time */
		resp.r_msg[resphys].m_stat |= DELETED;		/* deleted */
		putrrec(io, resprec, &resp);
		getnrec(io, noteno, &note);
		--note.n_nresp;
		putnrec(io, noteno, &note);
	}
	if (lockit)
		unlock(io, 'n');
	return;
}
