
/*
 *		COPYRIGHT (c) HEWLETT-PACKARD COMPANY, 1984
 *
 *	Permission is granted for unlimited modification, use, and
 *	distribution except that this software may not be sold for
 *	profit.  No warranty is implied or expressed.
 *
 *Author:
 *	Paul Bame, HEWLETT-PACKARD LOGIC SYSTEMS DIVISION - Colorado Springs
 *	{ ihnp4!hpfcla | hplabs | harpo!hp-pcd }!hp-lsd!paul
 */

static char *rcsid = "$Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/strcasecmp.c,v 2.0 89/04/16 01:11:45 gore Exp $";

#include <ctype.h>

#include "macros.h"

/***********************************************************************/

/* FUNCTION */
int
strcasecmp(s,t)
register char *s;
register char *t;
/*
 *	Parameters:
 *		Pointers to strings to compare
 *	Operation:
 *		Return lexicographic(s - t) but do it without sensitivity to
 *		case.  Analogeous to strcmp().
 *	RETURN
 *		0 - strings equal
 *		<0 - t > s
 *		>0 - t < s
 */
{
	register int c;
	while( (c = forcelower(*s++)) == forcelower(*t++) )
	{
		if( c == '\0' )
		{
			break;
		}
	}
	s-- ; t--;
	return( forcelower(*s) - forcelower(*t) );
}


/***********************************************************************/

/* FUNCTION */
int
strncasecmp(s,t,n)
register char *s;
register char *t;
register int n;
/*
 *	Parameters:
 *		Pointers to strings to compare and # chars max to compare
 *	Operation:
 *		Return lexicographic(s - t) but do it without sensitivity to
 *		case.  Analogeous to strncmp().
 *	RETURN
 *		0 - strings equal
 *		<0 - t > s
 *		>0 - t < s
 */
{
	register int c;

	while( --n > 0 )
	{
		if( (c = forcelower(*s)) != forcelower(*t) )
		{
			break;
		}
		if( c == '\0' )
		{
			break;
		}
		s++ ; t++;
	}
	return( forcelower(*s) - forcelower(*t) );
}
