/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/miscio.c,v 2.0 89/04/15 23:57:30 gore Exp $ */

/*
 * Miscellaneous notes functions that deal with user input
 */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>

#define  ABORT_POSTING	'a'
#define     DO_POSTING	'p'
#define REVIEW_POSTING	'l'
#define   EDIT_POSTING	'e'
#define POSTING_PROMPT "p(ost) a(bort) e(dit again) or l(ist): "
#define VALID_POSTING_REPLY(c) (\
				(c) ==  ABORT_POSTING || \
				(c) ==     DO_POSTING || \
				(c) == REVIEW_POSTING || \
				(c) ==   EDIT_POSTING)

/*
 *	tsearch(io, fromnum, grabstring)
 *		search notetitles from note #fromnum backwards
 *	looking for the string in io->xstring. If that string is
 *	empty or grabstring is true, prompt the user for a string.
 *
 *	Returns:	0 if searched and not found
 *			>0 the note number which matched 
 *			-1 null string to search for.
 *
 */
tsearch(io, fromnum, grabstring)
	struct io_f *io;
{
	register int i;
	struct note_f note;
#ifdef __STDC__
	extern char *instr(char*, char*);
#else
	extern char *instr();
#endif

	fromnum -= 1;				/* points to "here" */

	if (grabstring || io->xstring[0] == '\0') {
		prompt("Search String: ");
		i = gline(io->xstring, TITLEN-1);		/* grab one */
		if (i <= 1) {
			io->xstring[0] = '\0';
			return(-1);
		}
	}

	at(0,1);
	ceol();
	prompt("(working)");
	fflush(stdout);
	lcase(io->xstring);
	if (fromnum < 1)
		fromnum = 1;
	if (fromnum > io->descr.d_nnote)
		fromnum = io->descr.d_nnote;

	while (fromnum > 0) {
		getnrec(io, fromnum, &note);
		if (note.n_stat & DELETED) {
			fromnum--;
			continue;
		}
		lcase(note.n_title);
		if (instr(note.n_title, io->xstring))
			return(fromnum);
		fromnum--;
	}
	warn("\"%s\": title pattern not found", io->xstring);
	return(0);
}

/*
 *	asearch(io, notenum, respnum, grabname)
 *	int *notenum, *respnum; struct io_f *io;
 *
 *	searches for an article by the specified author. The author to
 *	look for is kept in io->xauth.
 *	The search starts with note # notenum, and the respnum'th
 *	response of that note.
 *
 *	The search proceeds out to the end of the response chain and
 *	then goes through the previous note and its responses
 *      (Should it go backwards thru the resposes, too?)
 *
 *	Returns:	0 nothing found
 *			>0 Found something. Correct place is in
 *			   notenum and respnum....
 *			-1 did not specify a search string!
 */
asearch(io, notenum, respnum, grabname)
	struct io_f *io;
	int *notenum, *respnum;
{
	struct note_f note;
	struct resp_f rsprec;
	int rblock, i, roffset;
	char auth[BUFLEN];
#ifdef __STDC__
	extern char *instr(char*, char*);
#else
	extern char *instr();
#endif

	if (grabname || (io->xauth[0] == '\0')) {
		prompt("Search author: ");
		i = gline(io->xauth, sizeof (io->xauth));
		if (i <= 1) {
			io->xauth[0] = '\0';
			return(-1);
		}
	}
	lcase(io->xauth);

	*respnum -= 1;			/* don't examine current resp */

	if (*notenum < 1) {
		*respnum = 0;
		*notenum = 1;
	}
	if (*notenum > io->descr.d_nnote) {		/* check boundaries */
		*respnum = note.n_nresp;
		*notenum = io->descr.d_nnote;
	}

	at(0,1);
	ceol();
	prompt("(working)");
	fflush(stdout);

	getnrec (io, *notenum, &note);
	while (*notenum > 0) {
		if ((note.n_stat & DELETED) == 0) {
			for ( ; *respnum >= 0; (*respnum)--) {
			   if (*respnum == 0) {
				gethdr(io, &note.n_msg, note.n_msg.m_from,
					auth);
			   }
			   else {
				if (lrsp(io, *notenum, *respnum, &rsprec,
				    &roffset, &rblock) == -1)
					break;
				gethdr(io, &rsprec.r_msg[roffset],
				    rsprec.r_msg[roffset].m_from, auth);
			    }
			    lcase(auth);
			    if (instr(auth, io->xauth))
				    return(*notenum);
			}
		}
		(*notenum)--;			/* and proceed to next note */
		getnrec (io, *notenum, &note);
		*respnum = note.n_nresp;
	}
	warn("\"%s\": author pattern not found", io->xauth);
	return(0);
}

/*
 *	mailit
 *
 *	takes the text record specified, along with the notefile name,
 *	the author name, (other things added later), and builds a 
 *	temp file. The user is prompted for a list of the people to
 *	send the file to. After an edit session, the mail is sent.
 *
 *	Returns:	-1 if no letter sent
 *			 0 if letter sent (or if it thinks so)
 */

/* whoto - switch for mail desination, others, author, or moderator */
/* wtext - true if mail with text of note */

/*
 * If mailing to moderator, note may be NULL, meaning that a base note
 * is being mailed.
 */
mailit(io, note, msgp, whoto, wtext)
	struct io_f *io;
	struct note_f *note;
	struct msg_f *msgp;
{
	char destaddr[PATHLEN];		/* destination */
	char fn[WDLEN];			/* hold scratch file name */
	FILE *txtfile;
	char hline[BUFLEN];
	struct auth_f *ap;
#ifdef __STDC__
	struct auth_f *parseauth(char*);
	extern char *arpadate(time_t*);
#else
	struct auth_f *parseauth();
	extern char *arpadate();
#endif
#ifdef	PATHALIAS
	char pathstring[CMDLEN];
#endif  PATHALIAS

	sprintf(fn, "%s/nfmXXXXXX", TMPDIR);
	mktemp(fn);
	txtfile = fopen(fn, "w");
	x(txtfile == NULL,
	    "mailit: couldn't open scratch file \"%s\" for writing",
	    fn);
	switch (whoto)
	  {
	  case OTHERS:
	    prompt("Send to whom? ");
	    if (gline(hline, sizeof hline) == 0)
	      return(-1);			/* no letter sent */
	    break;
	    
	  case AUTHOR:
	    if (uucp_mailer) {
	      gethdr(io, msgp, msgp->m_path, hline); /* kludge */
	    } else {
	      /*
	       * This conforms to RFC-822 specifications of automatic
	       * use of "From:", "Reply-To:" and "Sender:" fields.
	       *
	       * We simply test if the "Reply-To:" field exists, and
	       * use it if it does.  It is worth to consider putting
	       * in some "smarts" that would ignore the "Reply-To:"
	       * field in the case when it is not a valid RFC-822
	       * address while the "From:" field is.
	       */

	      gethdr(io, msgp, msgp->m_replyto, hline);
	      if (hline[0] == '\0') {
		gethdr(io, msgp, msgp->m_from, hline);
	      }
	    }
	    break;
	    
	  case MODERATOR:
	    get_moderator(io, hline);
	    break;

	  default:
	    x(1, "mailit: bad value for whoto = %d\n", whoto);
	  }
	ap = parseauth(hline);
	if (strcmp(ap->a_name, ANONYMOUS) == 0) {
		warn("Can't send to %s", ANONYMOUS);
		return(-1);
	}
	if (*ap->a_sys && strcmp(full_hostname, ap->a_sys) != 0) {

#ifdef	PATHALIAS
		if (getpath(ap->a_sys, pathstring, PATHALIAS) >= 0)
			sprintf(destaddr, pathstring, ap->a_name);
		else
#endif  PATHALIAS
		        sprintf(destaddr, "%s@%s", ap->a_name, ap->a_sys);
	} else
		strcpy(destaddr, ap->a_name);
	if (whoto == MODERATOR && note == NULL) {
	    /* Mailing a base note to the moderator */

	    fprintf(txtfile, "To: %s\n", destaddr);

	    prompt ("Note title: ");
	    if (gline(hline, sizeof hline) == 0) {
		return(-1);			/* no note sent */
	    }
	    fprintf(txtfile, "Subject: %s\n", hline);
	    fprintf(txtfile, "Newsgroups: %s\n", io->nf);
	    putc('\n', txtfile);
	    fclose(txtfile);
	} else {
	    fprintf(txtfile, "To: %s\n", destaddr);
	    fprintf(txtfile, "Subject: Re: %s\n", note->n_title);
	    gethdr(io, msgp, msgp->m_ngroup, hline);
	    fprintf(txtfile, "Newsgroups: %s\n", hline);
	    gethdr(io, msgp, msgp->m_artid, hline);
	    fprintf(txtfile, "In-Reply-To: article %s of %s\n", hline,
		    arpadate(&msgp->m_subtime));
	    if (NULL != replyto_address) {
		fprintf(txtfile, "Reply-To: %s\n", replyto_address);
	    }
	    putc('\n', txtfile);
	    if (wtext) {			/* add text if specified */
		preptxt(io, txtfile, msgp);
	    }
	    putc('\n', txtfile);
	    fclose(txtfile);

	} /* else (mailing base note to moderator) */

	prompt("mailing to %s", whoto==MODERATOR ? "the moderator" : destaddr);
	putchar('\n');
	fflush(stdout);
	dounix(mailposter, "-h", fn, NOSTR);
	unlink(fn);		/* don't worry if didn't get it */
	wfchar();
	return(0);
}

/*
 *	talkto(auth, uniq)
 *
 *	see if the author is a local user (by checking the sys field of
 *	the note to see where it was written) and then grab his name from
 *	the auth structure. If he is not "Anonymous", and is local then
 *	we do a 'write name' command to talk with him.
 *
 *	Ray Essick	December 1981
 */

talkto(auth)
char *auth;
{
    int ret;
    struct auth_f *ap, *parseauth();
    char *auth_address;
    char *p;
    int name_len, sys_len;

    ap = parseauth(auth);
    if (strcmp(ANONYMOUS, ap->a_name) == 0) {
	warn("Anonymous author");
	return(0);
    }

    name_len = strlen(ap->a_name);
    sys_len  = strlen(ap->a_sys);
    auth_address = malloc(name_len + sys_len + 1);
    x(auth_address == NULL,
      "talkto: ran out of memory while composing the address '%s@%s'",
      ap->a_name, ap->a_sys);
    strcpy(auth_address, ap->a_name);
    *(auth_address + name_len) = '@';
    strcpy(auth_address + name_len + 1, ap->a_sys);
    prompt("%s %s", writeprog, auth_address);	/* let user know what doing */
    
    putchar('\n');
    fflush(stdout);

    ret = dounix(writeprog, auth_address, NOSTR);
    if (ret != 0)
    	wfchar();
    return(1);
}

/*
 *	get the text for a note/response
 *
 *	Calls unix editor with a unique file name 
 *	Also makes sure the returned text is of 
 *	appropriate size
 */
gettext(io, where, preface)
struct io_f *io;
struct daddr_f *where;				/* where we left it */
FILE * preface;					/* text included in buffer */
{
    FILE *scr;
    int c;
    char fn[WDLEN];				/* scratch file name */
    struct stat sb;
    char desire;

    ++contsigs;

    sprintf(fn, "%s/nfXXXXXX", TMPDIR);
    mktemp(fn);
    if (preface != NULL) {
	x((scr = fopen(fn, "w")) == NULL,
	  "gettext: couldn't open scratch file \"%s\" for writing", fn);
	while ((c = getc (preface)) != EOF) {
	    putc(c, scr);		/* move included text */
	}
	fclose(scr);
    }

    desire = EDIT_POSTING;
    do {
	if (desire == EDIT_POSTING) {
	    putchar('\n');
	    c = dounix(editor, fn, NOSTR);	/* Call the editor */
	    if (c != 0) {
		wfchar();	/* Something went wrong */
		break;
	    }
	} else if (desire == REVIEW_POSTING) {
	    if (stat(fn, &sb) < 0) {
		printf ("\n---------- No note yet -----------\n");
	    } else {
		printf("\n---------- Note starts: ----------\n");
		c = dounix(pager, fn, NOSTR);	/* Call the pager */
		if (c == 0) {
		    printf("----------- Note ends ------------\n");
		} else {
		    printf("------ Could not show note -------\n");
		    /* Just fall through, don't lose the note */
		}
	    }
	}

	do {		/* What now? */
	    prompt(POSTING_PROMPT);
	    desire = gchar(0);
	} while (!VALID_POSTING_REPLY(desire));

    } while (desire != ABORT_POSTING && desire != DO_POSTING);

    if (stat(fn, &sb) < 0) {
	--contsigs;        
	return(0);
    }
    if (sb.st_size == 0) {
	x(unlink(fn) < 0,
	  "gettext: couldn't unlink scratch file \"%s\"", fn);
	--contsigs;
	return(0);
    }
    if (desire == DO_POSTING) {
	x((scr = fopen(fn, "r")) == NULL,
	  "gettext: couldn't reopen scratch file \"%s\" for reading", fn);
	pagein(io, scr, where);			/* move text in */
	fclose(scr);
	x(unlink(fn) < 0, "gettext: couldn't unlink scratch file \"%s\"", fn);
	--contsigs;
	return(1);
    } else { /* ABORT_POST */
	--contsigs;
	return(0);
    }
}
