/* $Header: nfarchive.c,v 1.4 87/08/25 14:04:20 notes Exp $ */

/*
 *	nfarchive - will archive the specified notesfiles. All notes that
 *	have not been modofied in the last n days (default 14, settable
 *	by option on command line) will be archived and placed in
 *	the archive directory.
 *
 *	Ray Essick			March 1982
 */

#include "parms.h"
#include "structs.h"

int     deleteonly;
int     dirmsgflag;
int     daysold;

archone (nfname)
char   *nfname;
{
    return(archiver(nfname, daysold, deleteonly, dirmsgflag));
}


main (argc, argv)
char  **argv;
{
    int     i;
    struct nfile *np;

	initenv();

    if (argc == 1) {
	usage(argv[0]);
	exit (BAD);
    }

    if (globuid != notesuid) {
	printf ("Sorry, only notes 'owner' can archive notes\n");
	exit (BAD);
    }

    deleteonly = 0;			/* default to archiving */
    dirmsgflag = DIRNOCARE;		/* don't consider dirmessage */

    daysold = igetconfig ("Archive-Days");
    if (daysold == -1)			/* not present, take the default */
      daysold = ARCHTIME;		/* default from parms.h */

    for (i = 1; i < argc; i++) {
	if (argv[i][0] == '-') {
	    switch (argv[i][1]) {
		case 'd': 		/* delete only, no archiving */
		    deleteonly = 1;
		    break;

		case 'm': 		/* director message status */
		    if (argv[i][2] == '+')
			dirmsgflag = DIRON;	/* delete only with on */
		    else
			dirmsgflag = DIROFF;	/* only if off */
		    break;

		case '0':
		case '1': 		/* change days old parameter */
		case '2': 
		case '3': 
		case '4': 
		case '5': 
		case '6': 
		case '7': 
		case '8': 
		case '9': 
		    daysold = atoi (&argv[i][1]);
		    break;

		case 'f': 			/* process a file */
		    readrc(argv[++i]);
		    break;

		default: 
		    fprintf (stderr, "Bad switch: %c\n", argv[i][1]);
		    usage(argv[0]);
		    exit (BAD);
	    }
	} else {
	    expand(argv[i]);
	}
    }
    for (np = nfile; np; np = np->n_next) {
	if (np->n_lookat == 1) {
	    archone(np->n_name);
	}
    }
    exit(GOOD);
}

usage(invokedas)
char *invokedas;
{
    fprintf (stderr,
        "Usage: %s [-d] [-m+ or -m-] [-nn] [-f file] topic1 [topic2 ...]\n",
	invokedas);	
}
