/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/readem.c,v 2.0 89/04/16 00:33:18 gore Exp $ */

/*
 *	Handle the basic idea of what to do when you are showing a note.
 *	It displays the note, and then manages to collect enough info
 *	from the terminal to either progress to the next note or
 *	show some of the responses.
 */

#include "parms.h"
#include "structs.h"
#include <signal.h>
#include <sgtty.h>

readem(io, readnum, firstdis, resp)
struct io_f *io;
int *firstdis;
{
	struct note_f note;
	struct resp_f rsprec;
	struct msg_f *msgp;
	struct io_f io2;
	FILE *txtfile;
	FILE *ptxtfile;
#ifdef __STDC__
	FILE *pipeopen(char*, char*);
#else
	FILE *pipeopen();
#endif
	int rrecnum, roffset;
	char tonf[NNLEN];			/* for forwarding */
	char ntitle[TITLEN];		/* scratch space */
	char cmdline[CMDLEN];			/* build-a-command */
	char tmpfile[WDLEN];
	char auth[BUFLEN];
	int c;			/* input char */
	int forward;		/* scroll forward/backward on deleted note */
	int whoto;		/* mail goes to either author or moderator */
	int znum;		/* forward as resp to this note */
	int znote, zresp;	/* scratch for asearch */
	int i;
	int wtext;		/* send mail with text */
	int retcode;
	int retstat;
	int should_continue;
	struct notesenv oldenv;
	char *delfile;

	retcode = -1;		/* init so grabs character */
	retstat = 0;		/* default return code */
	forward = 1;		/* default to scroll forward */
	ignsigs = 0;
	delfile = NULL;
	txtfile = NULL;
	replot = 1;

	oldenv = curenv;
	if (setjmp(jenv)) {
		/* KLUDGE */
		if (txtfile) {
			fclose(txtfile);
			txtfile = NULL;
		}
		if (delfile) {
			unlink(delfile);
			delfile = NULL;
		}
	}

	while (1) {
		x(readnum < 0, "readem: given bad readnum");
		if (readnum > io->descr.d_nnote) {
			readnum = io->descr.d_nnote;
		}
		if (readnum == 0 && io->descr.d_plcy == 0)
			goto out;	/* empty notesfile */
		getnrec(io, readnum, &note);
		if (note.n_stat & DELETED) {
			if (forward)
				goto nextnt;		/* forward scroll */
			else
				goto prevnt;		/* backward scroll */
		}
		if (replot) {
			replot = 0;		/* set later if want replot */
			if (resp) {
				/* response */
				if (resp > note.n_nresp)
					resp = note.n_nresp;
				if (lrsp(io, readnum, resp, &rsprec, &roffset,
				    &rrecnum) == -1) {
					/* bad response chain - use note */
					resp = 0;
					getnrec(io, readnum, &note);
					msgp = &note.n_msg;
				} else
					msgp = &rsprec.r_msg[roffset];
			} else
				msgp = &note.n_msg;
			retcode = dspmsg(io, &note, msgp, resp, readnum);
		}
		forward = 1;
		if (retcode < 0) {
			cmdprompt();		/* no previous command */
			c = gchar(1);
		} else {
			c = retcode;		/* previous command */
			retcode = -1;
		}

		switch (c) {

		case 'z':	/* update sequencer and exit, RLS */
			retstat = QUITUPD;
			goto out;

		case 'u':	/* unsubscribe from this notesgroup, RLS */
			prompt("Do you really want to unsubscribe from this notesfile? (y/n): ");
			if(askyn() != 'y') {
				at(0,1);	/* Bottom row */
				ceol();
				continue;	/* OK, don't unsubscribe */
			}
			at(0,1);
			ceol();
			prompt("(working)");
			fflush(stdout);
			if (unsubscribe(io->nf) < 0)
				continue;
			retstat = QUITSEQ;
			goto out;

		case '?': 		/* if he doesn't know what to type */
		case 'h':
			nfhelp(RDMHLP);		/* print the pseudo-man page */
			replot = 1;
			continue;

		case 'H':			/* print out all headers */
			dumphdr (io, &note, msgp, resp, 0, stdout);
			wfchar ();		/* wait for a character */
			replot = 1;
			continue;
#ifdef DORKBITS
		case '#':			/* Fix up flagbits */
			lock(io,'n');
			getnrec(io, readnum, &note);
			dorkbits (io, &note.n_msg, resp);
			putnrec(io, readnum, &note);
			unlock(io,'n');
			replot = 1;
			continue;
#endif /* DORKBITS */
		case 'D': 			/* delete this note/response */
			if (!mynote(io, msgp)) {
				warn("Not your message, can't delete");
				continue;
			}
			if (readnum == 0) {
				warn("Use 'Z' to delete policy");
				continue;
			}

			prompt("Delete? ");
			if (askyn() == 'n')
				continue;
			lock(io, 'n');
			/* this should catch most */
			getnrec(io, readnum, &note);
			/* and an up to date descriptor */
			getdscr(io, &io->descr);
			if (msgp->m_rcvtime < io->descr.d_lstxmit) {
				warn("Can't delete: has already been sent out to the network");
				unlock(io, 'n');
				continue;
			}
			if (resp) {		/* go about deleting it */
				if (resp != note.n_nresp) {
					warn("not last response, can't delete");
					unlock(io, 'n');
					continue;
				}
				delresp(io, readnum, rrecnum, roffset, 0);
				/* adjust note response count */
				note.n_nresp--;
				unlock(io, 'n');
				/* show next response */
				replot = 1;
				continue;
			}
			/* it's a note */
			if (note.n_nresp) {
				warn("note has responses, can't delete");
				unlock(io, 'n');
				continue;
			}
			delnote(io, readnum, 0);
			readnum++;
			resp = 0;
			unlock(io, 'n');
			replot = 1;
			continue;

		case 'E': 				/* edit an article */
			if (!mynote(io, msgp)) {
				warn("Not your message, can't edit");
				continue;
			}
			if (readnum == 0) {
		warn("Sorry, E doesn't work for policy notes yet");
				continue;
			}

			lock(io, 'n');
			getnrec(io, readnum, &note);
			/* this should catch most */
			getdscr(io, &io->descr);
			/* and an up to date descriptor */
			if (msgp->m_rcvtime < io->descr.d_lstxmit) {
				warn("note has already been sent out to the network, can't edit");
				unlock(io, 'n');
				continue;
			}
			if (resp) {		/* go about deleting it */
				if (resp != note.n_nresp) {
					warn("not last response, can't edit");
					unlock(io, 'n');
					continue;
				}
				delresp(io, readnum, rrecnum, roffset, 0);
				/* adjust note response count */
				note.n_nresp--;
				unlock(io, 'n');
				sprintf(tmpfile, "%s/nfeXXXXXX", TMPDIR);
				mktemp(tmpfile);
				delfile = tmpfile;
				/* build scr file */
				txtfile = fopen(tmpfile, "w");
				x(txtfile == NULL,
				    "readem: can't open scratch file \"%s\" for writing",
				    tmpfile);
				pageout(io, &msgp->m_addr, txtfile);
				/* dump it */
				fclose(txtfile);  /* also flushes it */
				txtfile = fopen(tmpfile, "r");
				x(txtfile == NULL,
				    "readem: can't reopen scratch file \"%s\" for reading",
				    tmpfile);
				/* add it back in ! */
				resp = addresp(io, txtfile, readnum);
				fclose(txtfile);
				txtfile = NULL;
				/* up to date */
				getnrec(io, readnum, &note);
				x(unlink(tmpfile) < 0,
				    "readem: can't unlink scratch file \"%s\"",
				    tmpfile);
				delfile = NULL;
				continue; /* show next response */
			}
			/* its a note */
			if (note.n_nresp) {
				warn("note has responses, can't edit");
				unlock(io, 'n');
				continue;
			}
			delnote(io, readnum, 0);
			readnum++;
			resp = 0;
			unlock(io, 'n');
			sprintf(tmpfile, "%s/nfeXXXXXX", TMPDIR);
			mktemp(tmpfile);
			delfile = tmpfile;
			/* build scr file */
			x ((txtfile = fopen(tmpfile, "w")) == NULL,
			    "readem: can't open scratch file \"%s\" for writing",
			    tmpfile);
			pageout(io, &msgp->m_addr, txtfile);
			/* dump it */
			fclose(txtfile);	/* also flushes it */
			x((txtfile = fopen(tmpfile, "r")) == NULL,
			    "readem: can't reopen scratch file \"%s\" for reading",
			    tmpfile);
			znum = addnote(io, txtfile, "Edit note text:",
			    "Note title: ");
			fclose(txtfile);
			txtfile = NULL;
			x(unlink(tmpfile) < 0,
			    "readem: can't unlink scratch file \"%s\"",
			    tmpfile);
			delfile = NULL;
			if (znum > 0)
				readnum = znum;	/* this is the one */
			continue;

		case 'Z': 	/* zap notes/responses - directors only */
			/* kills any note/response */
			getdscr(io, &io->descr);  /* up to date descriptor */
			if (allow(io, DRCTOK) == 0) {
				warn("Not a director, can't zap");
				continue;
			}

			prompt("Delete? ");
			if (askyn() == 'n')
				continue;
			/*
			 *	should log the deletion here, so the
			 *	"meta-director" can watch for fascist
			 *	directors preying on the peasants.
			 */
			if (readnum == 0) {		/* deleting policy */
				lock(io, 'n');
				getdscr (io, &io->descr);  /* grab up-to-date */
				io->descr.d_plcy = 0;	/* its gone now */
				/* replace descriptor */
				putdscr(io, &io->descr);
				unlock(io, 'n');
				goto out;
			}
			if (resp) {			/* delete a response */
				delresp(io, readnum, rrecnum, roffset, 1);
				/* kill it */
				note.n_nresp--;		/* and response count */
			} else {
				delnote(io, readnum, 1);
				readnum++;
			}
			replot = 1;
			continue;

		case 'r': 	/* replot the current note/response */
		case '\014':	/* everyone else uses ^L, might as well */
			replot = 1;
			continue;

		case '\n': 			/* wants the next note */
			goto nextnt;

		case 'm': 		/* mail a note/response via Unix mail */
			whoto = 0;
			wtext = OTHERS;		/* to others and no text */
			goto sendmail;
		case 'M': 			/* same as 'm' but with text */
			whoto = OTHERS;
			wtext = 1;		/* to others with text */
			goto sendmail;
		case 'P': 
			whoto = AUTHOR;
			wtext = 1;		/* to author with text */
			goto sendmail;
		case 'p': 
			whoto = AUTHOR;
			wtext = 0;		/* to author, no text */

		sendmail:
			/* jump to here once set mail parms */
			mailit(io, &note, msgp, whoto, wtext);
			continue;

		case '!': 			/* wants to fork a shell */
			gshell();
			continue;

		case 'q': 		/* quit this, maybe whole system */
		case 'k': 
			retstat = QUITSEQ;
			goto out;

		case '\04':        			/* control D */
			retstat = QUITFAST;
			goto out;

		case 'Q': 	/* exit system without updating sequencer */
		case 'K': 
			retstat = QUITNOSEQ;
			goto out;

		case 'i': 			/* go back to note index */
			*firstdis = readnum;
			goto out;

		case '\010': 
		case '-': 			/* display previous response */
			resp--;
			if (resp >= 0) {
				replot = 1;
				continue;	/* show the base note */
			}
			goto prevnt;

		case 'x': 
		case 'X': 
			/* title search from current spot */
			if (readnum == 0)
				goto out;
			i = tsearch(io, readnum, c == 'x');
			/* look it up */
			if (i > 0) {
				readnum = i;
				resp = 0;
				replot = 1;
			}
			continue;

		case 'a': 
		case 'A':
			/* author search from current spot */
			if (readnum == 0)
				goto out;
			znote = readnum;
			zresp = resp;
			if (asearch(io, &znote, &zresp, (c == 'a')) > 0) {
				readnum = znote;
				resp = zresp;	/* set returned values */
				/* grab right descriptor */
				getnrec(io, readnum, &note);
				replot = 1;
			}
			continue;

		case 'd': 		/* toggle a notes director status */
			if (allow (io, DRCTOK) == 0) {
				prompt("Anonymous: %s	Networked: %s",
				    (io->descr.d_stat & ANONOK) ? "YES" : "NO",
				    (io->descr.d_stat & NETWRKD) ? "YES" : "NO");
				continue;
			}
			if (resp == 0) {		/* toggle a note */
				lock(io, 'n');
				getnrec(io, readnum, &note);
				if (msgp->m_stat & DIRMES)
					msgp->m_stat &= ~DIRMES;
				else
					msgp->m_stat |= DIRMES;
				putnrec(io, readnum, &note);    /* replace */
				unlock(io, 'n');
				replot = 1;
				continue;
			}
			/* toggle a response */
			lock(io, 'r');		/* ENTER CRITICAL */
			/* grab that block */
			getrrec(io, rrecnum, &rsprec);
			if (msgp->m_stat & DIRMES)
				msgp->m_stat &= ~DIRMES;
			else
				msgp->m_stat |= DIRMES;
			putrrec(io, rrecnum, &rsprec, readnum, resp);  /* replace */
			unlock(io, 'r'); 	/* EXIT CRITICAL */
			replot = 1;
			continue;

		case 'e': 		/* allow him to edit his title */
			if (readnum == 0)
				continue;		/* don't touch */
			if (resp) {
				warn("Not reading note, can't edit title");
				continue;
			}
			if (!mynote(io, msgp)) {
				/* other sys */
				warn("Not your note, can't edit title");
				continue;
			}
			/* an up to date descriptor */
			getdscr(io, &io->descr);
			if (msgp->m_rcvtime < io->descr.d_lstxmit) {
				warn("note has already been sent out to the network, can't edit");
				continue;
			}
			prompt("New Title: ");
			if (gline(ntitle, TITLEN) == 0)
				/* empty title, leave alone */
				continue;
			lock(io, 'n');
			getnrec(io, readnum, &note);	/* well, update it */
			strcpy(note.n_title, ntitle);
			putnrec(io, readnum, &note);  /* and replace */
			unlock(io, 'n');
			replot = 1;
			continue;

		case 't':		/* talk to the author of a note */
			gethdr(io, msgp, msgp->m_from, auth);
			replot = talkto(auth);
			continue;

		case 'W': 		/* write a response with the text */
		case 'w': 		/* let him write a response */
			getdscr(io, &io->descr);	/* get up to date */
			if (allow(io, RESPOK) == 0) {
				warn("Sorry, you are not allowed to write responses in this notesfile");
				continue;	/* back to key processing */
			}
			if (readnum == 0) {
				warn("No responses allowed to policy note");
				continue;
			}

			if (is_moderated(io))
			  {
			    warn("This notesfile is moderated and may not be posted to directly.\n");
			    whoto = MODERATOR;
			    wtext = (c == 'W') ? 1 : 0 ;
			    mailit(io, &note, msgp, whoto, wtext);
			    continue;
			  }

			/* OK, this is a normal notesfile */
			if (c == 'w') {
				txtfile = NULL;		/* no preface text */
			} else {
				sprintf(tmpfile, "%s/nfxXXXXXX", TMPDIR);
				mktemp(tmpfile);
				delfile = tmpfile;
				x((txtfile = fopen(tmpfile, "w")) == NULL,
				    "readem: can't open scratchfile \"%s\" for writing",
				    tmpfile);
				preptxt(io, txtfile, msgp);
				fclose(txtfile);
				x ((txtfile = fopen(tmpfile, "r")) == NULL,
				    "readem: can't reopen scratchfile \"%s\" for reading",
				    tmpfile);
			}
			zresp = addresp(io, txtfile, readnum); /* put it in */
			if (zresp > 0) {
				/* update descriptor */
				getnrec(io, readnum, &note);
			}

			if (txtfile != NULL) {
				fclose(txtfile);	/* toss out scratch */
				txtfile = NULL;
				x(unlink(tmpfile) < 0,
				    "readem: couldn't unlink scratch file \"%s\"",
				    tmpfile);
				delfile = NULL;
			}
			if (zresp)
				resp = zresp;		/* show the new */
			continue;

		case 'B':			/* bitch, bitch, bitch */
			/* check gripe file */
			if (init(&io2, GRIPES) < 0) {
				warn ("The gripe file \"%s\" doesn't exist",
				    GRIPES);
				continue;
			}
			/* let him put the note in */
			addnote(&io2, (FILE *)0, "Edit Gripe text:",
			    "Gripe Header: ");
			finish(&io2);	/* close up the gripe file */
			continue;

		case 'C': 	/* copy to other notefile with text */
		case 'c':	/* copy to other notefile without text */
			if (c == 'C')
				wtext = 1;
			else
				wtext = 0;		/* determine which */
			prompt("Forward to: ");
			if (gline(tonf, NNLEN) == 0)
				continue;
			if (init(&io2, tonf) < 0) {
				warn("Can't find notesfile %s", tonf);
				continue;
			}
			if (wtext == 0) {
				txtfile = NULL;
			} else {
				sprintf(tmpfile, "%s/nfxXXXXXX", TMPDIR);
				mktemp(tmpfile);
				delfile = tmpfile;
				x ((txtfile = fopen(tmpfile, "w")) == NULL,
				    "readem: couldn't open scratch file \"%s\" for writing",
				    tmpfile);
				preptxt(io, txtfile, msgp);
				fclose(txtfile);	/* close it */
				x ((txtfile = fopen(tmpfile, "r")) == NULL,
				    "readem: couldn't reopen scratch file \"%s\" for reading",
				    tmpfile);
			}
			c = 'n';			/* default to note */
			if (allow(&io2, WRITOK) && allow (&io2, READOK) &&
			    allow(&io2, RESPOK)) {
				prompt("Forward as response? ");
				c = askyn();
			}
			if (c == 'n' && allow(&io2, WRITOK)) {
				addnote(&io2, txtfile, "Edit forwarded text:",
				    "Forwarded Title: ");
			} else if (c == 'y') {
				if (znum = limindex(&io2)) {
					addresp(&io2, txtfile, znum);
				}
			} else
				warn ("You haven't permission");
			if (strcmp(io->nf, io2.nf) == 0) {
				/* if was this notefile */
				/* get new descriptor */
				getdscr(io, &io->descr);
			}
			finish(&io2);		/* close up that notefile */
			if (txtfile != NULL) {
				fclose(txtfile);	/* throw it away */
				txtfile = NULL;
				x(unlink(tmpfile) < 0,
				    "readem: couldn't unlink scratch file \"%s\"",
				    tmpfile);
				delfile = NULL;
			}
			continue;

		case 'n': 			/* nest notesfiles - a stack */
			prompt("New notesfile: ");
			if (gline(tonf, NNLEN) == 0)
				continue;
			closenf(io);				/* save fids */
			i = control(tonf, NOSEQ | terse?TERSE:0, (time_t)0);
			if (opennf(io, io->nf) < 0) {
				warn("Couldn't reopen notesfile");
				wfchar();
				retstat = QUITNOSEQ;
				goto out;
			}
			if (i == QUITBAD || i == QUITNEX) {
				warn("Can't open notesfile `%s'", tonf);
				continue;
			}
			if (i == QUITFAST || i == QUITUPD) {
				retstat = i;
				goto out;
			}
			replot = 1;
			continue;

		case 'N':		/* goto particular note */
			prompt("Read note > ");
			c = gchar(0);
			if (c < '0' || c > '9')
				continue;
			if ((znum = getnum(c)) == 0)
				continue;
			readnum = znum;
			replot = 1;
			continue;

		case 's': 		/* place text at end of 'nfsave' */
		case 'S': 		/* place the whole string */
			prompt("File name: ");
			if (gline(tmpfile, WDLEN) == 0)
				continue;
			savefile(io, tmpfile, readnum, c == 'S' ? -1 : resp);
			continue;
		case '|':		/* pipe into command */
		case '^':		/* whole string into command */
		case '%':		/* joke translator */
			switch (c) {
			case '|':
			case '^':
				prompt("Command: ");
				if (gline(cmdline, CMDLEN) == 0)
					continue;
				printf("\nStarting up...\n");
				break;
			case '%':
				prompt("Translation...");
				putchar('\n');
				strcpy(cmdline, TRANSLATE);
				break;
			}
			fflush(stdout);
			if ((ptxtfile = pipeopen(cmdline, "w")) == NULL) {
				warn("pipe open failed");
				continue;
			}
			saveit(io, ptxtfile, readnum, c == '^' ? -1 : resp);
			pipeclose();
			wfchar();
			replot = 1;
			continue;

		case 'j': 			/* go on to next note/resp */
		case 'l': 			/* universal seq, RLS */
			if (readnum == 0)
				goto out;
			should_continue = 0;
			while ((resp != note.n_nresp) && /* last resp */
			       (resp != -1))		 /* no such resp */
			    if ((resp = nxtmsg(io, readnum, resp, io->stime)) >= 0)
			      {
				replot = 1;
				should_continue = 1;
				break;
			      }
			if (should_continue == 1) continue;
			/* fall into ... */

		case 'L':
		case 'J': 				/* next unread note */
			if (readnum == 0)
				goto out;

/* If "last modified" > sequencer, there MUST be a note-or-resp to read.*/
/*
 *  Code used to read like this:
 *
 *                      if ((readnum = nxtnote(io, readnum, io->stime)) > 0 &&
 *                          (resp = nxtmsg(io, readnum, -1, io->stime)) >= 0) {
 *                              replot = 1;
 *                              continue;
 *                      }
 *
 *
 *  Change so that when there is no recent message in this notestring,
 *  we go on to the next. (Can happen when a response is deleted.)
 */
			should_continue = 0;
			while ((readnum = nxtnote(io, readnum, io->stime)) > 0 )
			  if ((resp = nxtmsg(io, readnum, -1, io->stime)) >= 0)
			    {
			      replot = 1;
			      should_continue = 1;
			      break;
			    }
			if (should_continue == 1) continue;
			if (c == 'l' || c == 'L')
				retstat = QUITSEQ;
			else
				/* put him on last page */
				*firstdis = io->descr.d_nnote;
			goto out;

		case '+': 
		case ';': 
		case ' ': 
			if (readnum == 0)
				/* such is the fate of policy notes */
				goto out;
			resp++;
			if (resp > note.n_nresp)
				goto nextnt;
			replot = 1;
			continue;

		case '0':
		case '=': 			/* go back to the base note */
			if (resp == 0) {
				warn("Already on base note");
				continue;
			}
			resp = 0;		/* reset index into responses */
			replot = 1;
			continue;

		case '1': 			/* skip n responses */
		case '2': 
		case '3': 
		case '4': 
		case '5': 
		case '6': 
		case '7': 
		case '8': 
		case '9': 
			if (note.n_nresp < 1)
				goto nextnt;
			/* let him skip all over responses */
			prompt("Read response > ");
			if ((znum = getnum(c)) == 0)
				continue;
			resp = znum;
			replot = 1;
			continue;

		default: 		/* something we haven't covered */
			/* so can jump down here */
			warn("q to quit, ? for help");
			continue;
		}

	nextnt: 
		if (readnum == 0)
			goto out;
		if (++readnum > io->descr.d_nnote) {
			*firstdis = io->descr.d_nnote;
			goto out;
		}
		resp = 0;		/* reset response index */
		replot = 1;
		continue;

	prevnt:
		/* display previous note */
		if (readnum == 0)
			goto out;
		/* set to scroll backwards on deleted note */
		forward = 0;
		if (--readnum < 1) {
			/* zero is policy, so stop at 1 */
			readnum = 1;
			forward = 1;	/* bounce off bottom end */
		}
		resp = 0;		/* was else resp = 0; */
		replot = 1;
		continue;
	}
	/*NOT REACHED*/
out:
	ignsigs++;
	curenv = oldenv;
	ignsigs = 0;

	return(retstat);
}

mynote(io, msgp)
	struct io_f *io;
	struct msg_f *msgp;
{
	char auth[BUFLEN];
	struct auth_f *ap;
#ifdef __STDC__
	struct auth_f *parseauth(char*);
	char *getname(int);
#else
	struct auth_f *parseauth();
	char *getname();
#endif

	gethdr(io, msgp, msgp->m_from, auth);
	ap = parseauth(auth);
	if (strcmp(ap->a_name, getname(0)) == 0 &&
	    strcmp(ap->a_sys, full_hostname) == 0)
		return(1);
	if (allow(io, DRCTOK))
		return(1);
	return(0);
}

#ifdef DORKBITS
dorkbits (io, msgp, resp)
     struct io_f *io;
     struct msg_f *msgp;
{
  int c;
  int done = 0;

  while(!done)
    {
      printf("%s", msgp->m_stat & FRMNEWS	? "FRMNEWS, "	: "");
      printf("%s", msgp->m_stat & DIRMES	? "DIRMES, "	: "");
      printf("%s", msgp->m_stat & DELETED	? "DELETED, "	: "");
      printf("%s", msgp->m_stat & CONTINUED	? "CONTINUED, "	: "");
      printf("%s", msgp->m_stat & WRITONLY	? "WRITONLY, "	: "");
      printf("%s", msgp->m_stat & ORPHND	? "ORPHND, "	: "");
      putchar('\n');

      printf("Toggle bits -- f:FRMNEWS, c:CONTINUED, w:WRITONLY, o:ORPHND, q:quit\n");
      c = gchar(1);
      switch(c)
	{
	case 'f':
	  msgp->m_stat ^= FRMNEWS;
	  break;
	case 'c':
	  msgp->m_stat ^= CONTINUED;
	  break;
	case 'w':
	  msgp->m_stat ^= WRITONLY;
	  break;
	case 'o':
	  msgp->m_stat ^= ORPHND;
	  break;
	case 'q':
	  done = 1;
	  break;
	default:
	  printf("Try one of f, c, w, o, or q.\n");
	}
    }
}
#endif /* DORKBITS */
