//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TextAttribute
//	Include File:	textattr.h
//	Purpose:	Implement a way of giving a WWW style of attribute to
//			a segment of a stream of data.
//	Remarks/Portability/Dependencies/Restrictions:
//		The difference between the start and end of an attribute is
//		called extent.  Extent can be considered a correlation to
//		calling strlen on a string.
//		An extent of 0 means no duration, 1 means 1 byte, etc...
//		A negative extent is equivalent to 0 extent.
//		Once an attribute type is set by the constructor, it can
//		never be changed.
//	Revision History:
//		02-01-94	created
//		02-09-94	Split all members into seperate files.
#include"textattr.h"

TextAttribute::TextAttribute(const HTStyle *HTSp, const signed long int
	sli_Offset, const signed long int sli_OffsetPlusExtent)	{
//	Purpose:	Construct a TextAttribute object defaulting to a
//			style.
//	Arguments:	HTCAp			Points to the style.
//			sli_Offset		The offset into a stream.
//			sli_OffsetPlusExtent	The ending in a stream.
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//		Defaults to a style attribute.
//	Revision History:
//		02-01-94	created

	//	Set the offset.
	sli_StreamOffset = sli_Offset;
	//	Set the extent.
	sli_StreamExtent = sli_OffsetPlusExtent;
	//	Set the type.
	AT_StreamType = style;
	//	Set the anchor pointer.
	HTSp_style = HTSp;
}
