//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDiskView
//	Include File:	tdiskvie.h
//	Purpose:	Provide a view of free temporary disk space.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-18-94	created
#include"tdiskvie.h"
#include"globals.h"
#include<dos.h>
#include<dir.h>
#include<ctype.h>

unsigned long int TDiskView::GetDiskFree()	{
//	Purpose:	Determine the amount of free disk space in the
//			temporary directory.
//	Arguments:	void
//	Return Value:	unsigned long int	The amount of free space.
//	Remarks/Portability/Dependencies/Restrictions:
//		Creates a temporary file name and splits it to find out
//		exactly where the directory to size is.
//	Revision History:
//		02-18-94

	//	Create the temporary file name.
	TTempName TTN(::cp_TempDir);

	//	Determine the drive from the temporary file name.
	char ca_drive[MAXDRIVE];
	int i_drive = 0;
	int i_fns = fnsplit(TTN.getName(), ca_drive, NULL, NULL, NULL);
	if(i_fns & DRIVE)	{
		i_drive = toupper(ca_drive[0]) - 'A' + 1;
	}

	//	Obtain the amount of free disk space.
	struct dfree df_info;
	getdfree(i_drive, &df_info);

	//	Return the information.
	return((unsigned long int)df_info.df_avail * (unsigned long int)
		df_info.df_bsec * (unsigned long int)df_info.df_sclus);
}