/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* htimp.h - general include file for htimp
 *
 * Jim McBeath, November 18, 1993
 */

#include <string.h>

#define DEFAULT_SERVER_ROOT "/usr/local/etc/httpd"
#define DEFAULT_IMP_ROOT "htimp"	/* relative to SERVER_ROOT */
#define CONF_FILE_NAME "htimp.cf"	/* relative to IMP_ROOT */
#define DEFAULT_APP_CONF_DIR "htimp.d"	/* relative to IMP_ROOT */
#define DEFAULT_APP_BIN_DIR "htimp.bin"	/* relative to IMP_ROOT */
#define DEFAULT_SCRIPT_FULL_NAME "/cgi-bin/htimp"	/* in URLs */
#define DEFAULT_IMP_PORT 82
#define DEFAULT_CHECK_INTERVAL 60

/* CommandInfo is used to hold the parsed command line information */
typedef struct _commandinfo {
	int mode;	/* the request mode */
#define MODE_START 1		/* start up a new job */
#define MODE_TALK 2		/* talk to an existing job */
#define MODE_QUIT 3		/* shut down existing job */
	char *app;	/* path to the application to start */
	char *handle;	/* handle for existing application */
	char *str;	/* data string for application */
} CommandInfo;

/* Describe operations available in conf files */
typedef struct _opinfo {
	char *name;
	int callstyle;
#define CALL_I 1	/* single int */
#define CALL_DI 2	/* data pointer and int */
#define CALL_N 3	/* single natural (non-neg) int */
#define CALL_DN 4	/* data pointer and non-neg int */
#define CALL_S 5	/* single string */
#define CALL_DS 6	/* data pointer and string */
	void (*func)();
} OpInfo;

extern void *ImpMalloc();
extern void *ImpRealloc();
extern void ImpFree();
extern char *ImpStrSave();

/* end */
