      SUBROUTINE CHOTST (ER, FP, TM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C   CHOLSKY TEST PROGRAM
C
      PARAMETER (IDA=250, NMAT=250, M=4, N=40, NRHS=3, F7=78125.,
     $ T30=1073741824.)
      COMMON /ARRAYS/ A(0:IDA, -M:0, 0:N), B(0:NRHS, 0:NMAT, 0:N),
     $   AX(0:IDA, -M:0, 0:N), BX(0:NRHS, 0:NMAT, 0:N)
      DATA  IT/200/, ANS/5177.88531774562/
C
C   INITIALIZE
C
      LA = (IDA+1) * (M+1) * (N+1)
      LB = (NRHS+1) * (NMAT+1) * (N+1)
      T = F7 / T30
      DO 100 K = 0, N
        DO 100 J = -M, 0
          DO 100 I = 0, IDA
            T = MOD (F7 * T, 1.0D0)
            AX(I,J,K) = T
100     CONTINUE
      DO 110 K = 0, N
        DO 110 J = 0, NMAT
          DO 110 I = 0, NRHS
            T = MOD (F7 * T, 1.0D0)
            BX(I,J,K) = T
110   CONTINUE
      TM = CPTIME ()
C
C   BEGIN TIMING TEST
C
      DO 120 J = 1, IT
        CALL COPY (LA, AX, A)
        CALL COPY (LB, BX, B)
        CALL CHOLSKY (IDA, NMAT, M, N, A, NRHS, IDA, B)
120   CONTINUE
C
      TM = CPTIME ()
      ER = ABS ((B(1,19,19) - ANS) / ANS)
      FP = IT * (NMAT + 1) * 4403.
C
      RETURN
      END
