      SUBROUTINE GMTRY
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C  COMPUTE SOLID-RELATED ARRAYS,  GAUSS ELIMINATE THE MATRIX OF WALL
C  INFLUENCE COEFFICIENTS.
C
C    11/30/84  D H BAILEY    REVISED CODE FOR NAS KERNEL TEST
C
      PARAMETER (NW=100, NB=5)
      COMPLEX WALL, ZCR, PROJ, ZI, Z1, ZZ
      COMMON /ARRAYS/ NWALL(NB), IALIGN,
     $     WALL(NW,NB), RMATRX(NW*NB,NW*NB),
     $ ZCR(NW,NB), PROJ(NW,NB), XMAX(NB)
C
      DATA  ARCL /5./, PI /3.141592653589793/, PERIOD/3./
C
C  COMPUTE ARCLENGTH.
C
      MATDIM = 0
      ARCL = 0.
      YMIN = 1.E+50
      YMAX = -1.E+50
      PIDP = PI / PERIOD
C
      DO 9 L = 1, NB
        MATDIM = MATDIM + NWALL(L)
        DO 9 K = 1,NWALL(L)
          ARCL = ARCL + ABS(WALL(K,L) - WALL(1+MOD(K,NWALL(L)), L))
9     CONTINUE
C
C  COMPUTE CORE RADIUS.
C
      R0 = ARCL / (MATDIM*2.)
      SIGMA = R0 / 2.
C
C  DEFINE CREATION POINTS.
C
      DO 6 L = 1,NB
        DO 5 K = 1,NWALL(L)
          ZZ = WALL(1+MOD(K+NWALL(L)-2,NWALL(L)), L)
     &         - WALL(1+MOD(K,NWALL(L)), L)
          ZCR(K,L) = WALL(K,L) + CMPLX(0.0D0, R0/ABS(ZZ)) * ZZ
5       CONTINUE
C
C  CHECK THAT WALL AND CREATION POINTS ARE NOT CROSSED DUE TO
C  TOO SHARP A CONCAVE KINK OR AN ERROR IN DEFINING THE BODY.
C  ALSO FIND HIGHEST,  LOWEST AND RIGHT-MOST POINT.
C
        XMAX(L) = REAL(ZCR(1,L))
        LS = 0
        DO 6 K = 1,NWALL(L)
          YMIN = MIN (YMIN, DBLE(AIMAG(ZCR(K,L))))
          YMAX = MAX (YMAX, DBLE(AIMAG(ZCR(K,L))))
          XMAX(L) = MAX (XMAX(L), DBLE(REAL(ZCR(K,L))))
          KP = 1 + MOD(K, NWALL(L))
          IF (REAL((ZCR(KP,L) - ZCR(K,L)) *
     &        CONJG(WALL(KP,L) - WALL(K,L))).GT.0.) THEN
            LS = L
            KS = K
          ENDIF
6     CONTINUE
C
C       IF (LS .NE. 0) THEN
C         WRITE (6, 102) LS, KS
C102      FORMAT(" ON BODY NUMBER ", I3, " YOU HAVE TOO SHARP A",
C     &      " KINK NEAR POINT ", I4)
C         STOP
C       ENDIF
C
C  THE "MAIN PERIOD" WILL BE BETWEEN YLIMIT AND YLIMIT + PERIOD.
C
      YLIMIT = (YMIN - PERIOD + YMAX)/2
C
C  PROJECT CREATION POINTS INTO MAIN PERIOD. THIS IS TECHNICAL.
C
      DO 1 L = 1,NB
        DO 1 K = 1,NWALL(L)
          PROJ(K,L) = ZCR(K,L) - CMPLX(0.0D0, PERIOD*
     &           (INT(5. + 
     &  (AIMAG(ZCR(K,L)) - YLIMIT) / PERIOD) - 5.0D0))
1     CONTINUE
C
C   COMPUTE MATRIX.
C
      SIG2 = (2. * PIDP * SIGMA) ** 2
      I0 = 0
      DO 2 L1 = 1,NB
        J0 = 0
        DO 4 L2 = 1,NB
          KRON = 0
          IF (L1 .EQ. L2) KRON = 1
          DO 3 J = 1,NWALL(L2)
            RMATRX(I0+1,J0+J) = KRON
            Z1 = EXP ((WALL(1,L1) - ZCR(J,L2)) * PIDP)
            Z1 = Z1 - 1. / Z1
            DUM = SIG2 + REAL(Z1)**2 + AIMAG(Z1)**2
            DO 3 I = 2,NWALL(L1)
              ZI = EXP ((WALL(I,L1) - ZCR(J,L2)) * PIDP)
              ZZ = ZI - 1. / ZI
              RMATRX(I0+I,J0+J) = -0.25 / PI * LOG (DUM /
     &              (SIG2 + REAL(ZZ) ** 2 + AIMAG(ZZ) ** 2))
3         CONTINUE
          J0 = J0 + NWALL(L2)
4       CONTINUE
        I0 = I0 + NWALL(L1)
2     CONTINUE
C
C  GAUSS ELIMINATION
C
      DO 8 I = 1, MATDIM
        RMATRX(I,I) = 1. / RMATRX(I,I)
        DO 8 J = I+1, MATDIM
          RMATRX(J,I) = RMATRX(J,I) * RMATRX(I,I)
          DO 8 K = I+1, MATDIM
            RMATRX(J,K) = RMATRX(J,K) - RMATRX(J,I) * RMATRX(I,K)
8     CONTINUE
C
      RETURN
      END
