#include "globals.h"
#include "object.h"
#include "hdf.h"


char *ObjectKinds[] = {
	"ImageObject",
	"CounterObject",
	""
	};

int ObjSize[] = {
	sizeof(Image),
	sizeof(Counter)
};


Object *LoadImage(), *LoadCounter();


ObjectHandler LoadObj[] = {
	LoadImage,
	LoadCounter
};


Object *LoadObject(fName, dfile, objectRef)
char	*fName, *dfile;
int	objectRef;
{
	char *dataPtr, *stringPtr, *scanPtr;
	int kind, length;
	Object *theObject;
	
	dataPtr = mDFgetelement(fName, dfile, LAYBAT_TAG, objectRef, &length, NULL);
	if(dataPtr == NULL)
		return(NULL);
	stringPtr = dataPtr;
	kind = getToken(&stringPtr, &scanPtr, ObjectKinds) - 1;
	if(kind < 0) {
		free(dataPtr);
		printf("Error Reading file %s.", fName);
		return(NULL);
	}
	theObject = (Object *)mMalloc(ObjSize[kind]);
	if(theObject != NULL) {
		theObject->kind = kind;
		sscanf(scanPtr, "%u, %u, %u, %u, %u",
			&theObject->mask.bounds.top, &theObject->mask.bounds.left,
			&theObject->mask.bounds.bottom, &theObject->mask.bounds.right,
			&theObject->maskRigNo);
		theObject = (Object *)((LoadObj[kind]) (theObject, stringPtr));
	}
	free(dataPtr);
	return(theObject);

}


#define	SEQNUMBER		1
#define CONTOURON		2
#define CONTMAX			3
#define CONTMIN			4
#define CONTEVEN		5
#define CONTCOLOR		6
#define CONTBACK		7
#define CONTLIST		8
#define CONTTRANS		9
#define CONTCLORED		10

char *ImageTokens[] = {
	"seqNumber",
	"contourOn",
	"cont.max",
	"cont.min",
	"cont.even",
	"cont.color",
	"cont.back",
	"cont.list",
	"cont.tParent",
	"cont.colorPlot",
	""
	};

Object *LoadImage(image, stringPtr)
	Image *image;
	char *stringPtr;
{
	char *scanPtr;
	int token, i;

	
	while((token = getToken(&stringPtr, &scanPtr, ImageTokens)) != EOS) {
		switch(token) {
			case SEQNUMBER:
				sscanf(scanPtr, "%u", &image->seqNumber);
				break;
			case CONTOURON:
				sscanf(scanPtr, "%u", &image->contourOn);
				break;
			case CONTMAX:
				sscanf(scanPtr, "%u", &image->cont.max);
				break;
			case CONTMIN:
				sscanf(scanPtr, "%u", &image->cont.min);
				break;
			case CONTEVEN:
				sscanf(scanPtr, "%u", &image->cont.even);
				break;
			case CONTCOLOR:
				sscanf(scanPtr, "%u", &image->cont.color);
				break;
			case CONTBACK:
				sscanf(scanPtr, "%u", &image->cont.back);
				break;
			case CONTLIST:
				image->cont.levels = scanInt(&scanPtr);
				for(i = 0; i < image->cont.levels; i++)
					image->cont.list[i] = scanInt(&scanPtr);
				break;
			case CONTTRANS:
				sscanf(scanPtr, "%u", &image->cont.tParent);
				break;
			case CONTCLORED:
				sscanf(scanPtr, "%u", &image->cont.colorPlot);
				break;
		}
	}
	return((Object *)image);
}


#define DIGITCOUNT	1

char *CounterTokens[] = {
	"digitCount",
	""
	};

Object *LoadCounter(counter, stringPtr)
	Counter *counter;
	char *stringPtr;
{
	char *scanPtr;
	int token, size;
	DigitRec *digitList;
	
	while((token = getToken(&stringPtr, &scanPtr, CounterTokens)) != EOS) {
		switch(token) {
			case DIGITCOUNT:
				size = scanInt(&scanPtr);
				digitList = (DigitRec *)mMalloc(size*sizeof(DigitRec));
				if(digitList == NULL)
					return(NULL);
				counter->digitList = digitList;
				counter->digitCount = size;
				for(;size > 0; size--, digitList++) {
					digitList->location.h = scanInt(&scanPtr);
					digitList->location.v = scanInt(&scanPtr);
					digitList->style = scanInt(&scanPtr);
					digitList->color = scanInt(&scanPtr);
				}
				break;
		}
	}
	return((Object *)counter);
}



int CountObjects(objectList, objectCount, kind)
/* Return the count of all objects in objectList of kind */
	Object **objectList;
	int objectCount, kind;
{
	int count = 0;
	int i;
	
	for(i = 0; i< objectCount; i++)
		if(objectList[i]->kind == kind)
			count++;
	return(count);
}

int DrawImage(image, outMap, i)
	Image *image;
	PixMap *outMap;
	int i;
{
	int x,y;
	Rect *r;
	unsigned char *srcData, *contourData;
	unsigned char pal[768];
	int retval, xparent;

	r = &image->object.mask.bounds;
	x = r->right - r->left;
	y = r->bottom - r->top;
	if((srcData = mMalloc(x*y)) == NULL)
		return(-1);
	if(DFR8getimage(image->nameList[i], srcData, x, y, pal) < 0) {
		printf("Error reading image from '%s'.\n", image->nameList[i]);
		free(srcData);
		return(-1);
	}
	if(!image->contourOn) {/* if not a contour then draw the image */
		/* Use 256 for transparent color to disable it for now */
		retval = Copy8Mask(srcData, image->object.mask.data, outMap, r, 256);
	}
	else {/* Draw the contour */
		if((contourData = mMalloc(x*y)) == NULL) {
			free(srcData);
			return(-1);
		}
		ContourDraw(&image->cont, srcData, contourData, x, y);
		if(image->cont.tParent)
			xparent = 0;
		else
			xparent = 256;
		retval = Copy8Mask(contourData, image->object.mask.data, outMap, r, xparent);
	}
	free(srcData);
	return(retval);
}




int DrawCounter(counter, outMap, count, styleList)
	Counter *counter;
	PixMap *outMap;
	int count;
	StyleRec *styleList;
{
	int value, i, width;
	DigitRec *digit;
	StyleRec *style;
	int retval;
	int offset;
	Rect destRect;

	for(i = 0, digit = counter->digitList; i<counter->digitCount; i++, digit++) {
		value = count;
		count = count/10;
		value -= count*10;
		style = &styleList[digit->style];
		if(value == 0)
			offset = 0;
		else
			offset = style->offset[value-1];
		width = style->offset[value] - offset;
		destRect.top = digit->location.v - style->ascent;
		destRect.left = digit->location.h;
		destRect.bottom = destRect.top + style->height;
		destRect.right = destRect.left + width;
		retval = DrawFontCharacter(style, &counter->object.mask, outMap, 
									&destRect, offset, digit->color);
		if(retval < 0)
			return(retval);
	}
	return(0);
}