/**  29-AUG-89  */
/** This is VG.H.  defines and  structures used in vgroup routines */
#include "df.h"
#define PRIVATE			static

#define FULL_INTERLACE	0
#define NO_INTERLACE		1
#define VMAXFIELDS		20  			/* max no of fields per vertex */
#define MAXFIELDNAMELEN	8				/* attr name: 5 chars max */
#define MAXVSNAMELEN		64				/* vs name : 64 chars max */	
#define MAXVGNAMELEN		64				/* vg name : 64 chars max */	


typedef struct vgroup_desc     	VGROUP;
typedef struct vsubgroup_desc 	VSUBGROUP; 

/* ----- V G R O U P ------------------- */
#define MAXNGS 36							/* max no of vgob per vgroup */
struct vgroup_desc{ 
	int  otag, oref;				/* of this vgroup */
  	DF		*f;	 	     			/* HDF file ptr */
	VSUBGROUP* vs[MAXNGS];	   /* pts to a vgob if opened; or else NULL */
	int 	ngs; 						/* S no of vgob */
	int	tag[MAXNGS];			/* S tag of vgob */
	int	ref[MAXNGS];			/* S ref of vgob */
 	char	vgname[MAXVGNAMELEN];/* S name of vgob */
	};		/* VGROUP */

/* ----- V S U B G R O U P ------------------- */
typedef struct symbol_definition_type {
	char* name;						/* symbol name */
	int	type;						/* whether int, char, float etc */
	int	isize;					/* as stored in HDF */
	int	order;					/* order of field */
	} SYM_DEFN;

typedef struct write_struct {
	int32	n;							/* S actual # fields in vertex */
	int	ivsize;					/* S size of vertex as stored in HDF */
 	char 	name[VMAXFIELDS][MAXFIELDNAMELEN];
										/* S name of each field(symbol) */
	int	len[VMAXFIELDS]; 		/* S length of fieldname */
	int	type[VMAXFIELDS];		/* S type */
  	int	off[VMAXFIELDS];		/* S offset of field with vertex in HDF file */
  	int 	isize[VMAXFIELDS];	/* S internal (HDF) size [incl order] */
  	int	order[VMAXFIELDS];	/* S order of field */
  	int	esize[VMAXFIELDS];	/*  external (local machine) size [incl order] */
	int	(*toIEEEfn[VMAXFIELDS])  ();
	int	(*fromIEEEfn[VMAXFIELDS])();
  	} VWRITELIST;

typedef struct read_struct {
	int32	nvread;					/* # vertices read so far */
	int	n; 						/* # fields to read */
	int	item[VMAXFIELDS]; 	/* index into vftable_struct */
	} VREADLIST;


#define USYMMAX 36				/* max user-defined symbols allowed */
struct vsubgroup_desc{ 
  	int	otag, oref; 			/* of this vsubgroup */
  	DF		*f;	 	     			/* HDF file ptr */
  	int	access;					/* 'r' or 'w' */

 	char	vsname[MAXVSNAMELEN];/* S name of this vsubgroup */
  	int	interlace;				/* S actual */
  	int	nvertices;				/* S  # vertices in file */
  	VWRITELIST	wlist;
  	VREADLIST	rlist;
	int  nusym;
	SYM_DEFN usym[USYMMAX];
  	};  /* VSUBGROUP */ 


/***********  H D F  vertex  tags  ***********/
#define VGDESCTAG  	61820 
#define VSDESCTAG 	61821
#define VSDATATAG 	61822 
/********************************************/

/* ------------------------------------------------------------------ */
/* these are as defined by IEEE */
#define IEEE_UNTYPEDSIZE   0
#define IEEE_CHARSIZE      1
#define IEEE_INT16SIZE     2
#define IEEE_FLOATSIZE     4

/* ------------------------------------------------------------------ */
#define LOCAL_NOTYPE			0
#define LOCAL_CHARTYPE  	1
#define LOCAL_INTTYPE 	 	2
#define LOCAL_FLOATTYPE		3

#define LOCAL_UNTYPEDSIZE  0
#define LOCAL_CHARSIZE  	sizeof(unsigned char)
#define LOCAL_INTSIZE  		sizeof(int)
#define LOCAL_FLOATSIZE 	sizeof(float)

/* ------------------------------------------------------------------ */
/* extern int jn;  debugger switch */

