#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>

#include "net.h"

#ifndef MALLOC
#define MALLOC  malloc
#define FREE    free
#endif

static Widget netTimeOutDialog;
static Widget txtTimeOutWidget;
static Boolean netTimeOutIsShowing = False;

static void CBNetTimeOutCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtUnmanageChild(netTimeOutDialog);
	netTimeOutIsShowing = False;
}


static void CBNetTimeOutOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
int newTimeOut;
int numRetries;
Arg argList[10];
Cardinal i;
char *value;
XmString string;


	XtUnmanageChild(netTimeOutDialog);
	netTimeOutIsShowing = False;
	
	newTimeOut = atoi(XmTextFieldGetString(txtTimeOutWidget));

	if ((newTimeOut < 0) || (newTimeOut > 3600)) {
		ErrMesg("Bad network time out value (valid range is 1 - 3600 seconds)\n");
		return;
		}

        XtSetArg(argList[0], XmNtextString, &string);
        XtGetValues(netTimeOutDialog, argList, 1);
        XmStringGetLtoR(string, XmSTRING_DEFAULT_CHARSET, &value);
	numRetries = atoi(value);
	if ((numRetries < 0 ) || (numRetries > 1000000)) {
		ErrMesg("Bad number of network send retries... discarding\n");
		return;
		}
	NetSetTimeOut(newTimeOut);
	NetSetMaxAttemptsToSend(numRetries);

}


void InitNetTimeOut(rootWidget)
Widget rootWidget;
{
Cardinal i;
Arg argList[10];
XmString label,valLabel;
Widget form,lab;
XmTextScanType sel[2];
char buff[64];


        label = XmStringCreateSimple("Max number of attempts to send");
	sprintf(buff,"%d",NetGetMaxAttemptsToSend());
        valLabel = XmStringCreateSimple(buff);
        i = 0;
        XtSetArg(argList[i], XtNtitle, "Network Configuration"); i++;
        XtSetArg(argList[i], XmNselectionLabelString, label); i++;
        XtSetArg(argList[i], XmNtextString, valLabel); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        netTimeOutDialog= XmCreatePromptDialog(rootWidget, 
				"sessionDialog", argList, i);
        XmStringFree(valLabel);
        XmStringFree(label);

        i = 0;
        XtSetArg(argList[i], XmNshadowThickness, 0); i++;
        form = XmCreateForm(netTimeOutDialog, "WorkForm", argList, i);
        XtManageChild(form);

        label = XmStringCreateSimple("Network Timeout (in seconds):");
        i = 0;
        XtSetArg(argList[i], XmNlabelString, label); i++;
        XtSetArg(argList[i], XmNalignment, XmALIGNMENT_BEGINNING); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        lab = XmCreateLabel(form, "workLabel", argList, i);
        XmStringFree(label);
        XtManageChild(lab);

        sel[0] = XmSELECT_POSITION;
        sel[1] = XmSELECT_LINE;
	sprintf(buff,"%d",NetGetTimeOut());
        i = 0;
        XtSetArg(argList[i], XmNvalue, buff); i++;
        XtSetArg(argList[i], XmNselectionArray, sel); i++;
        XtSetArg(argList[i], XmNselectionArrayCount, 2); i++;
        XtSetArg(argList[i], XmNtopAttachment, XmATTACH_WIDGET); i++;
        XtSetArg(argList[i], XmNtopWidget, lab); i++;
        XtSetArg(argList[i], XmNleftAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNrightAttachment, XmATTACH_FORM); i++;
        XtSetArg(argList[i], XmNbottomAttachment, XmATTACH_FORM); i++;
        txtTimeOutWidget= XmCreateTextField(form, "workText", argList, i);
        XtManageChild(txtTimeOutWidget);


        XtAddCallback(netTimeOutDialog, XmNokCallback, 
						CBNetTimeOutOk, NULL);
        XtAddCallback(netTimeOutDialog, XmNcancelCallback, 
						CBNetTimeOutCancel, NULL);


	netTimeOutIsShowing = False;

	return;

}


void CBNetControls()
{
	XtManageChild(netTimeOutDialog);
	netTimeOutIsShowing = True;
}








