#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define FUNC     gb1colx
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gcolx.h"

#define FUNC     gi2colx
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gcolx.h"

#define FUNC     gi4colx
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gcolx.h"

#define FUNC     gr4colx
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gcolx.h"

#define FUNC     gr8colx
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gcolx.h"

#define MULTIP   2*
#define FUNC     gz8colx
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gcolx.h"

#define MULTIP   2*
#define FUNC     gz16colx
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gcolx.h"


int gcolx(data, nlens, result)
     void *data; 
     int *nlens;
     void *result;
{
  int ncnt = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gcolx()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_COLX,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      ncnt = gb1colx(data,nlens,result);
      break;
    case INTEGER2:
      ncnt = gi2colx(data,nlens,result);
      break;
    case INTEGER4:
      ncnt = gi4colx(data,nlens,result);
      break;
    case REAL4:
      ncnt = gr4colx(data,nlens,result);
      break;
    case REAL8:
      ncnt = gr8colx(data,nlens,result);
      break;
    case COMPLEX8:
      ncnt = gz8colx(data,nlens,result);
      break;
    case COMPLEX16:
      ncnt = gz16colx(data,nlens,result);
      break;
    default:
      fprintf(stderr,
	      "gcolx(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_COLX,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */


  }

  return ncnt;
}

