#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

int getdatasize()
{
  int sizeof_data = 0;
  switch (DATATYPE) {
  case STRING:
    sizeof_data = sizeof(char);
    break;
  case BYTE1:
    sizeof_data = sizeof(char);
    break;
  case INTEGER2:
    sizeof_data = sizeof(short);
    break;
  case INTEGER4:
    sizeof_data = sizeof(int);
    break;
  case REAL4:
    sizeof_data = sizeof(float);
    break;
  case REAL8:
    sizeof_data = sizeof(double);
    break;
  case COMPLEX8:
    sizeof_data = 2*sizeof(float);
    break;
  case COMPLEX16:
    sizeof_data = 2*sizeof(double);
    break;
  default:
    fprintf(stderr,"%s(@%d): Unknown datatype = %d\n",
	    "getdatasize",ME,DATATYPE);
    killproc(ME);
    break;
  }
  return sizeof_data;
}

int packdata(routine, data, ndata)
     char *routine;
     void *data;
     int ndata;
{
  int sizeof_data = 0; /* sizeof of data type in bytes */
  switch (DATATYPE) {
  case STRING:
    pvm_pkstr(data);
    sizeof_data = sizeof(char);
    break;
  case BYTE1:
    pvm_pkbyte(data,ndata,STRIDE);
    sizeof_data = sizeof(char);
    break;
  case INTEGER2:
    pvm_pkshort(data,ndata,STRIDE);
    sizeof_data = sizeof(short);
    break;
  case INTEGER4:
    pvm_pkint(data,ndata,STRIDE);
    sizeof_data = sizeof(int);
    break;
  case REAL4:
    pvm_pkfloat(data,ndata,STRIDE);
    sizeof_data = sizeof(float);
    break;
  case REAL8:
    pvm_pkdouble(data,ndata,STRIDE);
    sizeof_data = sizeof(double);
    break;
  case COMPLEX8:
    pvm_pkcplx(data,ndata,STRIDE);
    sizeof_data = 2*sizeof(float);
    break;
  case COMPLEX16:
    pvm_pkdcplx(data,ndata,STRIDE);
    sizeof_data = 2*sizeof(double);
    break;
  default:
    fprintf(stderr,"%s(@%d): Unknown datatype = %d\n",
	    routine,ME,DATATYPE);
    killproc(ME);
    break;
  }
  return sizeof_data;
}

int send2d(dest, msgtag, data, nrows, ncols, offset)
     int dest;
     int msgtag;
     void *data;
     int nrows;
     int ncols;
     int offset;
{
  int bufid;
  int inithow = INITHOW_node;
  int destx = dest;

  if (dest == ANYBODY) {
    return broadcast2d(msgtag,data,nrows,ncols,offset);
  }
  else if (dest >= 0 && dest < NUMNODES) {
    dest = NODEID[dest];
  }
  else if (dest == HOSTID) { 
    dest = HOSTID;
    inithow = INITHOW_host;
  }
  else {
    fprintf(stderr,"send2d(@%d): No such destination %d (msgtag=%d)\n",
	    ME,dest,msgtag);
    killproc(ME);
  }

#ifdef PICL
  if (logfp) SETIDLETIME();
#endif /* PICL */

  bufid = pvm_initsend(inithow);

  if (ncols == 1) {
    packdata("send",data,nrows);
  }
  else  {
    int col;
    int oldstrd = setstride(1); /* Otherwise unexpected results */
    char *p = data;

    for (col=0; col<ncols; col++) {
      p += offset * packdata("send2d",p,nrows);
    }

    setstride(oldstrd);
  }
    
  if (pvm_send(dest,msgtag) < 0) {
    fprintf(stderr,
	    "send2d(@%d): Problems with pvm_send() (source=%d, msgtag=%d)\n",
	    ME,destx,msgtag);
    killproc(ME);
  }

#ifdef PICL
  if (logfp) {
    int nbytes = getdatasize() * ncols * nrows; /* Approximation */
    TRACETIME();
    TRACEF(4,destx == HOSTID ? PICLHOST : destx, msgtag,nbytes);
    UPDATEIDLETIME();
  }
#endif /* PICL */

  if (ME == HOSTID) check_printfmsg_arrival();

  return bufid;
}


int send(dest, msgtag, data, ndata)
     int dest;
     int msgtag;
     void *data;
     int ndata;
{
  return send2d(dest,msgtag,data,ndata,1,ndata);
}

