/*
	Authors		: John Plevyak
	Notes		:

		Basic input functions.
*/

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <string.h>
#if !defined(_SYSTYPE_SYSV) && !defined(cray)
#include <sys/timeb.h> 
#endif
#if defined(cray)
#include <sys/machd.h>
#include <sys/machd.ymp.h>
#endif
#include <sys/times.h>

/* host_mips is for DEC machine */
/* _POSIX_SOURCE needed by DEC file time.h to define CLK_TCK */

#if defined(host_mips)
#define	_POSIX_SOURCE
#endif
#if defined(_CONVEX_SOURCE) || defined(host_mips) 
#include <time.h>
#define	HZ CLK_TCK
#endif

#include <dtmint.h>
#include <debug.h>

#include "test.h"


int port[ TEST_DTM_PORTS ];
int	port_count = 0;
char ** port_names;

static int	(*readFunc[])() = { readMsg, readPort } ;

#define FORMAT "\t%7.4f %7.4f (%4.1f%%) %7.4f (%4.1f%%) %d %7.4f %7.4f \n"


#if !defined(cray) && !defined(_SYSTYPE_SYSV)
#  define     GETTIMES(a,b)   ftime(&a); times(&b);
#  define     TIMETYPE        struct timeb
#else
#  define     GETTIMES(a,b)   a = times(&b);
#  define     TIMETYPE        long
#endif

int print_time(start, end, start_tms, end_tms, bytes)
  TIMETYPE	*start, *end;
  struct tms	*start_tms, *end_tms;
  int		bytes;
{
  long			t;
  struct tms	tms;

#if     !defined(cray) && !defined(_SYSTYPE_SYSV)

        t = (end->time - start->time)*1000L
                 + end->millitm - start->millitm;

#else
        t = (*end - *start)*1000/HZ;
#endif

  tms.tms_utime = end_tms->tms_utime - start_tms->tms_utime;
  tms.tms_stime = end_tms->tms_stime - start_tms->tms_stime;

  fprintf(stdout, 
		"\tReal    System          User            Data   Kbytes    Mbit\n");

	if (t != 0)
		fprintf( stdout, FORMAT, t / 1000.0,
                (float)tms.tms_stime / HZ,
                (float)tms.tms_stime / t * 100000.0 / HZ,
                (float)tms.tms_utime / HZ,
                (float)tms.tms_utime/ t * 100000.0 / HZ,
                (int)bytes,
                (float)(bytes/((t/1000.0)*1024.0)),
                (float)(bytes/((t/1000.0)*1024.0*128.0)));
	else
		fprintf(stderr, "Error: t = 0\n");
}
  

int	DTMtestInputOpen( portNames )
	char	* portNames[];
{
	port_names = portNames;
	while ( *portNames ) {
		if ((port[port_count] = DTMmakeInPort( *portNames, DTM_SYNC )) 
					== DTMERROR ) {
			fprintf( stderr, "%%Test: Inport open error %s [%s]\n", 
					sherr( DTMerrno ), *portNames );
			exit( 1 );
		} else {
			if ( !quietMode )
				fprintf( stdout, "%%Test: Inport %s opened\n", *portNames );
		}
		portNames++; port_count++;
	}
	return DTM_OK;
}

int	DTMtestInputAvail( seconds )
	int		seconds;
{
	int	fAllAvail;
	while ( TRUE ) {
		int	p;
		fAllAvail = TRUE;
		for ( p = 0 ; p < port_count ; p++ ) {
			int fAvail = (DTMavailRead( port[p] ) == DTM_PORT_READY);
			fAllAvail = fAllAvail && fAvail;
			fprintf( stderr, "%%Test: avail `%s` sec %d, %s\n",
				port_names[p], seconds, fAvail ? "TRUE":"FALSE" );	
		}
		if ( seconds-- > 0 )
			sleep( 1 );
		else
			break;
	}
	return fAllAvail;
}

static int	readPerform( port, hlen, ret_num_msgs, ret_nmsg, ret_num_sets,
				ret_block_size)
	int * 	port;
	int	*	hlen, *ret_num_msgs, *ret_nmsg, *ret_num_sets, *ret_block_size;
{
	int	num_msgs, nmsg, num_sets, block_size;

	*ret_num_msgs = *ret_nmsg =
	*ret_num_sets = *ret_block_size = *hlen = 0;

	if( DTMbeginRead( port[0], buf, MAX_BLOCK_SIZE ) == DTMERROR ) { 
		fprintf( stderr, "%%Test: ERROR - Inport %d beginRead, %s\n",
			port, sherr( DTMerrno ) );	
		return 0 ;
	} else 
		if (!quietMode) 
			fprintf( stdout, "%%Test: Port %s, Header '%s' read \n", 
				port_names[0], buf );	
	sscanf( buf, performHeader, &num_msgs, &nmsg, &num_sets, &block_size );
	*ret_num_msgs = num_msgs; *ret_nmsg = nmsg;
	*ret_num_sets = num_sets; *ret_block_size = block_size;
	*hlen = strlen(buf) + 1;
	while ( num_sets-- ) {
		int		size;
		int		stemp;
		if( (size =  DTMreadDataset( port[0], buf,  block_size, 
				DTM_CHAR )) == DTMERROR ) {
			fprintf( stderr, "%%Test: ERROR - Inport %d readDataset, %s\n",
				port[0], sherr( DTMerrno ) );
			return 0 ;
		} 
		if ( size == 0 ) {
			fprintf( stderr, 
				"%%Test: Unexpected EOF Inport %s readDataset\n",
				port_names[0] );
			break;
		}
	}
	if( DTMendRead( port[0] ) == DTMERROR ) {
		fprintf( stderr, "%%Test: ERROR - Inport %s, endRead, %s\n",
			port_names[0], sherr( DTMerrno ) );
		return 0 ;
	} else 
		if (!quietMode) 
			fprintf( stdout, "%%Test: Port %s, Read over\n", port_names[0] );
	return !( nmsg == num_msgs );
}

/*
	DTMtestInput()
	Read input from single or multiple inports.
*/
int	DTMtestInput( portNames )
	char ** 	portNames;
{
	int			count = 0;
	int			num_msgs;
	int			nmsg;
	int			block_size;
	int			num_sets;
	TIMETYPE	start, end;
	struct tms  start_tms, end_tms;
	TIMETYPE	startmsg, endmsg;
	struct tms	startmsg_tms, endmsg_tms;
	int			fDone = FALSE;
	int			total = 0;
	int			hlen;
	int			iFunc;

	DTMtestInputOpen( portNames ); 
	while( 1 ) {
		count++;
		if (( count % 2 ) == 0 ) 
			iFunc = 0 ;
		else
			iFunc = 1 ;
		readTest( port, port_count );
		if( !( *readFunc[iFunc] )( port ) ) {
			fprintf( stdout, 
				"%%Test: ERROR - iteration %d unable to read\n", count );
		} else {
			fprintf( stdout, "%%Test: Iteration %d over\n", count );
		}
	}		
}

/*
	DTMtestPerfInput()
	Read input from single or multiple inports.
*/
int	DTMtestPerfInput( portNames )
	char ** 	portNames;
{
	int			count = 0;
	int			num_msgs;
	int			nmsg;
	int			block_size;
	int			num_sets;
	TIMETYPE	start, end;
	struct tms  start_tms, end_tms;
	TIMETYPE	startmsg, endmsg;
	struct tms	startmsg_tms, endmsg_tms;
	int			fDone = FALSE;
	int			total = 0;
	int			hlen;
	int			ret;
	Dtm_set		dtmset;

	DTMtestInputOpen( portNames ); 
	dtmset.port = port[0];
	while ((ret = DTMselectRead( &dtmset, 1, NULL,0,10000)) != DTM_PORT_READY){
		if ( ret == DTMERROR ) 
			DTMerrmsg( FALSE );
		if (!quietMode)
			fprintf( stdout, "waiting for connection...\n");
	}	
	GETTIMES(start, start_tms);
	while( 1 ) {
		int			datasize;
		if (!quietMode)
			GETTIMES(startmsg,startmsg_tms);
		fDone = !readPerform( port, &hlen, &num_msgs, &nmsg, &num_sets, 
					&block_size );
		datasize = num_sets * block_size;
		if (!quietMode) {
			GETTIMES(endmsg,endmsg_tms);
			printf("Full Message:  header = %d, data = %d:\n", 
					hlen, datasize);
			print_time(&startmsg, &endmsg, &startmsg_tms, &endmsg_tms, 
					hlen+datasize);
		}
		total += hlen+datasize;
		if ( fDone ) break;	
	}	
	GETTIMES(end, end_tms);
	printf("Total run:  (%d messages)\n", num_msgs);
	print_time(&start, &end, &start_tms, &end_tms, total);
	return 1;
}
