/*--------------------------------------------------------------------------*
 * 
 * This file contains utilities used by all converters.
 *
 *  signal_hdf_error: Prints an error message and exits.
 *
 *
 *  To compile :
 *     cc -c utils.c
 *
 * 				NO WARRANTY
 *  
 *  This software is distributed free of charge and is in the public domain.
 *  Anyone may use, duplicate or modify this program.  Thinking Machines
 *  Corporation does not restrict in any way the use of this software by
 *  anyone.
 *  
 *  Thinking Machines Corporation provides absolutely no warranty of any kind.
 *  The entire risk as to the quality and performance of this program is with
 *  you.  In no event will Thinking Machines Corporation be liable to you for
 *  damages, including any lost profits, lost monies, or other special,
 *  incidental or consequential damages arising out of the use of this program.
 * 
 * Jim Salem 9/26/89
 * Please keep this notice with the file.
 *
 * RCS: $Id: utils.c,v 2.0 90/08/01 11:04:17 salem Exp $
 *  $Log:	utils.c,v $
 * Revision 2.0  90/08/01  11:04:17  salem
 * Bump to next release, no changes
 * 
 * Revision 1.1  90/07/30  18:37:28  salem
 * Initial revision
 * 
 *
 *--------------------------------------------------------------------------*/

#include "utils.h"
#include <time.h>


void
  signal_hdf_error (message)
char *message;
/* Signals an error based on errno and DFerror */
{
  char *errmsg;

  switch (DFerror) {
  /* Handle local errors */
  case LDFE_BADDEPTH:
    errmsg = "Pixrect depth not supported";
    break;
  case LDFE_TIFFERR:
    errmsg = "TIFF Internal error";
    break;
  case LDFE_TIFFIO:
    errmsg = "TIFF I/O error";
    break;
  case LDFE_TIFFOPEN:
    if (errno)
      perror (message);
    errmsg = "Error opening TIFF file";
    break;
  case LDFE_TIFFINDEX:
    errmsg = "TIFF file index out of range";
    break;
  /* Handle just a few common ones */
  case DFE_NOERROR:
    /* must be a UNIX error */
    if (errno)
      perror (message);
    else fprintf (stderr, "%s: library error\n", message);
    exit (1);
    break;
  case DFE_FNF:
    errmsg = "File not found error";
    break;
  case DFE_DENIED:
    errmsg = "Access to file denied";
    break;
  case DFE_NOTDFFILE:
    errmsg = "Not an HDF file";
    break;
  case DFE_NOMATCH:
    errmsg = "Index too large or the file doesn't contain raster images";
    break;
  default: fprintf (stderr, "%s: An HDF error occurred (code %d)\n",
		    message, DFerror);
    exit (1);
  }
  fprintf (stderr, "%s: %s\n", message, errmsg);
  exit (1);
}

char *
  get_date_time ()
{
  static char cached_time_string[20];
  static long cached_time;

  struct tm *timeval;

  /* Get the time structure */
  time (&cached_time);
  timeval = localtime (&cached_time);

  /* Parse it */
  cached_time_string[19] = 0;
  sprintf (cached_time_string, "%4d:%02d:%02d %02d:%02d:%02d",
	   timeval->tm_year+1900, timeval->tm_mon+1, timeval->tm_mday,
	   timeval->tm_hour, timeval->tm_min, timeval->tm_sec);
  return cached_time_string;
}

char *
  get_host_computer ()
{
  static char cached_hostname[64] = "Unknown";
  gethostname (cached_hostname, sizeof(cached_hostname));
  return cached_hostname;
}

char *
  get_artist ()
{
  static char cached_artist[L_cuserid];

  return cuserid(cached_artist);
}
