#include <stdio.h>
#include <math.h>

/****************************************************************
**
**  generate:  generate 2-D data array for turning into image
**             plus max, min, hscale, vscale, and cross-hatching
**
**
**             The array generated, if converted to an image, 
**             should display a spectrum going from top to
**             bottom, with cross-hatching every 10th row and column.
**             If the scale is non-uniform, the positions of the
**             cross-hatches will reveal this.
**
****************************************************************/
	int
generate(vdim, hdim, data, vscale, hscale, max, min)
int   vdim, hdim;
float *data, *vscale, *hscale, *max, *min;
{
    int i, j, width;
	float *pdata, delta, newval;

    *min = 0.0;
    *max = vdim;

    /* store one value per row, increasing by one for each row */
	pdata = data;
    for (i=0; i< vdim; i++)
       for (j=0; j< hdim; j++) 
           *pdata++ = (float) i+1;

    /* generate cross-hatching -- one row/col of 0's every 10th row/col */
    /* rows */
	pdata = data;
    width = vdim/10;
    if (width > 0) {
	for (i=0; i<vdim; i += width) {
	    pdata = data + i*hdim;
   	    for (j=0; j<hdim; j++)
		*pdata++ = 0.0;
	}
    }
    /* cols */
    pdata = data;
    width = hdim/10;
    if (width > 0) {
	for (i=0; i<vdim; i++) {
	    pdata = data + i*hdim;
	    for (j=0; j<hdim; j += width, pdata += width)
		*pdata = 0.0;
	}
    }
    

	newval = delta = 0.0;
    for (i=0; i< hdim; i++, delta++) {
        newval += delta;
	   	hscale[i] = (float) (1000+newval);
	}
    newval = delta = 0.0;
    for (i=0; i< vdim; i++, delta++) {
        newval += delta;
	  	vscale[i] = (float) (1000+newval);
	}

}

