/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */

/*
 *	File:		td_file.c
 *	Contents:	Unix file routines
 *
 */

#include "td_com.h"
#include <sys/stat.h>

#if defined(SYSV) || defined(DEC)
#include <dirent.h>
#else
#ifdef UNICOS
#include <dirent.h>
#else
#include <sys/dir.h>
#endif
#endif

#define MAXDIRENTRIES	300

extern	void	gr_TextInitBuff();

static struct	stat  buf;


/*
 * Return nonzero if pathname is a directory or a link
 */
int
td_FileIsDir(pathname,lastMod)
char *pathname;
time_t	*lastMod;
{
	if (stat(pathname,&buf) == 0)
	{
		*lastMod = buf.st_mtime;
		if (buf.st_mode & S_IFDIR)
			return(1);
	}
	return(0);
}


/*
 *	Set Current working directory
 */
void
td_setDirName(dirName)
char *dirName;
{
#ifdef RIOS
	Strcpy(td_dirName,dirName);
#else
	strcpy(td_dirName,dirName);
#endif

	sprintf(msg,"%s/.",dirName);
	td_FileIsDir(msg,&lastDirMod);
}


/* 
	Returns a pointer to a list of character strings of the filenames in
	the directory given by the pathname dirName.
*/
char
**td_FileDirStrings(dirName)
char *dirName;
{
	DIR 		  *dirp;
#if defined(SYSV) || defined(DEC)
	struct dirent *dp;
#else
#ifdef UNICOS
	struct dirent *dp;
#else
	struct direct *dp;
#endif
#endif
	short		  i =0,j,k,changed=1;
	char   		  **strngs,*strng;
	time_t		  lastMod;

	dirp = opendir(dirName);
	
	if (dirp == NULL)
		return(NULL);
	else
	{
		if ((strngs = 
			td_Malloc2D((int)MAXDIRENTRIES,(int)1,(long)sizeof(char *),
			"td_Malloc2D")) == NULL)
			return(NULL);

		for (dp=readdir(dirp); (dp!=NULL) && (i<MAXDIRENTRIES);
			 dp=readdir(dirp))
			if (dp->d_name[0] != '.')
			{

				if ((strngs[i] = td_Malloc1D((unsigned)(strlen(dp->d_name)+2),
					1,(unsigned)sizeof(char),"Mallocing Strings")) != NULL)
				{
					sprintf(msg,"%s/%s",dirName,dp->d_name);
					if (td_FileIsDir(msg,&lastMod))
						sprintf(strngs[i],"/%s",dp->d_name);
					else
					if (td_FileIsHdf(msg))
						sprintf(strngs[i],"*%s",dp->d_name);
					else
						sprintf(strngs[i],"_%s",dp->d_name);
					i++;
				}
			}
		closedir(dirp);

		if (dp != NULL)
		{
			sprintf(msg,
			"WARNING: Only %d filenames are displayed due to memory limits.\n",
			MAXDIRENTRIES);
			gr_TextMsgOut(msg);
		}

		strngs[i] = NULL;

		/* When no items in directory */
		if (i == 0)
		{
			if ((strngs[0] = td_Malloc1D((unsigned)10,
				1,(unsigned)sizeof(char),"Mallocing Strings")) != NULL)
			sprintf(strngs[0],"     ");
			strngs[1] = NULL;
			return(strngs);
		}
		/* Sort strings */
		j=i-1;
		while ((j>0) && (changed == 1))
		{
			changed = 0;
			for (k=0;k<j;k++)
			{
				if (strcmp(strngs[k],strngs[k+1]) > 0)
				{
					strng = strngs[k];
					strngs[k] = strngs[k+1];
					strngs[k+1] = strng;
					changed = 1;
				}
			}
			j--;
		}

		return(strngs);
	}

}


/*
 *	Return 1 if file exists, else return 0
 */
int
td_FileExist(pathname)
char *pathname;
{
	FILE	*fp;

	if ((fp=fopen(pathname,"r"))!=NULL)
	{
		fclose(fp);
		return(1);
	}
	else
		return(0);
}
