
      SUBROUTINE OUTPUT( PSI, PSIDOT, TEMP, DV, NLATT, LASTSW)
C     --------------------------------------------------------

      INTEGER NLATT, VSIZE
      COMMON /VECLEN/ VSIZE
      DOUBLE PRECISION  PSI(VSIZE), PSIDOT(VSIZE), TEMP(VSIZE)
      DOUBLE PRECISION  DV(VSIZE)
      LOGICAL LASTSW

C     --------------------------------------------------------------------
C     |    Calculate and output the KE, PE, and total E for the current  |
C     |  timestep.                                                       |
C     |    The quantities are evaluated at integer time, i.e. at the     |
C     |  time at which {psidot} is defined.   {psi} is defined at a      |
C     |  time (h/2) earlier, and so has to be extrapolated forward.      |
C     --------------------------------------------------------------------

      INTEGER  NSWEEP
      DOUBLE PRECISION     H,  HALFH,  MQUARK,  MSQ
      COMMON / PARAMS / H,  HALFH,  MQUARK,  MSQ,  NSWEEP

      INTEGER  FLOPS, NITER
      DOUBLE PRECISION     MFLOPS, TIME
      COMMON / RESULT / TIME, FLOPS, NITER

      INTEGER  COUNT
      DOUBLE PRECISION  AVTIME, MXTIME, MNTIME, KE, PE, SCPROD
      SAVE AVTIME, MXTIME, MNTIME, COUNT
      DATA COUNT, AVTIME, MXTIME, MNTIME /-1, 0.0D0, 0.0D0, 1.0D9/



C     ----------------------------------------------
C     |  KE  =  ( psidot, F, psidot ) -- exactly   |
C     ----------------------------------------------

      CALL FVEC (PSIDOT, TEMP, DV)
      KE = SCPROD (PSIDOT, TEMP ) / NLATT

C     --------------------------------------------------------------------
C     |  PE  =  (omega * |psi|) **2     (we take omega = 1).             |
C     |  Have to extrapolate {psi} (t=-1/2) forward by half a timestep.  |
C     --------------------------------------------------------------------

      CALL ADDSCV (TEMP, PSI, HALFH, PSIDOT)
      PE = SCPROD  (TEMP, TEMP) / NLATT

      MFLOPS = FLOPS / TIME * 1.0D-6

C     --------------------------------------
C     |   Output results for this sweep    |
C     --------------------------------------

      WRITE(6,99)
     *       ' ', KE,          PE,          (KE + PE),
     *            NITER,       TIME,         MFLOPS
99    FORMAT(A,  F10.6,  3X,  F10.6,  2X,  F11.6,  3X,
     *            I5,     2X,  F13.6,  3X,  F13.6)

      WRITE(8,99)
     *       ' ', KE,          PE,          (KE + PE),
     *            NITER,       TIME,         MFLOPS


C------ form average over sweeps and output if this is last sweep

      IF( COUNT .GE. 0) THEN
        AVTIME = AVTIME + TIME
        IF( TIME .GT. MXTIME) MXTIME = TIME
        IF( TIME .LT. MNTIME) MNTIME = TIME
      END IF
      COUNT = COUNT + 1

      IF(LASTSW) THEN
        AVTIME = AVTIME / COUNT
        MFLOPS = MFLOPS * TIME / AVTIME
        WRITE(8, '(//A, I4, A// 2(A, F13.6, A/))')
     *       ' Averages over', COUNT, ' cycles' ,
     *       ' maximum time is', MXTIME, ' s' ,
     *       ' minimum time is', MNTIME, ' s'
        WRITE(8, '( 2(A, F13.3, A/))')
     *       ' Average time is       ', AVTIME, ' s' ,
     *       ' Average performance is', MFLOPS, ' Mflop/s'
      END IF
 
      END
