#define DGEMM dgemm_

#if defined(IMA_CRAY) || defined(IMA_CRAY2)
#undef DGEMM
#define DGEMM SGEMM
#endif

#if defined(IMA_RS6K) || defined(IMA_HPPA)
#undef DGEMM
#define DGEMM dgemm
#endif


void mm(double *C, double *A, double *B, int lsize, int update)
{
  double ALPHA = 1.0;
  double BETA  = 0.0;
  int M = lsize;
  int N = lsize;
  int K = lsize;
  int LDA = lsize;
  int LDB = lsize;
  int LDC = lsize;
  
  if (update) BETA = 1.0;

  /* Call BLAS-3 DGEMM() directly */
  
  DGEMM("N",     /* TRANSA = 'N' */
	 "N",     /* TRANSB = 'N' */
	 &M,      /* M = # of rows in A & C */
	 &N,      /* N = # of cols in B & C */
	 &K,      /* K = # of cols in A & rows in B */
	 &ALPHA,  /* Constant ALPHA = 1.0 */
	 A,       /* Input matrix A */
	 &LDA,    /* Leading dimension of A (LDA) = lsize */
	 B,       /* Input matrix B */
	 &LDB,    /* Leading dimension of B (LDB) = lsize */
	 &BETA,   /* Constant BETA = 0.0, if update = 0, otherwise 1.0 */
	 C,       /* Output matrix C */
	 &LDC     /* Leading dimension of C (LDC) = lsize */
	 );

}


#include <stdio.h>
#include "easy.h"

void print_mat_bin(char *text, double *C, int lsize)
{
  char filename[80];
  FILE *bin;

  sprintf(filename,"matrix_%d.%d",lsize,numnodes());

  bin = fopen(filename,"wb");
  if (text) fwrite(text,sizeof(*text),strlen(text),bin);
  fwrite(C,sizeof(*C),lsize * lsize, bin);
  fclose(bin);
}


#define c(i,j) C[(i) - 1 + ((j) - 1)*lsize]

void print_mat(char *text, double *C, int lsize)
{
  int ME = mynode();

  if (ME == myhost()) print_mat_bin(text,C,lsize);

  if (lsize <= 10) { /* Write only small matrices to stdout */
    int i,j;
    if (text) printf("%s (ME=%d):\n",text,ME);
    for (i=1; i<=lsize; i++) {
      for (j=1; j<=lsize; j++) printf("%.5g ",c(i,j));
      printf("\n");
    }
    printf("\n");
    fflush(stdout);
  }
}


