#define _ATTACHPROC_
#define _NO_XPRINTF_

#include "easy.h"
#include "easydefs.h"

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <signal.h>
#include <time.h>

/* Global variables */

MPP_Info AllMPP_Info[MAXCLUSTERS] = { 0 };
MPP_Info *LocalMPP_Info = AllMPP_Info;
int cluster_id[MAXCLUSTERS] = { 0 };
int active_cluster_id = 0;
int not_attached = 1;
int easy_cio = 1;

#define XORFUNC(a,b) (a) ^ (b)

static void catchup(signo)
     int signo;
{
  signal(signo,SIG_IGN);

  if (signo != SIGTERM) {
    if (LocalMPP_Info)
      printf("%d(cl_id=%d:pid=%d): Signal #%d: ",ME,CLUSTERID,PID,signo);
    switch (signo) {
    case  SIGINT:
      printf("Interrupt");
      break;
    case  SIGQUIT:
      printf("Quit");
      break;
    case  SIGBUS:
    printf("Bus error");
      break;
    case  SIGSEGV:
      printf("Segmentation fault");
      break;
    case  SIGFPE:
      printf("Floating point exception");
      break;
    case  SIGTRAP:
      printf("Trap signal");
      break;
    case  SIGILL:
      printf("Illegal instruction");
      break;
    case  SIGPIPE:
      printf("Pipe broken");
      break;
    default:
      printf("???");
      break;
    }
    printf("\n");
    fflush(stdout);
  }

  signal(signo,SIG_DFL);

  if (LocalMPP_Info) {
    if (ME == HOSTID) {
      int i;
      for (i=0; i<NUMNODES; i++) {
	if (pvm_pstat(NODEID[i]) == PvmOk)
	  pvm_sendsig(NODEID[i],SIGTERM);
      } /* for i */
    }
    else {
      if (signo != SIGTERM) pvm_sendsig(HOSTID,signo);
    }
  }
  exit(signo);
}

static int procno(x, y, z)
     int x;
     int y;
     int z;
{
  return ( x + NX*(y-1) + NX*NY*(z-1) - 1 );
}

static void byebye()
{
  detachproc();
}

int attachproc()
{
  static int mytid = -1;
  int xyzdim[3];
  int hostid;

  if (mytid == -1) {
    (void) dclock(); /* Initialize clock if not initialized yet */

#if IMA_SUN4
    on_exit(byebye);
#else
    atexit(byebye);
#endif

    signal(SIGTERM,catchup);
    signal(SIGINT,catchup);
    signal(SIGQUIT,catchup);
    signal(SIGBUS,catchup);
    signal(SIGSEGV,catchup);
    signal(SIGFPE,catchup);
    signal(SIGTRAP,catchup);
    signal(SIGILL,catchup);
    signal(SIGPIPE,catchup); /* May cause problems in X-applications ? */

    mytid = pvm_mytid();
    if (mytid < 0) {
      pvm_perror("attachproc");
      exit(1);
    }
    
    pvm_notify(PvmHostDelete,MSG_HOSTDEL,1,&mytid);
    pvm_notify(PvmHostAdd,MSG_HOSTADD,1,&mytid);

  }
  mytid = pvm_mytid();   /* Repeated because of possible detachproc()-call */
  hostid = pvm_parent();
  not_attached = 0;
  
  if (hostid == PvmNoParent || hostid == pvm_tidtohost(mytid)) { /* HOST-process */

    setcluster(NOCARE);  /* Next valid active cluster id */

    PID = getpid();
    HOSTID = mytid;
    ME = mytid;

  }
  else {  /* Following applies to NODEs only */
    
    pvm_recv(hostid,MSG_STARTUP);

    pvm_upkint(&active_cluster_id,1,1); /* recv actual cluster_id for this NODE */
    
    /* Only after this you are allowed to use MACROS 
       that refer to LocalMPPInfo-things */

    setcluster(active_cluster_id); 
    
    PID = getpid();
    HOSTID = hostid;
    
    pvm_upkint(&NUMNODES,1,1);
    NODEID = (int *)malloc( NUMNODES * sizeof(int));
    pvm_upkint(NODEID,NUMNODES,1);
    BCASTNODEID = (int *)malloc( (NUMNODES-1) * sizeof(int));

    { 
      int i,j;
      for (i=0; i<NUMNODES; i++) {
	if (NODEID[i] == mytid) {
	  ME = i;
	  break;
	}
      }
      for (j=0, i=0; i<NUMNODES; i++) {
	if (NODEID[i] != mytid) {
	  BCASTNODEID[j++] = NODEID[i];
	}
      }
    }
    
    pvm_upkint(xyzdim,3,1);
    
    NX = xyzdim[0];
    NY = xyzdim[1];
    NZ = xyzdim[2];
    
    { /* Resolve my (X,Y,Z) triplet */
      int tmp;
      Z = ME / (NX * NY) + 1;
      tmp = ME - (Z-1) * (NX * NY) + 1;
      Y = (tmp - 1) / NX + 1;
      X = (tmp - 1) % NX + 1;
    }
    /* Axis: */
    SOUTH = procno(X, (Y>1)?Y-1:NY, Z);  /*  -y   */
    WEST  = procno((X>1)?X-1:NX, Y, Z);  /*  -x   */
    NORTH = procno(X, Y%NY+1, Z);        /*  +y   */
    EAST  = procno(X%NX+1, Y, Z);        /*  +x   */
    UP    = procno(X, Y, Z%NZ+1);        /*  +z   */
    DOWN  = procno(X, Y, (Z>1)?Z-1:NZ);  /*  -z   */

#ifdef XXXDEBUG
    fprintf(stderr,"%d(%d,%d,%d): (S,W,N,E,UP,DOWN)=(%d,%d,%d,%d,%d,%d)\n",
	    ME,X,Y,Z,south(),west(),north(),east(),up(),down());
#endif

    pvm_upkint(&INITHOW_host,1,1);  /* XDRring between HOST & NODE ? */
    pvm_upkint(&INITHOW_node,1,1);  /* XDRring between NODES ? */

    pvm_upkint(&PICLTRACE,1,1);
    pvm_upkint(&HOST_TIMESTAMP,1,1);
#ifdef PICL
    if (PICLTRACE) traceenable("node",0);
#endif /* PICL */

    setdatatype(BYTE1);
    setstride(1);
  }

  return getcluster();
}

