#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define LTGT     >
#define MSG_TYPE MSG_MAX

#define FUNC     gb1max
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gminmax.h"

#define FUNC     gi2max
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gminmax.h"

#define FUNC     gi4max
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gminmax.h"

#define FUNC     gr4max
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gminmax.h"

#define FUNC     gr8max
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gminmax.h"

#define MULTIP   2*
#define FUNC     gz8max
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gminmax.h"

#define MULTIP   2*
#define FUNC     gz16max
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gminmax.h"


int gmax(data, ndata, result, procindex)
     void *data; 
     int ndata;
     void *result;
     int *procindex;
{
  int retcode = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gmax()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_MAX,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      retcode = gb1max(data,ndata,result,procindex);
      break;
    case INTEGER2:
      retcode = gi2max(data,ndata,result,procindex);
      break;
    case INTEGER4:
      retcode = gi4max(data,ndata,result,procindex);
      break;
    case REAL4:
      retcode = gr4max(data,ndata,result,procindex);
      break;
    case REAL8:
      retcode = gr8max(data,ndata,result,procindex);
      break;
    case COMPLEX8:
      retcode = gz8max(data,ndata,result,procindex);
      break;
    case COMPLEX16:
      retcode = gz16max(data,ndata,result,procindex);
      break;
    default:
      fprintf(stderr,
	      "gmax(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_MAX,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */


  }

  return retcode;
}

