//  $Id: as_peer.hh 1.7 Sat, 05 Sep 1998 03:59:35 -0700 wlee $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): WeeSan Lee <wlee@ISI.EDU>


#ifndef AS_PEER_HH
#define AS_PEER_HH

#include "util/List.hh"
#include "rpsl/rpsl.hh"   // For ASt

#define dASPeerUnknown  0x0000
#define dASPeerFromIRR  0x0001
#define dASPeerFromBGP  0x0002
#define dASPeerFromBoth 0x0003
#define dASPeerNew      0x0010

class ASPeer : public ListNode
{
   private:
      ASt tNo;
      int iType;

   public:
      ASPeer(ASt atNo, int iType);
      ASt getNo(void) const { return tNo; }
      int getType(void) const { return iType; }
      void setType(int iType) { this->iType = iType; } 
      // For the class SortedList
      int operator<(const ASPeer &rASPeer) { return tNo < rASPeer.getNo(); }
      int operator==(const ASPeer &rASPeer) { 
	return tNo == rASPeer.getNo() && iType == rASPeer.getType(); 
      }
};

#endif // AS_PEER_HH
