#!PERL

#	$RCSfile: newdb.pl,v $
#	$Revision: 0.13 $
#	$Author: marten $
#	$Date: 1993/08/11 10:22:24 $

# This is a little tool to generate an empty database which just contains
# the generation date, and the COPYRIGHT notice as defined in the config
# file. Mainly used for testing purposes.
# One should be careful with this, since it will simply overwrite existing
# database files if the -f flag is given. No Mercy.

@INC = ("LIBDIR", @INC);

require "rconf.pl";
require "getopts.pl";

&Getopts('fh');

# You need help or have no command line arguments ?

if ($opt_h || !$ARGV[0]) {
	print <<"EOF";
Usage: $0 [-f] [-h] file

-f		Force new database even if file exists
-h		This help message
filename	The name of the new database file to be generated
EOF

	exit;
}

# Check to see if file exists, and if the force overwrite flag is set

if (-e $ARGV[0] && !$opt_f) {
	print STDERR "File exists, will not overwrite\n";
	exit;
}

# Read the conf, for the COPYRIGHT notice

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf($conffile);

# Here we go ...

open(NEWDB, ">$ARGV[0]") || die "Cannot open $ARGV[0]: $!";

# Print generation date to database

local($s,$m,$h,$md,$mo,$y,$wd,$yd,$is) = localtime(time);

$mo+=1;

$mo = "0".$mo unless $mo > 9;
$md = "0".$md unless $md > 9;
$s = "0".$s unless $s > 9;
$m = "0".$m unless $m > 9;
$h = "0".$h unless $h > 9;

print NEWDB "#\n# $y$mo$md $h:$m:$s\n#\n";

# Print the copyright notice to the new file

local(@rights) = split(/\n/, $RIGHTS);
foreach $m (@rights) {
        print NEWDB "# ".$m."\n";
}
print NEWDB "\n";

# And that was it ...

close(NEWDB);

# Delete indexes in case they happen to exist ...

unlink("$ARGV[0].pag");
unlink("$ARGV[0].dir");
