#       misc - miscellaneaous functions
#
#	$RCSfile: misc.pl,v $
#	$Revision: 0.45 $
#	$Author: ripe-dbm $
#	$Date: 1995/05/31 12:04:40 $
#

require "defines.pl";

#
# print date & COPYRIGHT message to file
# 

sub printrights {
   local($file)=@_;
   
   print $file "#\n# ", $DATE, " ", $TIME, "\n#";
   
   foreach (split(/\n/, $RIGHTS)) {
      print $file "\n# ", $_;
   }
   
   print $file "\n#\n";

}

# delormoveindices
#
# deletes the indices
#
# OR
#
# if a second argument is given :
# moves the indices and database file to a new destination database (no dir!!!)
#

sub delormoveindices {
   local($db,$todb)=@_;
   
   local($dirname,$todbdirname);
   local(@outdatedindices)=();
   local($classless)=0;
   
   # do we have the normal indices or a classless one ?!?
   #
   # NOTE: $classlessdb always contains the real database!

   local($classlessdb)=$db; 
   
   $classlessdb=~ s/\.$CLASSLESSEXT$//; 
   $classless=1 if ($db ne $classlessdb);
   
   # we only do this if there is really a database present ;-)
   
   die "delormoveindices - cannot delete/move indices when \'$classlessdb\' doesn\'t exist" if (! -f $classlessdb);
   
   # just delete/move the standard index suffices...
   
   if ($todb) {
      
      # no special case for classless index since we don't want to move
      # the database when moving the classless indices...
      
      rename($db,$todb) if (-f $db);
      
      rename($db.".pag",$todb.".pag") if (-f $db.".pag");
      rename($db.".dir",$todb.".dir") if (-f $db.".dir");
      rename($db.".db",$todb.".db") if (-f $db.".db");
      
      
   }
   else {
      unlink($db.".pag") if (-f $db.".pag");
      unlink($db.".dir") if (-f $db.".dir");
      unlink($db.".db") if (-f $db.".db");
   }
   
   # and now go for the classless indices
   
   if ($classless) {
      
      # find the dirname and filename only
   
      if ($classlessdb=~ /\//) {
         ($dbdirname, $classlessdb)= $classlessdb =~ /^(.*\/)([^\/]*)$/;
      }
      else {
         $dbdirname="./";
      }
   
      # find the indices files that are in the old dir but not in the new...
   
      if ($todb) {
      
         # find the new dirname and filename only
      
         if ($todb=~ /\//) {
            ($todbdirname, $todb)= $todb =~ /^(.*\/)([^\/]*)$/;
         }
         else {
            $todbdirname="./";
         }
      
         die "delormoveindices - cannot move from $dbdirname to $todbdirname" if ($dbdirname=~ /^\s*$todbdirname\s*$/);
      
         # first find indices that don't exist anymore in the new dir   
      
         opendir(TODBDIR,$dbdirname);
   
         local($file);
   
         foreach $file (readdir(TODBDIR)) {
           if (($file=~ /^\s*$classlessdb\.\d+\.\d+\.\d+\.\d+\.\d+\s*$/) &&
               (-f $dbdirname.$file) && (! -f $todbdirname.$file)) {
              push(@outdatedindices,$file);
           }
         }
   
         closedir(TODBDIR);
   
      }
      
      opendir(DBDIR,$dbdirname);
   
      local($file);
   
      foreach $file (readdir(DBDIR)) {
         # print STDERR "delete file: $file -$dbdirname-$classlessdb-\n";
         
         if ($file=~ /^\s*$classlessdb\.\d+\.\d+\.\d+\.\d+\.\d+\s*$/) {
            print STDERR "match\n";
            if ($todb) {
               rename($dbdirname.$file,$todbdirname.$file) if (-f $dbdirname.$file);
            }
            else {
               unlink($dbdirname.$file) if (-f $dbdirname.$file);
            }
         }
      }
   
      closedir(DBDIR);
   
      # remove old unused indices...
      
      if ($todb) {
      
         foreach $file (@outdatedindices) {
            unlink($dbdirname.$file);
         }
   
      }
   }
   
}

sub trimnet {
    local($quad) = @_;
    
    if ($quad=~ /^\s*0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\s*$/) {
       return "$1.$2.$3.$4";
    }
    else {
       &syslog("ERRLOG", "trimnet: illegal ip number \"$quad\"");
       return "";
    }
}

sub islen {
    local($len) = @_;
    if( $len < 0 || $len > 32) {
	return 0;
    } else {
	return 1;
    }
}

sub isnet {
    local($net) = @_;
    local($i);
    if($net !~ /^\d+\.\d+\.\d+\.\d+$/) {
	return 0;
    }
    local(@quads) = split(/\./, $net);
    for ($i=0; $i<4 ; $i++ ) {
	if ($quads[$i] < 0 || $quads[$i] > 255) {
	    return 0;
	}
    }
    return 1;
}

# the name says all ...:

sub getYYMMDDandHHMMSS {

    local ($s,$m,$h,$day,$month,$year,$wd,$yd,$is)=localtime(time);

    $YYMMDD=sprintf("%2d%2d%2d",$year,++$month,$day);
    $YYMMDD=~ s/\D/0/g;

    $HHMMSS=sprintf("%2d:%2d:%2d",$h,$m,$s);
    $HHMMSS=~ s/[^\d:]/0/g;

    print STDERR "$YYMMDD $HHMMSS $YEAR\n" if $DEBUG;                    

    return ($YYMMDD,$HHMMSS);
}

# 
#  A load of silly syntax check subroutines - TB
#
#  isnetnum() - Is is a valid netnumber
#  isdonname() - Is it a valid domainname
#  isname() - Is it a personal name.
#  isphone() - Is is a valid phone or fax format.
#  isemail() -  Is is a valid RFC822 address
#  isasnum() - Is it a valid AS number
#  isaspref() - Is is a valid preference cost
#  isaskeyword() - Is it one of the askeywords (needs to be done somewhat
#                  differently later
#  isasmacro() - Is it a valid as-macro.
#  isclnsprefix() - Is it a CLNS prefix
#  isclnskeyowrd() - Is it one of the CLNS keywords (from Henk S' paper)
#  iscommunity() - got to check it doesn't with a RIPE-81 KEYWORD yuck.
#  ishandle() - check the handle syntax. REMEMBER TO UPDATE the postfix array.
#  ishandser() - check the actual handle serial
#  isnetlist() - Is this a valid netlist
#  ishostaddr() - Is this a valid hostaddress
#  ispeerkeyword() - check list of peer keywords
#
sub isasnum {
    local($str) = @_;
    if($str !~ /^AS[1-9]+\d*$/ ) {
	return 0;
    }
    $str =~ s/AS//;
    if($str =~ /[A-z]+/ ) {
	return 0;
    }
    $str = $str + 0 ;
    if ( $str < 1 || $str > 65535 ) {
	return 0; 
    }
    return 1;
}
#
# HANDLE Postfixes.
#
%POSTFIX = (
	    "INIC", 1,
	    "RIPE", 1,
	    "JPNIC", 1,
	    "AU", 1,
	    "JP", 1,
	    );

sub ishandle {
    local($str) = @_;
    local($serial,$postfix) = "";
    if( $str !~ /^[A-Z][A-Z]/) {
	return 0;
    }
    if ($str !~ /\-/) {
	if (&ishandser($str)) {
	    return 1;
	} else {
	    return 0;
	}
    } 
    if ($str =~ /^RIPE\-(.*)$/ ) {
	return &ishandle($1);
    } else {
	($serial, $postfix) = split(/\-/, $str);
	if(&ishandser($serial) && $POSTFIX{$postfix}) {
	    return 1;
	}
	return 0;
    }
}

sub ishandser {
    local($str) = @_;
    if ($str =~ /^([A-Z][A-Z][A-Z]*)([1-9][0-9]*)*$/) {
	if ((length($1) > 4) || (($2+0) > 9999)) {     # Hardcoded ;-(
	    return 0;
	}
	return 1;
    } else {
	return 0;
    }
}
#
# Current RIPE-81 KEYWORDS
#
%KEYWORD = (
#
# Now gone for RIPE-81++
#
#           "RIPE-DB", 1,
#	    "LOCAL", 1,
	    "ANY", 1,
	    "AND", 1,
	    "NOT", 1,
	    "(", 1,
	    ")", 1,
	    );
sub isaskeyword {
    local($str) = @_;
    if( $str !~ /^\($/ ) {
	$str =~ s/^\(//;
    }
    if ($str !~ /^\)$/ ) {
	$str =~ s/\)$//;
    }
    
    if (&isasnum($str) || ($KEYWORD{$str}) || &iscommunity($str) || 
	&isasmacro($str) || &isnetlist($str)) {
	return 1;
    }
    return 0;
}

sub isasmacro {
    local($str) = @_;
    if ($str =~ /^AS\-[A-Z]+$/) {
	return 1;
    }
    return 0;
}
#
# CLNS KEYWORDS
#
%CLNSWORD = (
	     "ANY", 1, 
	     "AND", 1,
	     "NOT", 1,
	     "(", 1,
	     ")", 1,
	     );
sub isclnskeyword {
    local($str) = @_;
        if( $str !~ /^\($/ ) {
	$str =~ s/^\(//;
    }
    if ($str !~ /^\)$/ ) {
	$str =~ s/\)$//;
    }
    if(&isclnsprefix($str) || ($CLNSWORD{$str})) {
	return 1;
    }
    return 0;
}

#
# Peer KEYWORDS
#

%PEERWORD = (
	     "EGP", 1, 
	     "BGP", 1,
	     "BGP4", 1,
	     "IDRP", 1,
	     "IGP", 1,
	     "HELLO", 1,
	     "IGRP", 1,
	     "EIGRP", 1,
	     "OSPF", 1,
	     "ISIS", 1,
	     "RIP", 1,
	     "RIP2", 1,
	     "OTHER", 1,
	     );

sub ispeerkeyword {
    local($str) = @_;
    return 0 if !$PEERWORD{$str};
    return 1;
}

# isnetlist
#
# double use of the same string is for speed reasons !!
#

sub isnetlist {
    local($str) = @_;
    return 0 if $str !~ /^\s*{\s*\d+\.\d+.\d+\.\d+\s*(\s*,\s*\d+\.\d+.\d+\.\d+\s*)*}\s*$/;
    return 1;
}


sub iscommunity {
    local($str) = @_;
    
    return 0 if $str =~ /^[A-Z][A-Z0-9\_\-]+$/;
    
    foreach $_ ((keys %KEYWORD, "AS")) {
	
	$_ = "\\".$_ if (($_ eq "(") || ($_ eq ")"));
	
	return 0 if ($str =~ /^$_.*/ );
    
    }
    				
    return 1;
}
#
sub isaspref {
    local($str) = @_;
    $str = $str + 0 ;
    if ( $str < 1 ) {
	return 0;
    }
    return 1;
}
#
sub hasdelete {
    local(*entry) = @_;
    return 0 if !defined $entry{"ud"};
    if ($entry{"ud"} eq "") {
	&adderror(*entry, "delete attribute must contain email address and reason for delete");
	return 0;
    }
    return 1;
}
#
sub isnetnum {
    local($str) = @_;
    local($ind) = 0;
#
# check for trailing dot before doing the split
# not nice but needed
#
    return 0 if $str =~ /^.*\.$/;
    local(@add) = split(/\./, $str);
    if ($#add != 3) {
	return 0;
    }
    foreach (@add) {
	if (($_ !~ /^[0-9]+$/) || ($_ > 255) || ($_ < 0)) {
	    return 0;
	}
    }

    if (($add[0] > 223) || ($add[0] == 0)) {
	return 0;
    }
    
    return 1;
}
#
sub isipaddr {
    local($str) = @_;
    local($i) = 0;
    local($net) = "";
    if($str =~ /^(\d+\.\d+\.\d+\.\d+)\/(\d+)$/) {
	$net = $1; 
	local($pref) = $2;
	if($pref != 32) {
	    return 0;
	}
    } else {
	$net = "$str";
    }
    if($net !~ /^(\d+\.\d+\.\d+\.\d+)$/) {
	return 0;
    }
    local(@add) = split(/\./, "$net");

    if ($#add != 3) {
	return 0;
    }
    if($add[0] > 223) {
	return 0;
    }
    foreach $i (0..$#add) {
	$add[$i] +=0;
	if ($add[$i] < 0 || $add[$i] > 255 ) {
	    return 0;
	}
    }
    return 1;
}
sub ismask {
    local($str) = @_;
    local($i) = 0;
    local($net) = "";
    if($str !~ /^(\d+\.\d+\.\d+\.\d+)$/) {
	return 0;
    }
    local(@add) = split(/\./, $str);
    if ($#add != 3) {
	return 0;
    }
    foreach $i (0..$#add) {
	$add[$i] +=0;
	if ($add[$i] < 0 || $add[$i] > 255 ) {
	    return 0;
	}
    }
    return 1;
}
#
sub isclnsprefix {
    local($str) = @_;
    local($i);
    $str =~ tr/A-Z/a-z/;

    return 0 if $str =~ /\.$/;

    local(@parts) = split(/\./, $str);

    return 0 if $parts[0] !~ /^[0-9a-f][0-9a-f]$/;
    return 0 if $parts[1] !~ /^[0-9a-f][0-9a-f][0-9a-f][0-9a-f]$/;
    foreach $i (2..$#parts-1) {
        return 0 if $parts[$i] !~ /^[0-9a-f]+$/;
        return 0 if length($parts[$i]) != 4;
    }
    return 0 if $parts[$#parts] !~ /^[0-9a-f]+$/;
    return 1;
}
#
sub issubdomname {
    local($str) = @_;

    if ($str =~ /^\s*[\w\-]+(\.[\w\-]+)+\s*$/) {
       return 1;
    }
    else {
       return 0;
    }
}

sub isdomname {
    local($str) = @_;

    if ($str =~ /^\s*[\w\-]+(\.[\w\-]+)+\s*$/) {
	return 1;
    }

    return 0;
}

sub isname {
    local($str) = @_;
    
    if ($str !~ /^[\w\-\.\ \'\|\`]+$/) {
	return 0;
    }
    else {
       return 1;
    }
}

sub isphone {
    local($str)=@_;
    
    #if ($str =~ /^\s*\+\s*\(?\s*\d+\s*\)?\s*(\s*[\-\.\(]*\s*\d+\s*\)?\s*)(\(|\\|\/|ext)?(\s*\d+\s*\)?)?$/i) {
    #   return 1;
    #}
    if ($str =~ /^\s*\+\s*\(?\s*\d+\s*\)?\s*(\s*[\-\.\(]*\s*\d+\s*\)?\s*)*((\(|\\|\/|ext\.?|x)(\s*\d+\s*\)?))?$/i) {
       return 1;
    }
    else {
       return 0;
    }
    
}

sub isemail {
    local($str)=@_;
    
    if (($str =~ /^\s*\<?\s*\w+([\.\!\%\-\_]\w+)*\@\w+([\.\-\_]\w+)*\s*\>?\s*$/) &&
        (($str=~ /\<.*\>/) || ($str=~ /^[^\<\>]+$/))) {
       
       return 1;
    
    }
    
    # if (($str =~ /^\s*\<?\s*\w+\S+\s*$/) &&
    #    (($str=~ /\<.*\>/) || ($str=~ /^[^\<\>]+$/))) {
    #   
    #   return 1;
    #
    #}
    else {
       
       return 0;
    
    }
}


# 
# The quad2int & int2quad routines are completely rewritten
# since there were problems with perl5.
# It seems that the shift operations converted the unsigned int
# to a signed int, that was not very convenient for IP numbers ;-)
# So I rewrote everything to use normal /*+- arithmic :-(
#
# David K. 950908
#

sub quad2int {
    local($quad,$dontlog)=@_;
    local($result);

    if ($quad=~ /^0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])\.0*(1?[1-9]?\d|[12][0-4]\d|25[0-5])$/) {
       $result+=$1;
       $result*=256;
       
       $result+=$2;
       $result*=256;
       
       $result+=$3;
       $result*=256;
       
       $result+=$4;
    }
    else {
       
       if (!$dontlog) {
          &syslog("ERRLOG", "quad2int: illegal ip number \"$quad\"");
       }
       	   
       return -1;
    }
    
    return $result;
}

sub int2quad {
    local($oldint) = @_;
    local($newint, $i1, $i2, $i3, $i4);

    # see perl5 note in front of quad2int!!!!!
    
    #
    # dirty trick:
    #
    # the meaning of $newint & $oldint is switched every iteration!
    #
            
    $newint=int($oldint/256);
    $i4=$oldint-($newint*256);
                
    $oldint=int($newint/256);
    $i3=$newint-($oldint*256);
                        
    $newint=int($oldint/256);
    $i2=$oldint-($newint*256);
                                
    $oldint=int($newint/256);
    $i1=$newint-($oldint*256);
    
    return "$i1.$i2.$i3.$i4";
}


#
sub isbracket {
    local($str) = @_;
    local($BRACKET) = "[^\\(\\)]*";
    while ($str =~ s/$BRACKET\($BRACKET\)$BRACKET//g) {}
    return 0 if $str =~ /[\(\)]/;
    return 1;
}

sub isbrace {
   local($str) = @_;
   local($BRACE) = "[^\\{\\}]*";
   while ($str =~ s/$BRACE\{$BRACE\}$BRACE//g) {}
   return 0 if $str =~ /[\{\}]/;
   return 1;
}

#
# exclusive locking
#

sub lock {

    local($file) = @_;

    local($returncode)=flock($file, $LOCK_EX);
    seek($file, 0, 0);
    
    return $returncode;
}

sub appendlock {

    local($file) = @_;

    local($returncode)=flock($file, $LOCK_EX);
    seek($file, 0, 2);
    
    return $returncode;
}

#
sub unlock {

    local($file) = @_;

    return flock($file, $LOCK_UN);
}
1;
