#!PERL

#       netdbm - generate a DBM file from an ASCII dbase file
#
#	$RCSfile: netdbm.pl,v $
#	$Revision: 0.16 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#

USE_DBM

@INC = ("LIBDIR", @INC);


require "rconf.pl";
require "dbopen.pl";
require "dbclose.pl";
require "donetdbm.pl";
require "cldb.pl";
require "getopts.pl";
require "syslog.pl";

&Getopts('cV');

local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = "DEFCONFIG" unless $conffile;

&rconf($conffile);

#
# -p prime classless indexed database
# 
# option is disabled, might cause indexing problems, if you want
# to take the risk uncomment the next line: 
#
# $opt_p=1; 
#
# 

if ((! -f $ARGV[0]) || (!$ARGV[0])) {
   if (($ARGV[0]) && (! -f $ARGV[0])) {
      print STDERR "\ndbfile: $ARGV[0] doesn't exist\n\n"; 
   }

   print STDERR "Usage: $0 [-c ] [-V] dbfile\n\n";
   print STDERR "Where:\n";
   print STDERR "-c\talso make a classless style index\n";
   print STDERR "-V\tbe verbose\n";
   
   exit 1;
}


&delormoveindices($ARGV[0]);

local(%nothing)=();
local(*db)='database';

&dbopen(db,*nothing,1,$ARGV[0]) || die "$0: error opening \"$ARGV[0]\"\n";
&donetdbm(*db);
&dbclose(*db);
    
if ($opt_c) {
   
   # Remove the old indexes, otherwise it will append
   
   &delormoveindices($ARGV[0].".".$CLASSLESSEXT);
   
   &dbopen(db, *nothing, 0, $ARGV[0]) || die "Cannot open $ARGV[0] for classless index";
   &dbclopen(*nothing,1,$ARGV[0]);
   
   &docldbm(*db);
   
   &dbclose(*db);
   &dbclclose();
   
}
