
#	$RCSfile: syntax.pl,v $
#	$Revision: 2.3 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/14 15:45:49 $
#
#       ARGUMENTS:      *ASSOC object
#       RETURNS:        INTEGER object_status
#
#       Object status = $O_OK, $O_WARNING, $O_ERROR
#       Object will be changed to have warnings and errors
#
# This is the really ugly bit, where the syntax of all the fields is checked
# This is completely independent of the config file and needs additions if
# you add your own fields. It does not check whether fields are allowed in
# this object, whether they are supposed to be multiple or any of that
# That part is basic configuration driven and can be found in enparse.pl
#
# The syntax stuff needs to be re-written at a later date to allow for
# configurable syntax. This is in the dreams of someones mind.....

require "defines.pl";
require "adderror.pl";
require "net2net.pl";    
require "misc.pl";	 
require "handle.pl";

sub requiredsyntaxcheck {
    local(*object, $type)=@_;

    local($rtcode)=$O_OK;

    if (!$type) {	
       
       &adderror(*object, "unknown object type");
       
       $rtcode=$O_ERROR;
       
    }
    
    #
    # so - source
    
    # print STDERR $object{"so"}, $CANUPD{$object{"so"}}, "\n";
    
    if ($object{"so"}) {
    
       if (!$DBFILE{$object{"so"}}) {
    
          &adderror(*object, "unknown source \"".$object{"so"}."\"");
        
          $rtcode=$O_ERROR;
       
       }
    
       if (!$CANUPD{$object{"so"}}) {
    
          &adderror(*object,"cannot update entry with source \"".$object{"so"}."\"");
       
          $rtcode=$O_ERROR;
    
       }
       
    }
    
    #
    # uo - override

    if ($object{"uo"}) {
    
       print STDERR "requiredsyntaxcheck - checking uo\n" if $opt_V;
       
       if ($object{"uo"}=~ /^\S+.*\s+(\S+)$/) {
           
          if (crypt($1,$OVERRIDECRYPTEDPW) eq $OVERRIDECRYPTEDPW) {
              
             $object{"uo"}=~ s/\s+(\S+)$/ \*\*\*/;
              
          }  
          else {
              
             $object{"uo"}=~ /^(\S+)\s/;
              
             if (crypt($1,$OVERRIDECRYPTEDPW) eq $OVERRIDECRYPTEDPW) {
                
                $object{"uo"}=~ s/^(\S+)\s+/\*\*\* /;

             }  
             else {
                 
                &syslog("AUDITLOG", "Override failure, wrong password in line: ".$object{"uo"});
                 
                &adderror(*object, "wrong override password specified, fact has been logged");
                 
                $rtcode=$O_ERROR;
                 
             }
              
          }
           
       }
       else {
            
           &adderror(*object, "illegal override value, syntax should be: Reason Passwd");
        
           $rtcode=$O_ERROR;
        
       }
        
    }
    
    #
    # ud - delete attribute
    
    if ((defined($object{"ud"})) && ($object{"ud"}=~ /^\s*$/)) {
       &adderror(*object, "delete attribute must contain a reason for delete");
       
       $rtcode=$O_ERROR;
    
    }
    
    
    return $rtcode;
 
}

sub checksyntax {
    local(*object)=@_;

    local($rtcode) =$O_OK;
    local($itmp, $val, $msg);

    print STDERR "checksyntax($rtcode) ($O_ERROR,$O_WARNING) - called\n" if $opt_V;

    foreach $itmp (keys %object) {
	if ($object{$itmp} eq "") {
	    ($val, $msg) = &dosyntax($itmp, "", *object);
	    if (defined($val)) {
	       if ($val == $O_WARNING) {
		   &addwarning(*object, $msg);
	 	   $rtcode = $O_WARNING if $rtcode == $O_OK;
	       }
	       elsif ($val == $O_ERROR) {
		   &adderror(*object, $msg);
	     	   $rtcode = $O_ERROR;
	       }
	    }
	} else {
#
# Got to preprocess the multi-line semantic attributes. sigh.. Did I really
# think this was a good idea ??
# The way this works is $peer and $wt (this is a combination depending on the
# attribute) are used as a key to check wrapped lines. 
# This is probably not the best way of doing this as you to do a lot of 
# splitting to get the correct unique keys.
# You also have to split differently depending on whether syntax sugar exists.
#
	    if ($itmp eq "ai" || $itmp eq "ao" || $itmp eq "it" || $itmp eq "io") {
		local($FLAG) = $itmp;
		local(@array) = split(/\n/, $object{$itmp});
		local($j,$k) = 0;
		local(%linewrap) = ();
		local(%newval) = ();
		foreach $j (0..$#array) {
#
# as-in lines
#
		    if($FLAG eq "ai") {
			if($array[$j] =~ /^from/) {
			    ($sugar1, $peer, $wt, $sugar2, $pol) =
				split(/\s+/, $array[$j], 5);
			    if($sugar2 ne "accept") {
				&adderror(*object, "keyword problem in as-in line for peer $peer cost $wt");
				$rtcode = $O_ERROR;
                                next;
			    }
			} 
			else {
			    ($peer, $wt, $pol) = split(/\s+/, $array[$j], 3);
			}
#
# as-out lines
#
		    } elsif ($FLAG eq "ao") {
			if($array[$j] =~ /^to/) {
			    ($sugar1, $peer, $sugar2, $pol) = 
				split(/\s+/, $array[$j], 4);
			    $wt = 1;
			    if($sugar2 ne "announce") {
				&adderror(*object, "keyword problem in as-out line for peer $peer");
				$rtcode = $O_ERROR;
				next;
			    }
			} else {
			    ($peer, $pol) = split(/\s+/, $array[$j], 2);
			    $wt = 1;
			}
#
# interas-in lines
#
		    } elsif ($FLAG eq "it") {
#
# Get rid of spaces in (<pref-type>=<value>)
#
			$array[$j] =~ 
			    s/\(\s*pref\s*\=\s*(\S+)\s*\)/\(pref=$1\)/;
			if($array[$j] =~ /^from/) {
			    ($sugar1, $peer, $lid, $rid, $cost, $sugar2, $pol) 
				= split(/\s+/, $array[$j], 7);
			    if($sugar2 ne "accept") {
				&adderror(*object, "keyword problem in interas-in line for peer $peer cost $cost");
				$rtcode = $O_ERROR;
				next;
			    }
			    $wt = "$lid-$rid-$cost";
			} else {
			    ($peer, $lid, $rid, $cost, $pol)  = 
				split(/\s+/, $array[$j], 5);
			    $wt = "$lid-$rid-$cost";
			}
#
# interas-out lines
#
		    } elsif ($FLAG eq "io") {
			local($gotmet) = 0;
#
# This is where you have insert new ``mertic-type'' values and get rid of 
# spaces
#
			if ($array[$j] =~ /metric-out/) {
			    $array[$j] =~ s/\(\s*metric\-out\s*\=\s*(\S+)\s*\)/\(metric-out=$1\)/;
			    $gotmet = 1;
			}	
			if($array[$j] =~ /^to/) {
			    if($gotmet) {
				($sugar1, $peer, 
				 $lid, $rid, $metric, $sugar2, $pol) = 
				     split(/\s+/, $array[$j], 7);
				$wt = "$lid-$rid-$metric";
			    } else {
				($sugar1, $peer, $lid, $rid, $sugar2, $pol) =
				    split(/\s+/, $array[$j], 6);
				$wt = "$lid-$rid";
			    }
			    if($sugar2 ne "announce") {
				&adderror(*object, "keyword problem in interas-out line for peer $peer");
				$rtcode = $O_ERROR;
				next;
			    }
			} else {
			    if($gotmet) {
				($peer, $lid, $rid, $metric, $pol) =
				    split(/\s+/, $array[$j], 5);
				$wt = "$lid-$rid-$metric";
			    } else {
				($peer, $lid, $rid, $pol) = 
				   split(/\s+/, $array[$j], 4);
				$wt = "$lid-$rid";
			    }
			}
		    }
#
# Now finally check if the lines are the same.
#
		    if($newval{"$peer:$wt"}) {
			if($linewrap{"$peer:$wt"}) {
			    $newval{"$peer:$wt"} = $newval{"$peer:$wt"}." ".$pol;
			} else {
			    $newval{"$peer:$wt"} = $newval{"$peer:$wt"}."\n".$array[$j];
			}
		    } else {
			$newval{"$peer:$wt"} = $array[$j];
		    }
		    $linewrap{"$peer:$wt"} = 1;
		}
		
		print STDERR "Rebuilding \"$itmp\"\n" if $opt_V;
		
		if($FLAG eq "ai") {
		  $object{$itmp} =~ s/from\s+|accept\s+//g;
		}
		if ($FLAG eq "ao") {
		  $object{$itmp} =~ s/to\s+|announce\s+//g;
		}
		if ($FLAG eq "it") {
		  $object{$itmp} =~ s/from\s+|accept\s+//g;
		}
		if ($FLAG eq "io") {
		  $object{$itmp} =~ s/to\s+|announce\s+//g;
		}
#
# Now loop through the value and syntax check the re-built line
#	   
		foreach $k (keys %newval) {
  	           foreach $l (split(/\n/, $newval{$k})) {
			local($val, $msg) = &dosyntax($FLAG, $l, *object);
			if (defined($val)) {
			   if ($val == $O_WARNING) {
			       &addwarning(*object, $msg);
			       $rtcode = $O_WARNING if $rtcode == $O_OK;
			   }
			   elsif ($val == $O_ERROR) {
			       &adderror(*object, $msg);
			       $rtcode = $O_ERROR;
			   }
			}
	           }
		}
#
# Otherwise just split on newlines and pass line by line to syntax checker
#
	    }
	    else {
	        if ($itmp=~ /^ac|ah|ch|tc|zc|cy|mb|ml$/) {
		    local($val, $msg) = &dosyntax($itmp, $object{$itmp}, *object);
		    # print STDERR "checksyntax - before attr: $itmp rtcode: $rtcode val: $val msg: $msg\n" if ($opt_V);
		    if (defined($val)) {
		       if ($val == $O_WARNING) {
		 	  &addwarning(*object, $msg);
			  $rtcode = $O_WARNING if $rtcode == $O_OK;
		       }
		       elsif ($val == $O_ERROR) {
			  &adderror(*object, $msg);
			  $rtcode = $O_ERROR;
		       }
		    }
		    # print STDERR "checksyntax - after attr: $itmp rtcode: $rtcode val: $val msg: $msg\n" if ($opt_V);
		}
		else {
		   foreach $j (split(/\n/, $object{$itmp})) {
		    local($val, $msg) = &dosyntax($itmp, $j, *object);
		    # print STDERR "checksyntax - before attr: $itmp rtcode: $rtcode val: $val msg: $msg\n" if ($opt_V);
		    if (defined($val)) {
		       if ($val == $O_WARNING) {
		 	  &addwarning(*object, $msg);
			  $rtcode = $O_WARNING if $rtcode == $O_OK;
		       }
		       elsif ($val == $O_ERROR) {
			  &adderror(*object, $msg);
			  $rtcode = $O_ERROR;
		       }
		    }
		    # print STDERR "checksyntax - after attr: $itmp rtcode: $rtcode val: $val msg: $msg\n" if ($opt_V);
		   }
		}
	    }
	}
    }
    
    print STDERR "checksyntax - returned\n" if $opt_V;
    
    return $rtcode;
    
}

sub dosyntax {

    local($key, $value, *object) = @_;
    
    local($type)=&entype(*object);
    

#
# ud - delete
#
# The delete is a bit of a pain. Since we want to be able to delete
# objects that actually contain syntax errors, they are NOT syntax
# checked. Therefore, all the syntax checking for deletes is actually
# done in misc.pl sub &hasdelete. This is not very nice, but the only
# thing that actually works.

    
#
# ae - as-exclude
#
    if ($key eq "ae") {
    
       print STDERR "dosyntax - checking ae\n" if $opt_V;
       
	local($sugar1, $as, $sugar2, $rest) = "";
	if($value =~ /^exclude/) {
	    ($sugar1, $as, $sugar2, $rest) = split(/\s+/, $value, 4);
	    if($sugar2 ne "to") {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	    }
	} else {
	    ($as, $rest) = split(/\s+/, $value,2);
	}
	if(!&isasnum($as)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - neigbor peer".
		" $as doesn't look like an AS";
	}
	if(&isasnum($rest) || 
	   &iscommunity($rest) || 
	   &isasmacro($rest) ||
	   ($rest eq "ANY")) {
	    $object{$key} =~ s/exclude\s+|to\s+//g;
	} else {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - exclude-route-keyword".
		" $rest unknown";
	}
	return $O_OK;
    }
#
# ai - as-in
#   
    if ($key eq "ai") {
    
       print STDERR "dosyntax - checking ai\n" if $opt_V;
       
# 
# This line has been pre-processed above.
# remove syntax fluff, flip to unpper case for ases and remove leading WS
#
	$value =~ s/from\s*//;
	$value =~ s/accept\s*//;
	$value =~ s/[aA][sS]/AS/g;
	$value =~ s/^\s+//;
#
# split the line up into AS, cost and the policy
#
	local($as,$pref,$pol) = split(/\s+/,$value,3);
	if (!&isasnum($as)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\"\nneigbour peer".
		" $as doesn't look like an AS";
	}
	if (!$pref) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\"\nyou must give a cost";
	}
	if (!&isaspref($pref)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\"\ncost $pref ".
		"must be a positive integer";
	}
	if (!$pol) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\"\n\tno ".
		"routing policy expression given";
	}
#
# now check equal brackets and braces
#
	if(!&isbracket($pol)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: peer $as cost $pref\"" .
		"\n\tunequal brackets \"\(\)\"\n";
	}
	if(!&isbrace($pol)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: peer $as cost $pref\"" .
		"\n\tunequal braces \"\{\}\"\n";
	}
#
# Now grab the netlist entries and check they are ok
#
	local($tmppol) = $pol;
	while($tmppol =~ s/(\{[^\}]*\})// ) {
	    if(!&isnetlist($1)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: peer $as cost $pref\"".
		    "\n\tnetlist error $1";
	    }
	}
#
# Now check the actual keywords
#
	while($tmppol =~ s/(\S+)//) {
	    if (!&isaskeyword($1)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: peer $as cost $pref\"\n\t$1 ".

		    "is not a routing policy KEYWORD";
	    }
	}
	return $O_OK;
    }
#
# al - as-list
#
    if ($key eq "al") {
    
       print STDERR "dosyntax - checking al\n" if $opt_V;
       
	$value =~ tr/a-z/A-Z/;
	local(@aslist) = split(/\s+/, $value);
	local($i);
	foreach $i (@aslist) {
	    if(!&isasnum($i) && !&isasmacro($i)) {
		return $O_ERROR, "illegal value \"$i\" in \"$ATTL{$key}\"";
	    }
	}
	return $O_OK;
    }

#
# an - aut-num
# la - localas
# or - origin

    if ($key=~ /^an|la|or$/) {
    
       print STDERR "dosyntax - checking an,la,or ($key)\n" if $opt_V;
       
	$value =~ tr/a-z/A-Z/;
	
	if (!&isasnum($value)) {
	    return $O_ERROR,
	    "syntax error in \"$ATTL{$key}\" - $value is not a valid AS";
	}
	
	$object{$key}=$value;
	
	return $O_OK;
    }
    
#
# am - as-macro
#
    if ($key eq "am") {
    
       print STDERR "dosyntax - checking am\n" if $opt_V;
       
	if(!&isasmacro($value)) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# ao - as-out
#
    if ($key eq "ao") {
    
       print STDERR "dosyntax - checking ao\n" if $opt_V;
       
	$value =~ s/to//;
	$value =~ s/announce//;
	$value =~ s/[aA][sS]/AS/g;
	$value =~ s/^\s+//;
#
# split up into AS and policy
#
	local($as,$pol) = split(/\s+/,$value,2);
	if (!&isasnum($as)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - ".
		"neigbour peer $as doesn't look like an AS";
	}
	if (!$pol) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - ".
		"no routing policy expression given";
	}
#
# now check equal brackets and braces.
#
	if(!&isbracket($pol)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: peer $as \"" .
		"\n\tunequal brackets \"\(\)\"\n";
	}
	if(!&isbrace($pol)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: peer $as \"" .
		"\n\tunequal brackets \"\(\)\"\n";
	}
#
# Now grab loop through netlist entries and check they are ok
# Here a netlist entry is anything between braces.
#
	local($tmppol) = $pol;
	while($tmppol =~ s/(\{[^\}]*\})// ) {
	    if(!&isnetlist($1)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: peer $as \"".
		    "\n\tnetlist error $1";
	    }
	}
	while($tmppol =~ s/(\S+)//) {
	    if (!&isaskeyword($1)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: peer $as \"".
		    "\n\t$1 is not a routing policy KEYWORD";
	    }
	}

       return $O_OK;

    }

#
# at - auth
#
    if ($key eq "at") {
    
       print STDERR "dosyntax - checking at\n" if $opt_V;
       
	local(@authstr) = split(/\s+/, $value, 2);
	if ($authstr[0] eq "NONE") {
	    if ($authstr[1] !~ /^$/) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\"".
		    "- $authstr[1] is extraneous for $authstr[0]";
	    } else {
	     	return $O_OK;
	    }
	}
	if ($authstr[0] eq "CRYPT-PW") {
	    if(length($authstr[1]) != 13) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\"" .
		    " - password \"$authstr[1]\" is incorrect length";
	    } else {
		return $O_OK;
	    }
	}	
	elsif ($authstr[0] eq "MAIL-FROM") {
	    local($regex) = $value;
	    $regex =~ s/^\s*MAIL\-FROM\s*//;
	    eval "/$regex/;";
	    if ($@) {
		return $O_ERROR, "\"$regex\" is not a legal regular expression";
	    }
	    else {
		return $O_OK;
	    }
	}
	    
	else {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\" $value";
	}
	return $O_OK;
    }
#
# au - authority
#
    if ($key eq "au") {
    
       print STDERR "dosyntax - checking au\n" if $opt_V;
       
	if ($value !~ /^[a-zA-Z0-9\-\.\ \,\(\)\/]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# av - advisory
#
    if ($key eq "av") {
    
       print STDERR "dosyntax - checking av\n" if $opt_V;
       
	local(@list) = split(/\s+/, $value);
        if (!&isasnum($list[0])) {
            return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" - $list[0] is no a valid peer";
        }
	return $O_OK;
    }
#
# the RIPE-60 tags are just given a simple parse - not really needed
# as they are basically guarded.
#
# bg - bdry-gw
#
    if ($key eq "bg") {
    
       print STDERR "dosyntax - checking bg\n" if $opt_V;
       
	if ($value !~ /^[A-Z0-9\-]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# bi - bis
#      bis - Boundary intermediate system i.e. CLNS nonsense
#
    if ($key eq "bi") {
    
       print STDERR "dosyntax - checking bi\n" if $opt_V;
       
	local(@prefixes) = split(/\s+/, $value);
	local($i);
	if ($#prefixes > 1) {
	    return $O_ERROR, "too many prefixes in \"$ATTL{$key}\"";
	}
	foreach $i (@prefixes) {
	    if (!&isclnsprefix($i)) {
		return $O_ERROR, 
		"illegal NSAP prefix syntax in \"$ATTL{$key}\"";
	    }
	}
	return $O_OK;
    }
# 
# bl - bdrygw-l
#
    if ($key eq "bl") {
    
       print STDERR "dosyntax - checking bl\n" if $opt_V;
       
	if ($value !~ /^[A-Z0-9\-\ ]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	
	return $O_OK;
    }
#
# Try to do something clever with the changed field
#
# ch - changed
# wd - withdrawn
#
    if ($key=~ /^ch|wd$/) {
    
       print STDERR "dosyntax - checking ch,wd ($key)\n" if $opt_V;
       
       local($returncode)=$O_OK;
       
       local($date);
       local(@newchanged)=();
       local(@changedvalues)=split(/\n+/, $value);
       
       #
       # add current date if needed to last specified attribute
       
       if ($changedvalues[$#changedvalues]!~ / \d{6,6}$/) {
          
          $changedvalues[$#changedvalues].=" ".$DATE;
          
          &addwarning(*object, "added current date to ".$ATTL{$key}." field");
          
          $returncode=$O_WARNING;
          
       }
       
       #
       # sort values on date
       
       @changedvalues=sort sortchangedfield @changedvalues;
       
       #print STDERR join("\n", "values:", @changedvalues);
       
       foreach $value (@changedvalues) {
       
          $date="";
          
          if ($value=~ / /) {
             $value=~ s/ +(\S+)$//;
             $date=$1;
          }
       
          # print STDERR "*", $date, "*", $value, "\n";
       
          if (!(&isemail($value))) {
             return $O_ERROR, "syntax error in e-mail part of \"$ATTL{$key}\"";
          }

          if (!$date) {
	     return $O_ERROR, "No date specified in \"$ATTL{$key}\" attribute";
          }
           
	  if ($date=~ /^(\d\d)(\d\d)(\d\d)$/) {
	  
	     #
	     # 1988 is the start of the world. This is where we test for proper
	     # date values of YYMMDD

             if ($1<88) {
	        return $O_ERROR, "date ($date) part of \"$ATTL{$key}\" is older then the database itself!";
	     }

	     if (($2<1) || ($2>12) || ($3>31) || ($3<1)) {
	        return $O_ERROR, "date ($date) part of \"$ATTL{$key}\" is not a valid YYMMDD value";
	     }
	  
	  }
	  else {
	  
	     return $O_ERROR, "date part of \"$ATTL{$key}\" not in YYMMDD format";
	
	  }
	  
	  if ($date>$DATE) {
	     
	     &addwarning(*object, "date in \"$ATTL{$key}\" ($date) is in the future - changed to $DATE");
	     $date=$DATE;
	     $returncode=$O_WARNING;
	     
	  }
	  
	  push(@newchanged, $value." ".$date);
	
       }
	  
       $object{$key}=join("\n", @newchanged);

       return $returncode;
	
    }
    
#
# This is the "community" stuff.
#
# cl - comm-list

    if ($key eq "cl") {
    
       print STDERR "dosyntax - checking cl\n" if $opt_V;
       
       foreach $j (split(/\s+/, $value)) {
     
          if (!&iscommunity($j)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}\" - ".
		    "is an illegal keyword community name \"$j\"";
	  }
       
       }
       
       return $O_OK;
       
    }
    
#
# cm - community

    if ($key eq "cm") {
    
       print STDERR "dosyntax - checking cm\n" if $opt_V;
       
	if (!&iscommunity($value)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" - ".
		"illegal community name \"$j\"";
	} 
	return $O_OK;
    }
    
#
# cy - country

    if ($key eq "cy") {
    
       print STDERR "dosyntax - checking cy\n" if $opt_V;
       
       local($errors)="";
       local(@errors)=();
       
       local($warnings)="";
       local(@aliases)=();
       local(@doubles)=();
       local(%doubles)=();
       
       local(@countries)=();
       
       # make sure it is upper case
       
       $value=~ tr/a-z/A-Z/;
       
       # check if country exists and convert aliases
       
       foreach $country (split(/\s+/, $value)) {
	  
	  if (!$COUNTRY{$country}) {
	     push(@errors, $country)
	  }
	  else {
	  
	    if ($COUNTRY{$country} ne $country) {
	       
	       push(@aliases, $country." -> ".$COUNTRY{$country});
	       
	       $country=$COUNTRY{$country};
	    
	    }
	  
	    if ($doubles{$country}) {
	       
	       push(@doubles, $country) if ($doubles{$country}==1); 
	       
	       $doubles{$country}++;
	       
	    }
	    else {
	       
	       # rearrange country attribute with no more then
	       # $MAXCOUNTRIES on one line
	    
	       push(@countries, $country);
	    
	       $doubles{$country}=1;
	       
	    }
	    
	  }
	
	}
	
	# constuct the country attribute value again, skip the leading \n
	
	local($i)=0;
	local(@newcountries)=();
	
	foreach (sort(@countries)) {
	   
	   $i++;
	      
	   if ($i % $MAXCOUNTRIES) {
	      push(@newcountries, " ", $_);
	   }
	   else {
	      push(@newcountries, "\n", $_);
	   }
	   
	}
	
	shift(@newcountries);
	
	$object{$key}=join("", @newcountries);
	
	
	# return with right warnings & error messages
	
	if (@errors) {
	   
	   if (@errors==1) {
	   
	      $errors='unknown country code: "'.$errors[0].'"';
	   
	   }
	   else {
	      
	      $errors='unknown country codes: '.join(', ',@errors).'"';
	   
	   }
	   
	   # only ask for addition if the code looks like a real country code
	   
	   if (@errors=grep(/^[A-Z][A-Z]$/, @errors)) {
	      
	      $errors.="\ncontact \<$HUMAILBOX\> for addition to the valid country list\nif you believe that ";
	      
	      if (@errors==1) {
	         $errors.=$errors[0]." is a valid ISO 3166 country code";
	      }
	      else {
	         $errors.=join(", ", @errors)." are valid ISO 3166 country codes";
	      }

	   }
	   
	   return $O_ERROR, $errors;
	
	}
	
	if (@aliases) {
	
	   if (@aliases==1) {
	   
	      $warnings='changed country code: "'.$aliases[0].'"';
	   
	   }
	   else {
	      
	      $warnings='changed country codes: '.join(', ',@aliases);
	   
	   }
        
        }
        
        
        if (@doubles) {
	
	   $warnings.="\n" if ($warnings);
	   
	   if (@doubles==1) {
	   
	      $warnings.='removed more then once specified country code: '.$doubles[0];
	   
	   }
	   else {
	      
	      $warnings.='removed more then once specified country codes: '.join(', ',@doubles);
	   
	   }
        
        }

        return $O_WARNING, $warnings if ($warnings);
        
	return $O_OK;
	
    }

#
# de - descr
# rm - remarks
# tx - text
# ad - address
# tb - trouble

    if ($key=~ /^de|rm|tx|ad|tb$/) {
       
       print STDERR "dosyntax - checking de,rm,tx,ad,tb ($key)\n" if $opt_V;
    
       if ($value!~ /^.*$/) {
          return $O_ERROR, "invalid characters found in \"$ATTL{$key}\"";
       }

       return $O_OK;

    }    

    
#
# df - default
#
    if ($key eq "df") {
    
       print STDERR "dosyntax - checking df\n" if $opt_V;
       
	local($rest) = "";
	if ($object{"dp"}) {
	    $value =~ tr/A-Z/a-z/;
	    ($prefix, $pref,$rest) = split(/\s+/, $value, 3);
	    if (!&isclnsprefix($prefix)) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: $value\" - incorrect ".
		    "NSAP prefix";
	    }
	}
	else {
	    $value =~ tr/a-z/A-Z/;
	    ($as,$pref,$rest) = split(/\s+/,$value, 3);
	    if (!&isasnum($as)) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}: $value\" ".
		    "- default peer $as doesn't look like an AS";
	    }
	}
	if (!$pref) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - you must give a cost";
	}
	if (!&isaspref($pref)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}: $value\" - ".
		"cost $pref must be a positive integer";
	}
	if($rest && !$object{"dp"}) {
	    $rest =~ s/STATIC/static/;
	    $rest =~ s/DEFAULT/default/;
	    if (&isnetlist($rest) ||
		($rest eq "static") || 
		($rest eq "default")) {}
	    else {
		return $O_ERROR,
		"syntax error in \"$ATTL{$key}\" - ".
		    "\"$rest\" is invalid";
	    }
	    $object{$key} =~ s/STATIC/static/;
	    $object{$key} =~ s/DEFAULT/default/;
	    $object{$key} =~ s/[aA][sS]/AS/g;
	}
	return $O_OK;
    }
#
# Check to make sure the network list looks reasonable
#
#
# di - dom-net
#
    if ($key eq "di") {
    
       print STDERR "dosyntax - checking di\n" if $opt_V;
       
	local(@list) = split(/\s+/,$value);
	local($j) = 0;
	foreach $j (0..$#list) {
	    if (!&isnetnum($list[$j])) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\" - ".
		    "illegal IP network number $list[$j]";
	    }
	}
	return $O_OK;
    }
#
# dm - dom-in
#
    if ($key eq "dm") {
       
       print STDERR "dosyntax - checking dm\n" if $opt_V;
       
	local($bis,$pref,@crap) = split(/\s+/,$value);
        if (!&isclnsprefix($bis)) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - dom-prefix".
                " $bis doesn't look like an NSAP";
        }
        if (!$pref) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - you must give a cost";
        }
        if (!&isaspref($pref)) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - cost $pref ".
                "must be a positive integer";
        }
        if ($#crap < 0 ) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - no ".
                "routing policy expression given";
        }
        foreach $k (@crap) {
            if (!&isclnskeyword($k)) {
                return $O_ERROR, 
                "syntax error in \"$ATTL{$key}: $value\" - $k ".
                    "is not a routing policy KEYWORD";
            }
        }
        return $O_OK;
    }

#
# dn - domain
# da - dom-name
# ir - inet-rtr

    if ($key=~ /^d[an]|ir$/) {
    
       print STDERR "dosyntax - checking dn, da ($key)\n" if $opt_V;
       
       if (!&isdomname($value)) {
          return $O_ERROR, "illegal domain name in ".$ATTL{$key};
       }
	
       return $O_OK;
	
    }
    
#
# do - dom-out
#
    if ($key eq "do") {
    
       print STDERR "dosyntax - checking do\n" if $opt_V;
       
	local($bis,@crap) = split(/\s+/,$value);
        if (!&isclnsprefix($bis)) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - ".
                "dom-prefix \"$bis\" doesn't look like an NSAP prefix";
        }
        if ($#crap < 0 ) {
            return $O_ERROR, 
            "syntax error in \"$ATTL{$key}: $value\" - ".
                "no routing policy expression given";
        }
        foreach $k (@crap) {
            if (!&isclnskeyword($k)) {
                return $O_ERROR, "syntax error in \"$ATTL{$key}: $value\" - ".
                    "$k is not a routing policy KEYWORD";
            }
        }
        return $O_OK;
    }
#
# dp - dom-prefix
#
    if ($key eq "dp") {
    
       print STDERR "dosyntax - checking dp\n" if $opt_V;
       
	if (!&isclnsprefix($value)) {
	    return $O_ERROR, "illegal NSAP prefix format in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }

#
# dt - upd-to
# em - e-mail
# gd - guardian
# mn - mnt-nfy
# ny - notify
# om - op-mail

    if ($key=~ /^dt|em|gd|mn|ny|op$/) {
    
       print STDERR "dosyntax - checking dt,em,gd,mn,ny,op ($key)\n" if $opt_V;
       
	if (!&isemail($value)) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" ".
		"- \"$value\" is not in \(RFC822\) format";
	}
	return $O_OK;
    }

#
# gw - gateway
#
    if ($key eq "gw") {
	if ($value !~ /^[a-zA-Z0-9\-\.\ ]+$/) {
	    return $O_WARNING, "syntax error in \"$ATTL{$key}\"";	
	}
	return $O_OK;
    }
#
# ho - hole
#
# still need to check against route entry
#
    if ($key eq "ho") {
    
       print STDERR "dosyntax - checking ho\n" if $opt_V;
       
	local($stat, $msg, @str) = &netpre_verify($value);
	if($stat == $NOK) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"\n$msg\n";
	}		
	return $O_OK;
    }
#
# if - ifaddr
#
    if ($key eq "if") {
    
       print STDERR "dosyntax - checking if\n" if $opt_V;
       
	local($if, $mask) = split(/\s+/, $value, 2);
	if(!&isipaddr($if)) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\""
		. " $if is incorrect";
	}
	if(!&ismask($mask)) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\""
		. " $mask is incorrect";
	}
	return $O_OK;
    }
#
# ii - ias-int
#

    if ($key eq "ii") {
    
       print STDERR "dosyntax - checking ii\n" if $opt_V;
       
	local(@iistr) = split(/\s+/,$value);	
	if ($#iistr != 1 ) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" - wrong number of components";
	}
	if (!&isipaddr($iistr[0])) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" - \"$iistr[0]\" ".
		"is not a valid IP address";
	}
	if (!&isasnum($iistr[1])) {
	    return $O_ERROR, 
	    "syntax error in \"$ATTL{$key}\" - ".
		"\"$iistr[1]\" is not a valid AS";
	}
	return $O_OK;
    }
#
# it - interas-in
#
    if ($key eq "it") {
    
       print STDERR "dosyntax - checking it\n" if $opt_V;
       
#
# This line has been pre-processed above.
# remove syntax fluff, flip to unpper case for ases and remove leading WS
#
        $value =~ s/from\s*//;
        $value =~ s/accept\s*//;
        $value =~ s/[aA][sS]/AS/g;
        $value =~ s/^\s+//;
#
# split the line up into AS, lid, rid, cost and the policy
#
	local($as, $lid, $rid, $pref, $pol) = split(/\s+/,$value, 5);
	if (!&isasnum($as)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\"\n\tneigbour peer".
                " $as doesn't look like an AS";
        }
	if (!&isipaddr($lid) || !&isipaddr($rid)) {
	    return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\"\n\tip address error";
	}
	if (!$pref) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\"\nyou must give a cost";
        }
        if ($pref !~ /^\(pref=(\S+)\)$/) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\" preferece is invalid";
	}
	if ($1 ne "MED" && $1 !~ /^\d+$/) {
	    return $O_ERROR,
                "syntax error in \"$ATTL{$key}: $value\"".
		    "\n\t<pref-type> value \"$1\" is invalid";
	}
        if (!$pol) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\"\n\tno ".
                "routing policy expression given";
        }
#
# now check equal brackets and braces
#
        if(!&isbracket($pol)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: peer $as cost $pref\"" .
                "\n\tunequal brackets \"\(\)\"\n";
        }
        if(!&isbrace($pol)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: peer $as cost $pref\"" .
                "\n\tunequal braces \"\{\}\"\n";
        }
#
# Now grab the netlist entries and check they are ok
#
        local($tmppol) = $pol;
        while($tmppol =~ s/(\{[^\}]*\})// ) {
            if(!&isnetlist($1)) {
                return $O_ERROR,
                "syntax error in \"$ATTL{$key}: peer $as cost $pref\"".
                    "\n\tnetlist error $1";
            }
        }
#
# Now check the actual keywords
#
        while($tmppol =~ s/(\S+)//) {
            if (!&isaskeyword($1)) {
                return $O_ERROR,
                "syntax error in \"$ATTL{$key}: peer $as cost $pref\"\n\t$1 ".
                    "is not a routing policy KEYWORD";
            }
        }
	return $O_OK;
    }
#
# io - interas-out
#
    if ($key eq "io") {
    
       print STDERR "dosyntax - checking io\n" if $opt_V;
       
	local($gotmet) = 0;
	local($as, $rid, $metric, $pol);
        $value =~ s/to//;
        $value =~ s/announce//;
        $value =~ s/[aA][sS]/AS/g;
        $value =~ s/^\s+//;
#
# split up into parts
#
	if ($value =~ /metric-out/) {
	    $gotmet = 1;
	    ($as, $lid, $rid, $metric, $pol) = split(/\s+/, $value, 5);
	} else {
	    ($as, $lid, $rid, $pol) = split(/\s+/, $value, 4);
	}
        if (!&isasnum($as)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\" - ".
                "neigbour peer $as doesn't look like an AS";
        }
        if (!&isipaddr($lid) || !&isipaddr($rid)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\"\n\tip address error";
        }
	if ($gotmet) {
	    if ($metric !~ /^\(metric-out=(\S+)\)$/) {
		return $O_ERROR,
		"syntax error in \"$ATTL{$key}: $value\"".
		    "\n\t<metric-type> is invalid";
	    }
	    if ($1 ne "IGP" && $1 !~ /^\d+$/) {
		return $O_ERROR, 
		"syntax error in \"$ATTL{$key}: $value\"".
		    "\n\t<metric-type> value \"$1\" is invalid";
	    }
	}
        if (!$pol) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: $value\" - ".
                "no routing policy expression given";
        }
#
# now check equal brackets and braces
#
        if(!&isbracket($pol)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: peer $as \"" .
                "\n\tunequal brackets \"\(\)\"\n";
        }
        if(!&isbrace($pol)) {
            return $O_ERROR,
            "syntax error in \"$ATTL{$key}: peer $as \"" .
                "\n\tunequal brackets \"\(\)\"\n";
        }
#
# Now grab the netlist entries and check they are ok
#
        local($tmppol) = $pol;
        while($tmppol =~ s/(\{[^\}]*\})// ) {
            if(!&isnetlist($1)) {
                return $O_ERROR,
                "syntax error in \"$ATTL{$key}: peer $as \"".
                    "\n\tnetlist error $1";
            }
        }
        while($tmppol =~ s/(\S+)//) {
            if (!&isaskeyword($1)) {
                return $O_ERROR,
                "syntax error in \"$ATTL{$key}: peer $as \"".
                    "\n\t$1 is not a routing policy KEYWORD";
            }
        }
        $object{$key} =~ s/[aA][sS]/AS/g;
	return $O_OK;
    }

#
# in - inetnum

    if ($key eq "in") {

       print STDERR "dosyntax - checking in\n" if $opt_V;
       
       $value=~ s/\s+/ /g;
       
       local($newvalue, $code)=&normalizerange($value, $key);
       
       print STDERR "dosyntax - newrange: $newvalue code: $code (OK=$O_OK)\n" if ($opt_V);
       
       if ($code==$O_OK) {
          
          local($warnings)="";
          
          $object{$key}=$newvalue;
          
          # warn if we changed the value
          
          local($regularnewvalue)=&MakeRegular($newvalue);
          
          if ($value!~ /^\s*$regularnewvalue\s*$/) {
          
             $warnings="\"$ATTL{$key}\" value: \"$value\" changed to \"$newvalue\"";          
          
          }
          
          # warn if really huge ranges are specified
          
          local($ip1,$ip2)=split(/ *\- */, $newvalue);
          
          $ip1=&quad2int($ip1,0);
          $ip2=&quad2int($ip2,0);
          
          if (($ip2-$ip1)>(2**13)) {
          
             $warnings.="\n" if $warnings;
             $warnings.="\"$ATTL{$key}\" huge range specified ($newvalue),\nplease check if that was the intention!\n";          
          
          }
          
          print STDERR "dosyntax - warnings: $warnings\n" if (($warnings) && ($opt_V));
          
          return ($O_WARNING, $warnings) if ($warnings);
          
          return $O_OK; 
          
       }
       else {
          
          if ($code==$O_INVALIDIP) {
             
             return ($O_ERROR, "error in \"$ATTL{$key}\" - invalid IP number specified in: $value\n"); 
          
          }
          elsif ($code==$O_INVALIDPREFIX) {
             
             return ($O_ERROR, "error in \"$ATTL{$key}\" - invalid prefix value specified\n");          
          
          }
          elsif ($code==$O_INVALIDRANGE) {
          
             return ($O_ERROR, "error in \"$ATTL{$key}\" - illegal range: end value of range is smaller then start value\n");
          
          }
          elsif ($code==$O_SYNTAXERROR) {
             
             return ($O_ERROR, "syntax error in \"$ATTL{$key}\" - illegal network $value,\nrange x.x.x.x - x.x.x.x expected\n");
          
          }
          
          return ($O_ERROR, "syntax error in \"$ATTL{$key}\" - illegal network $value,\nrange x.x.x.x - x.x.x.x expected\n");
       
       }
       
    }

#
# i6 - inet6num

    if ($key eq "i6") {

       print STDERR "dosyntax - checking i6\n" if $opt_V;
       
       $value=&fullipv6formatprefix($value);
       
       # print STDERR $value, "\n";
       
       if (!&isipv6prefix($value)) {
          
          return ($O_ERROR, "error in \"$ATTL{$key}\" - invalid ipv6 prefix value specified\n");          
          
       }
             
       
       #
       # remove long ranges of zeroes
       
       local($length)=0;
       local($maxlength)=0;
       $value=~ s/\/(\d+)$//;
       local($prefixlength)=$1; 
       local(@fields)=split(/\:/, $value);
       local($counter)=0;
       
       local($start,$maxstart);
       
       foreach (@fields) {
          
          if ($_) {
             $length=0;
          }
          else {
             
             $start=$counter if (!$length);
             $length++;
             
             if ($length>$maxlength) {
                $maxlength=$length;
                $maxstart=$start;
             }
             
          }
          
          $counter++;
       
       }
       
       # print STDERR join("*", @fields), "\n";
       
       if ($maxlength>1) {
          
          splice(@fields, $maxstart, $maxlength, "");
       
          unshift(@fields, "") if ($fields[0]!~ /^[\da-f]+$/);
          push(@fields, "") if ($fields[$#fields]!~ /^[\da-f]+$/);
          
       }
       
       ($object{$key}=join("\:", @fields)."\/".$prefixlength) =~ tr/a-f/A-F/;
       
       # print STDERR "l: $length st: $maxstart end: $maxlength ", $object{$key}, "\n";
       
       return $O_OK;
       
    }


    
#
# li - limerick
#
    if ($key eq "li") {
    
       print STDERR "dosyntax - checking li\n" if $opt_V;
    
       $value=~ tr/a-z/A-Z/;
       
       if (!&islimerick($value)) {
          return $O_ERROR, "syntax error in \"$ATTL{$key}\", LIM-LimerickName expected";
       }
       
       $object{$key}=$value;

       return $O_OK;

    }    
    
      

#
# lo - location
#

    if ($key eq "lo") {
       
       print STDERR "dosyntax - checking lo\n" if $opt_V;
       
	if ($value !~ /^[a-zA-Z0-9\-\.\ \,\(\)\&\'\"\/]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }

# 
# Added this in for now - maybe removed at a later date.
# This is MERIT/RA special.
# lr - local-route
#
    if ($key eq "lr") {
    
       print STDERR "dosyntax - checking lr\n" if $opt_V;
       
	local(@list) = split(/\s+/, $value);
	if (!&isasnum($list[0])) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\" - $list[0] is not a valid peer";
	} 
	foreach (1..$#list) {
	    if($list[$_] !~ /^\d+:\d+(\(\d+\))*$/) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\" - $list[$_] is invalid";
	    }
	}
	return $O_OK;
    }
	
#
# ma - maintainer
#
    if ($key eq "ma") {
    
       print STDERR "dosyntax - checking ma\n" if $opt_V;
       
	if ($value !~ /^[A-Z0-9\-]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}    
	return $O_OK;
    }

#
# mb - mnt-by
# ml - mnt-lower

    if ($key=~ /^m[bl]$/) {

       print STDERR "dosyntax - checking mb,ml\n" if $opt_V;

       local($mntner);

       local(@syntaxerrors)=();
       # local(@optionerrors)=();
       
       local($errormsg)="";
       
       local(@mntners)=();
       # local(%options)=();
       
       # convert to uppercase

       $value=~ tr/[a-z]/[A-Z]/;

       foreach $mntner (split(/\s+/,$value)) {
	  
	  # check syntax first
	  
	  # check syntax of maintainer itself
	  
	  # print STDERR "*$mntner*\n";
	  
	  if ($mntner!~ /^[A-Z0-9\-]+$/) {
	     push(@syntaxerrors, $mntner);
             next;
          }
          
          # check syntax of options, not yet, it only works for creation
          
          #%options=();
          
          #if (grep((!(/^\s*$/)) &&             # we might have white space
          #         ((!$MNTOPTIONS{$_}) ||      # check for valid option
          #          ($options{$_})),           # check for double options
          #         split(/\s*(\(|\)|\&)\s*/, $1))) {
          #         
          #   push(@optionerrors, $mntner);
          #   next;
          #   
          #}
          
             
          #   next if ($option=~ /^\s*$/);
          #   
          #   if ($MNTOPTIONS{$option}) {
          #      push(@options,$option);
          #   }
          #   else {
          #      push(@syntaxerrors, $mntner);
          #      next;
          #   }
          #
          #}
	   
          push(@mntners,$mntner);
          
        }
        
        $errormsg.="syntax error in maintainer name(s) \'".join(" ",@syntaxerrors)."\',\nonly -, A-Z, 0-9 are allowed\n" if (@syntaxerrors);
        
        # $errormsg.="syntax error in option(s) of maintainer \'".join(" ",@optionerror)."\'\n,syntax is MNTNER [ ( [NEW|UPD|DEL] [ & NEW|UPD|DEL ] ... ) ]\n"if (@optionerrors);

	if ($errormsg) {
	   return $O_ERROR, $errormsg;
	}
	else {   
	   
	   $object{$key}=join("\n", @mntners);
	   
	   return $O_OK;
	   
	}
	
    }
    
#
#  mt - mntner
#
    if ($key eq "mt") {
       
       print STDERR "dosyntax - checking mt\n" if $opt_V; 
       
       # convert to uppercase

       $value=~ tr/[a-z]/[A-Z]/;
       $object{$key}=$value;

       if (!&ismaintainer($value)) {
          return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
       }
	    
       return $O_OK;
       
    }
    
#
# na - netname
# aa - as-name

    if ($key=~ /^[na]a$/) {
    
        print STDERR "dosyntax - checking na,aa ($key)\n" if $opt_V; 
        
	local($cur) = $value;
	local($changed) = 1 if $object{$key} =~ tr/a-z/A-Z/;
	local($changed) = 1 if $object{$key} =~ tr/\./\-/;
	local($changed) = 1 if $object{$key} =~ tr/\_/\-/;
	if (!&isnetname($object{$key})) {
	    $object{$key} = $cur;
	    return $O_ERROR, "illegal $ATTL{$key} \"$cur\"";
	}
	else {
	    if ($changed) {
		$value = $object{$key};
		return $O_WARNING, "\"$cur\" changed to \"$value\"";
	    }
	}
	return $O_OK;
    }
    
#
# nh - nic-hdl

    if ($key eq "nh") {
    
       print STDERR "dosyntax - checking nh ($key)\n" if $opt_V; 
       
       $object{$key}=$value if ($value=~ tr/a-z/A-Z/);
       
       if ($value=~ /^${AUTONICPREFIXREGULAR}0*([1-9]\d*)?(\d)([A-Z]*)$/) {
          
          local($prefix)=$AUTONICPREFIX.$1.$2;
          local($initials)=$3;
          local($autoinitials)=0;
          
          #
          # check if the ID is not already used
          
          return $O_ERROR, "error in \"$ATTL{$key}\", auto NIC handle assignment\nidentification code ($1.$2) already used in other object" if ($NICID{$object{"so"}, $prefix});
          
          #
          # find initials if not already specified
          
          if (!$initials) {
          
             $autoinitials=1;
             $initials=&findinitials($object{$type});
          
          }
          
          if (&isnichandle($initials."1\-".$NICPOSTFIX{$object{"so"}})) {
             
             $object{$key}=$prefix.$initials;
             
             #
             # check if the ID is not already used
             
             $prefix=~ /\-(\d+)$/;
             
             return $O_ERROR, "error in \"$ATTL{$key}\", auto NIC handle assignment identification code ($1) already used in other object\nplease use another number then $1" if ($NICID{$object{"so"}, $prefix});
          
             $NICID{$object{"so"}, $prefix}=1;
             
             return $O_OK;
             
          }
          else {
             
             if ((length($initials)>$MAXLENGTHINITIALS) ||
                 (length($initials)<2)) {
                 
                if ($autoinitials) {
                
                   return $O_ERROR, "couldn\'t find a valid set of initials for NIC handle, please specify yourself: AUTO-#[Initials]"; 
                
                }
                else {
                
                   return $O_ERROR, "syntax error in \"$ATTL{$key}\", number of initials must be >=2 and <=$MAXLENGTHINITIALS"; 
                
                }
             
             }
                              
             return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
             
          }
          
       }
       
       return $O_ERROR, "syntax error in \"$ATTL{$key}\"" if (!&isnichandle($value));
       
       return $O_OK;
       
    }
    
#
# ni - nsf-in

    if ($key eq "ni") {
    
       print STDERR "dosyntax - checking ni ($key)\n" if $opt_V; 
       
	if ($value !~ /^[(\d=\d+)\s*]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# no - nsf-out
#
    if ($key eq "no") {
    
       print STDERR "dosyntax - checking no ($key)\n" if $opt_V; 
       
	if ($value !~ /^[(\d=\d+)\s*]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# ns - nserver
# 
    if ($key eq "ns") {
    
       print STDERR "dosyntax - checking ns ($key)\n" if $opt_V; 
       
	@list = ();
	@list = split(/\s+/,$value);
	$j = 0;
	foreach $j (0..$#list) {
	    if (!&isdomname($list[$j])) {
		if ($list[$j] !~ 
		    /^[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*$/) {
		    return $O_ERROR, 
		    "illegal nameserver in \"$ATTL{$key}\" ".
			"component \"$list[$j]\"";
		}
	    }
	}
	return $O_OK;
    }
    
#
# op - op-phone
# of - op-fa
# ph - phone
# fx - fax-no
#

    if ($key=~ /^o[pf]|ph|fx$/) {
       
       print STDERR "dosyntax - checking op,of,ph,fx ($key)\n" if $opt_V; 
              
	if (!(&isphone($value))) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\",\nphone number is not formatted as an international phone number";
	}
	
	return $O_OK;
	
    }

#
# uo - override
#
# checking is already done in requiredsyntaxcheck

    if ($key eq "uo") {

       print STDERR "dosyntax - checking uo ($key)\n" if $opt_V; 

       return $O_OK;

    }


#
# pe - peer

    if ($key eq "pe") {
       
        print STDERR "dosyntax - checking pe ($key)\n" if $opt_V; 
        
	local(@peer) = split(/\s+/, $value);
	if($value =~ /localas/) {
	    if($peer[3] ne "localas" || !&isasnum($peer[4])) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\"".
		    " - localas error for $value";
	    }
	}
	elsif (!&isipaddr($peer[0]) || 
	       !&isasnum($peer[1]) ||
	       !&ispeerkeyword($peer[2]) ) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\" - $value";
	}
	return $O_OK;
    }
    
#
# pn - person
# ro - role
#
# ac - admin-c
# ah - author
# tc - tech-c
# zc - zone-c

    if ($key=~ /^[atz]c|ah|pn|ro$/) {
       
       # print STDERR "before: ", $object{$key}, "\n";
    
       print STDERR "dosyntax - checking ac,ah,tc,zc,ro,pn ($key)\n" if $opt_V;
       
       local(@names)=();
       
       local($nichandle,$name,$nrofcomponents);
       
       foreach $name (split(/\n+/, $value)) {
       
          #
          # person/role names should not contain a NIC handle
          # but the other attributes preferably should ...
       
          local($nichandle)=$name;
          $nichandle=~ tr/a-z/A-Z/;
          
          # print STDERR "$nichandle*$AUTONICPREFIXREGULAR*$AUTONICPREFIXREGULAR\n";
          
          #
          # auto NIC handle found
          
          if ($nichandle=~ /^$AUTONICPREFIXREGULAR\d+[A-Z]*$/o) {
             
             # print STDERR "auto nic found: $nichandle\n";
             
             if ($key=~ /^pn|ro$/) {
                return $O_ERROR, "error in \"$ATTL{$key}\", name looks like auto NIC handle assignment reference\ninstead of a ".$ATTL{$key}." name";              
             }
             
             push(@names, $nichandle);
             
             next;
             
          }
          elsif ((!(($NROFNAMES<2) && ($nichandle=~ /^[A-Z]+$/))) &&
                 (&isnichandle($nichandle))) {
          
             if ($key=~ /^pn|ro$/) {
          
                return $O_ERROR, "error in \"$ATTL{$key}\", name looks like a NIC handle\ninstead of a ".$ATTL{$key}." name" if ($nichandle=~ /\d/);
       
             }
             else {
               
                push(@names, $nichandle);
                
                next;
          
             }
             
          }
       
          $name=~ s/ +/ /g;
          
          return $O_ERROR, "syntax error in \"$ATTL{$key}\" - use non-abbreviated first & last names" if (($name=~ /^$TITLES/i) || ($name=~ /^\S+\. /) || ($name=~ /\S\.$/));
       
          $nrofcomponents=0;
       
          foreach (split(/ /,$name)) {
          
             return $O_ERROR, "syntax error in \"$ATTL{$key}\"" if (!&isname($_));
             
             $nrofcomponents++ if ($name=~ /\S\S/);
             
          }
          
          return $O_ERROR, "syntax error in \"$ATTL{$key}\" - name must contain at least $NROFNAMES components of at least two characters" if ($nrofcomponents<$NROFNAMES);
       
          push(@names, $name);
          
       }
       
       $object{$key}=join("\n", @names);
       
       # print STDERR $PASSWORD, "after: ", $object{$key}, "\n";
       
       return $O_OK;
    
    }
    
#
# rl - routpr-l

    if ($key eq "rl") {
    
       print STDERR "dosyntax - checking rl ($key)\n" if $opt_V; 
        
	if ($value !~ /^[A-Z0-9\-\ ]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
    
#
#  rp - rout-pr
#
    if ($key eq "rp") {
    
       print STDERR "dosyntax - checking rp ($key)\n" if $opt_V; 
       
	if ($value !~ /^[A-Z0-9\-]+$/) {
	    return $O_ERROR, "syntax error in \"$ATTL{$key}\"";
	}
	return $O_OK;
    }
#
# rt - route
#
# A little messy - all the work is done in net2net.pl
#
    if ($key eq "rt") {
    
       print STDERR "dosyntax - checking rt ($key)\n" if $opt_V; 
       
        local($i) = 0;
	local($NETMASK) = "[nN]*[eE]*[tT]*[mM][aA][sS][kK]";
	local($HEX) = "[0-9a-fA-F]";
	local($HEXMASK) = "0x$HEX$HEX$HEX$HEX$HEX$HEX$HEX$HEX";
	local($IPADDR) = "\\d+\\.\\d+\\.\\d+\\.\\d+";

	if ($value =~ /^$IPADDR$/) {
	    local($stat, $msg, @str) = &clasfn_to_netpre($value);
	    if($stat == $NOK) {
		return $O_ERROR, "$msg\n";
	    } else {
		$object{$key} = $str[0];
		return $O_WARNING, "$ATTL{$key} re-written to $str[0] from $value\n";
	    }
	} elsif ($value =~ /^$IPADDR\s+\-\s+$IPADDR$/) {
	    local($stat, $msg, @str) = &clasfr_to_netpre($value);
	    if($stat == $NOK) {
		return $O_ERROR, "$msg\n";
	    } else {
		if($#str >= 1) {
		    $msg = "$value is not CIDR aligned\n".
			"resubmit the following seperate objects\n";
		    foreach $i (0..$#str) {
			$msg .= "$str[$i]\n";
		    }
		    return $O_ERROR, "$msg\n";
		} else {
		    $object{$key} = $str[0];
		    return $O_WARNING, "$ATTL{$key} re-written to $str[0] from $value\n";
		}
	    }
	} elsif ($value =~ /^$IPADDR\s+($NETMASK)*\s*$IPADDR$/ 
		 || $value =~/^$IPADDR\s+($NETMASK)*\s*$HEXMASK$/) {
	    local($stat, $msg, @str) = &netmask_to_netpre($value);
	    if($stat == $NOK) {
		return $O_ERROR, "$msg\n";
	    } else {
		$object{$key} = $str[0];
		return $O_WARNING,
		"$ATTL{$key} \"$value\" re-written to $str[0] from $value\n";
	    }
	} else {
	    local($stat, $msg, @str) = &netpre_verify($value);
	    if($stat == $NOK) {
		return $O_ERROR, "$msg\n";
	    }
	}
	return $O_OK;
    }
#
# Need to really check against the DNS eventually
#
# rz - rev-srv
#
    if ($key eq "rz") {
    
       print STDERR "dosyntax - checking rz ($key)\n" if $opt_V; 
       
	@list = ();
	@list = split(/\s+/,$value);
	$j = 0;
	foreach $j (0..$#list) {
	    if (!&isdomname($list[$j])) {
		return $O_ERROR, "illegal nameserver in $value";
	    }
	}
	return $O_OK;
    }
#
# sd - sub-dom
#
    if ($key eq "sd") {
    
       print STDERR "dosyntax - checking sd ($key)\n" if $opt_V; 
       
	foreach (split(/\s+/, $value)) {
	    if (!&issubdomname($_)) {
		return $O_ERROR, "syntax error in \"$ATTL{$key}\": $_";
	    }
	}
	return $O_OK;
    }

#
# so - source
#
# checking is already done in requiredsyntaxcheck

    if ($key eq "so") {

       print STDERR "dosyntax - checking so ($key)\n" if $opt_V; 

       return $O_OK;

    }

#
# st - status
#
    if ($key eq "st") {
    
       print STDERR "dosyntax - checking st ($key)\n" if $opt_V; 
       
       $value=~ tr/a-z/A-Z/;
       $value=~ s/\s+/ /g;
       $object{$key}=$value;  
       
       # for backwards compatibility, must be BEFORE other checks
       
       if ($value =~ /^D(ELEGATED)?$/i) {
          
          $value="ALLOCATED UNSPECIFIED";
          $object{$key}=$value;
          
          return $O_WARNING, "\"$ATTL{$key}\" changed to \"$object{$key}\"";
       
       }

       if (($value =~ /^ASSIGNED (PI|PA)$/) ||
           ($value =~ /^ALLOCATED (PI|PA|UNSPECIFIED)$/)) {
           
           return $O_OK;
       }
       
       return $O_ERROR, "\"$ATTL{$key}\" has an illegal value";
    
    }

#
# tr - as-transit
#
    if ($key eq "tr") {
       
       print STDERR "dosyntax - checking tr ($key)\n" if $opt_V; 

	return $O_OK;
    }
    
#
# These are not checked and not used, just in here for clarity
#
#
# ue - *ERROR*
#   
    if ($key eq "ue") {
       
       print STDERR "dosyntax - checking ue ($key)\n" if $opt_V; 
       
	return $O_OK;
    }
#
# uf - u-from (NOT USED)
#    
    if ($key eq "uf") {
       
       print STDERR "dosyntax - checking uf ($key)\n" if $opt_V; 
       
	return $O_OK;
    }
#
# ui - msg-id (NOT USED)
#
    
    if ($key eq "ui") {
       
       print STDERR "dosyntax - checking ui ($key)\n" if $opt_V; 
       
	return $O_OK;
    }
#
# uw - WARNING
#
    if ($key eq "uw") {
    
       print STDERR "dosyntax - checking uw ($key)\n" if $opt_V; 
       
	return $O_OK;
    }
    
    return $O_ERROR, "Internal error: $key is not syntax checked" if ($ATTR{$key});
    
    return $O_ERROR, "Internal error: unknown attribute found during syntax check ($key)";
    
}

1;
