# i6.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997, 1998, 1999 by RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: i6.pl,v 2.3 1999/05/27 07:46:31 engin Exp $
#
#       $RCSfile: i6.pl,v $
#       $Revision: 2.3 $
#       $Author: engin $
#       $Date: 1999/05/27 07:46:31 $
#
# 
#
# Generates the inet6num object status field.
# 

require "adderror.pl";
require "defines.pl";
require "misc.pl";

sub geni6st{
  local(*object, $type) = @_;
  my($rtcode) = $O_OK;
  my($fullipv6,$fullipv6prefix,$prefixlength);

  $fullipv6 = &fullipv6formatprefix($object{'i6'});
  ($fullipv6prefix,$prefixlength) = split('/',$fullipv6);
  @words = split(':',$fullipv6prefix);
  if($words[0] eq '2001'){  # if this is TLA 0x0001
    if($prefixlength >= 4 && $prefixlength <= 15){
      $object{"st"} = "TLA";
    }
    if($prefixlength >= 16 && $prefixlength <= 35){
      $object{"st"} = "SUBTLA";
    }
    elsif($prefixlength >= 36 && $prefixlength <= 48){
      $object{"st"} = "NLA";
    }
    elsif($prefixlength >= 49 && $prefixlength <= 64){
      $object{"st"} = "SLA";
    }else{
      $rtcode = $O_ERROR;
    }

  }else{
    if($prefixlength >= 4 && $prefixlength <= 15){
      $object{"st"} = "TLA";
    }
    elsif($prefixlength >= 25 && $prefixlength <= 48){
      $object{"st"} = "NLA";
    }
    elsif($prefixlength >= 49 && $prefixlength <= 64){
      $object{"st"} = "SLA";
    }
    else{
      $rtcode = $O_ERROR;
    }
  }  
  return $rtcode;
}

1;
