//
// $Id: Handler.hh,v 1.1.1.1 2000/03/10 16:32:19 engin Exp $
//
// Handler.hh
// Author(s): Ramesh Govindan

#ifndef _Handler_hh
#define _Handler_hh

// Functions for handling timer and file events are written
// in C, and stored as function pointers in a Handler object.
// The Handler object is syntactic sugar around a function pointer.
// Handler functions take two (opaque to the Handler object)
// arguments:
//	- the first is a pointer to the object which is the target
//		of the callback
//	- the second is an (optional argument) to the handler.

typedef void (*CallBackFunc)(void*, void*);

class Handler {
  public:
    // Create an empty handler
    Handler() {
        function = (CallBackFunc)NULL;
        opaquePtr = (void *)NULL;
    }
    
    // Create a new handler
    Handler(CallBackFunc f,
            void* ptr) {
        function = f;
        opaquePtr= ptr;
    }

    // Destroy handler
    ~Handler() {
        function = (CallBackFunc)NULL;
        opaquePtr = (void *)NULL;
    }

    // Is handler Null?
    bool
    null() const {
        return (function == NULL);
    }
    
    // Assign h to us
    void
    operator=(const Handler& h) {
        function = h.function;
        opaquePtr = h.opaquePtr;
    }

    // Perform the callback
    void
    callBack(void* opaqueArg) const {
        if (function) {
            (*function)(opaquePtr, opaqueArg);
        }
    }

  private:
    CallBackFunc function;
    void*	 opaquePtr;
};

// 
//  Copyright (c) 1994 by the University of Southern California.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California and/or Information Sciences Institute.
//  The name of the University of Southern California may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY REPRESENTATIONS
//  ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Ramesh Govindan <govindan@isi.edu>

#endif _Handler_hh
