
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <stdio.h>
#include <stdarg.h>
#define INCL_PM
#include <os2.h>

#include "stdwin.h"
#include "bugme.h"

#define FORCE_OPEN

FILE *fnote = NULL;
static inline void init_note()
{
#ifdef FORCE_OPEN
    if (fnote == NULL) fnote = fopen("note", "wt");
#endif
}

void debug_open_file()
{
#ifndef FORCE_OPEN
    fnote = fopen("note", "wt");
#endif
}

class CycleFile
{
public:
    int end, residual;
    FILE *f;
    int bufsize;
    char buf[1024 * 256];
    CycleFile(const char *filename) 
	: residual(sizeof(buf)), end(0), bufsize((int) sizeof(buf))
    {
	f = fopen(filename, "wt");
    }
    ~CycleFile()
    {
	int start, size_to_end, chars_in_buf, n;
	chars_in_buf = bufsize - residual;
	if (chars_in_buf <= 0) return;
	start = end + residual;
	if (start > bufsize) start -= bufsize;
	size_to_end = bufsize - start;
	if (size_to_end > chars_in_buf) n = residual;
	n = (size_to_end > chars_in_buf) ? chars_in_buf : size_to_end;
	fwrite(buf + start, n, 1, f);
	chars_in_buf -= n;
	if (chars_in_buf <= 0) return;
	fwrite(buf, chars_in_buf, 1, f);
	fclose(f);
    }
};

int cycle_write(void *cookie, const char *data, int count)
{
    CycleFile *cycle = (CycleFile *) cookie;
    int fill_size;
    while (count > cycle->bufsize) count -= cycle->bufsize;
    if (count <= 0) return 0;
    if (cycle->residual > 0) {
	// Fill up the buf as it goes
	fill_size = cycle->residual;
	if (fill_size > count) fill_size = count;
	memcpy(cycle->buf + cycle->end, data, fill_size);
	count -= fill_size;
	cycle->end += fill_size;
	data += fill_size;
	if (cycle->end >= cycle->bufsize) cycle->end -= cycle->bufsize;
	cycle->residual -= fill_size;
    }
    if (count <= 0) return 0;
    // Fill from current end to end of buf
    fill_size = cycle->bufsize - cycle->end;
    if (fill_size > count) fill_size = count;
    memcpy(cycle->buf + cycle->end, data, fill_size);
    count -= fill_size;
    cycle->end += fill_size;
    data += fill_size;
    if (cycle->end >= cycle->bufsize) cycle->end -= cycle->bufsize;
    if (count <= 0) return 0;
    // Now, dump the rest
    memcpy(cycle->buf, data, count);
    cycle->end += count;
    if (cycle->end >= cycle->bufsize) cycle->end -= cycle->bufsize;
    return 0;
}

int cycle_close(void *cookie)
{
    delete (CycleFile *) cookie;
    return 0;
}


void debug_open_cycle_file()
{
    CycleFile *f = new CycleFile("note");
    fnote = funopen(f, 0, cycle_write, 0, cycle_close);
}

void tell(const char *fmt, ...)
{
    init_note();
    if (fnote != NULL) {
	va_list v;
	va_start(v, fmt);
	vfprintf(fnote, fmt, v);
	va_end(v);
	fprintf(fnote, "\n");
	fflush(fnote);
    }
}

void Xshow_last_error()
{
    PERRINFO err = WinGetErrorInfo(StdWin::hab);
    if (err != NULL) {
	tell("Error: error number 0x%X", err->idError);
#define INDEX(i) ((void *)((char *) err + (i)))
	tell("cDetailLevel: %d", err->cDetailLevel);
	tell("offaoffszMsg: %d", err->offaoffszMsg);
	tell("INDEX(offa..): %d", INDEX(err->offaoffszMsg));
	tell("INDEX(offa..)[0]: %d", *(int *)INDEX(err->offaoffszMsg));
	tell("INDEX(INDEX(offa..)[0]): %d", INDEX(*(int *)INDEX(err->offaoffszMsg)));
	tell("INDEX(INDEX(offa..)[0])[0]: %d", *(int*)INDEX(*(int *)INDEX(err->offaoffszMsg)));
	tell("Err???: %s", INDEX(err->offaoffszMsg));
	tell("Error string: %s", 
	     (char *) INDEX(((int *) INDEX(err->offaoffszMsg))[0]));
    }
    WinFreeErrorInfo(err);
}

