
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

typedef struct {
    char *filename;
    long int position;
} SplitRec;

typedef struct splitlist_struct SplitList;
struct splitlist_struct {
    SplitList *next;
    SplitRec split;
};

void add_info_path(const char *new_path);
void add_info_file_or_path(const char *new_path);

class InfoFile
{
private:
    int okval;
    int split_file;
    SplitList *splitlist;
    int tags_table_availible;
    SplitList *tags_table;
    FILE *infofile;
    FILE *cache_infofile;
    char *cache_filename, *cache_part_filename;
    HistoryList history;
    char *most_recent_filename;
    FILE *infoopen(const char *part_filename, const char *filename);
    void open(const char *);
    View *getnode_attempt(const char *nodename);
public:
    static void add_attributes(View *);
    int ok(void) { return okval; }
    InfoFile(const char *filename);
    ~InfoFile(void);
    View *getnode(const char *nodename);
    View *get_last_node();
};
