#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_GPIPRIMITIVES
#include <os2.h>

#include "attr.h"
#include "view.h"

static const char *safe_getline(FILE *f)
{
    static char *buf = NULL;
    static int bufsize = 0;

    if (buf == NULL) {
	bufsize = 1024;
	buf = (char *) malloc(bufsize);
    }
    int buffill = 0;
    for(;;) {
	if (buffill == bufsize) {
	    bufsize += 1024;
	    buf = (char *) realloc(buf, bufsize);
	}
	char *p = fgets(buf + buffill, bufsize - buffill, f);
	if (p == NULL) {
	    if (buffill == 0) return NULL;
	    break;
	}
	buffill += strlen(buf + buffill) - 1;
	if (buf[buffill] == '\n') {
	    buf[buffill] = '\0';
	    break;
	}
    }
    return buf;
}

static View *get_file_view(const char *filename)
{
    FILE *f = fopen(filename, "rt");
    if (f == NULL) return NULL;
    SimpleView *v = new SimpleView;
    for(;;) {
	const char *line = safe_getline(f);
	if (line == NULL) break;
	v->append(line);
    }
    v->delete_trailing_blank_lines ();
    return v;
}

static void decorate_manual(View *v)
{
    char *line, *p, *dest;
    int i;
    for (i=0; i < v->length(); i++) {
	line = (char *) v->line(i);  // I *mean* this
	for (p = dest = line; *p != '\0'; ) {
	    if (p[1] == '\b' && p[0] == p[2]) {
		int start = dest - line;
		while (*p != '\0' && p[1] == '\b' && p[0] == p[2]) {
		    *dest++ = *p;
		    p += 3;
		}
		v->attr.
		    add_attribute(new Bold(TextRegion(TextPoint(i,start),
						      TextPoint(i,dest-line-1))));
	    } else if (p[0] == '_' && p[1] == '\b' && p[2] != '\0') {
		int start = dest - line;
		while (p[0] == '_' && p[1] == '\b' && p[2] != '\0') {
		    *dest++ = p[2];
		    p += 3;
		}
		v->attr.
		    add_attribute(new RedAttr(TextRegion(TextPoint(i,start),
							 TextPoint(i,dest-line-1))));
	    } else {
		*dest++ = *p++;
	    }
	}
	*dest = '\0';
    }
}

View *getmanual(const char *filename)
{
    View *v;

    v = get_file_view(filename);
    if (v == 0)
      return 0;
    decorate_manual(v);
    return v;
}
