/* Structure describing a running or dead child process.  */

typedef struct
{
	char **		ptrs;
	char *		strs;
	int			ptr_size;
	int			ptr_used;
	int			str_size;
	int			str_used;
} *argPtr;

struct child
{
    struct file *file;		/* File being remade.  */

    char **environment;		/* Environment for commands.  */

    char **command_lines;	/* Array of variable-expanded cmd lines.  */
    int    command_line;	/* Index into above.  */
    char  *command_ptr;		/* Ptr into command_lines[command_line].  */

    unsigned int noerror:1;	/* Nonzero if commands contained a `-'.  */

    unsigned int good_stdin:1;	/* Nonzero if this child has a good stdin.  */
    unsigned int deleted:1;	/* Nonzero if targets have been deleted.  */
};

extern struct child *children;

extern void new_job ();
extern void push_signals_blocked_p (), pop_signals_blocked_p ();

extern argPtr construct_command_argv (char *line, char **restp, struct file *file);
extern int child_execute_job (argPtr, char **envp);
extern int exec_command (argPtr, char **envp);

extern int job_slots_used;

extern argPtr argPtr_new(int seed_size);
extern void	argPtr_add(argPtr arg, char *argp);
extern void	argPtr_insert(argPtr arg, int argpos, char **argv, int argc);
extern void	argPtr_delete(argPtr arg, int argpos, int num);
extern void	argPtr_free(argPtr arg);

/* End of File */

