#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <unistd.h>

int chdir (const char *path)
{
   ULONG rc;

   rc = DosSetCurrentDir ((PSZ)path);

   if (rc)
   {
      if (rc == ERROR_FILE_NOT_FOUND || rc == ERROR_PATH_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED || rc == ERROR_DRIVE_LOCKED)
      {
         errno = EACCES;
         return (-1);
      }

      if (rc == ERROR_INVALID_PARAMETER)
      {
         errno = EINVAL;
         return (-1);
      }

      if (rc == ERROR_FILENAME_EXCED_RANGE)
      {
         errno = ENAMETOOLONG;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   return (0);
}

