#include <stdlib.h>
#include <string.h>

#define BLK 32

static inline int same_env_prefix(const char *s1, const char *s2)
{
  for (;;)
    {
      if (*s1 != *s2)
	return 0;
      if (*s1++ == '=' || *s2++ == '=')
	return 1;
    }
}

char **_mergenv(const char * const * const oldenv, 
	       const char * const * const newenv)
{
  char **env, **tmp;
  int env_alloc, env_size;
  int i;

  /* Count the max possible size of the result env block */
  /* Throw errors for bogus env entries */
  for (i=0; newenv[i] != 0; i++)
    if (newenv[i][0] == '\0' 
	|| strchr(newenv[i], '=') == 0)
      return 0;
  env_alloc = i;
  for (i=0; oldenv[i] != 0; i++)
    if (oldenv[i][0] == '\0' 
	|| strchr(oldenv[i], '=') == 0)
      return 0;
  env_alloc += i + 1;

  /* Allocate space for the mess */
  env = (char **) malloc(sizeof(char *) * env_alloc);
  if (env == 0)
    return 0;

  /* Copy the newenv into the result */
  env_size = 0;
  for (i=0; newenv[i] != 0; i++)
    {
      env[env_size] = strdup(newenv[i]);
      if (env[env_size++] == 0)
	return 0;
    }

  /* Now insert non-duplicate entries from oldenv */
  /* Yes, this is an n**3 algorithm.  So sue me.  */
  for (i=0; oldenv[i] != 0; i++)
    {
      int j;
      for (j=0; newenv[j] != 0; j++)
	if (same_env_prefix(oldenv[i], newenv[j]))
	  break;
      if (newenv[j] != 0)
	continue;
      env[env_size] = strdup(oldenv[i]);
      if (env[env_size++] == 0)
	return 0;
    }

  /* Then insert the trailing NULL */
  env[env_size] = 0;

  /* If we were feeling petty, we would shrink env's allocation here */
  /* env = (char **) realloc(env, env_size+1) */

  /* return the resultant env block */
  return env;
}
