#define INCL_DOSFILEMGR
#include <os2.h>

#define __DIRENT_PRIVATE__
#include <stdlib.h>
#include <string.h>
#include <dirent.h>

DIR *opendir(const char *dirname)
{
     DIR *dir;
     ULONG ret;
     FILEFINDBUF3 buf;
     unsigned long int cnt;
     int namelen;
     
     dir = (DIR *) malloc(sizeof(DIR));
     if (dir == NULL)
	  return NULL;

     /* Remember to allocate enough bytes to hold the maximum number */
     /* of characters that may be appended to the file name, plus a NULL */
     namelen = strlen(dirname);

     dir->searchname = (char *) malloc(namelen + 3);
     if (dir->searchname == NULL) {
	  free(dir);
	  return NULL;
     }

     strcpy(dir->searchname, dirname);
     if (dir->searchname[namelen-1] != '\\') {
	  strcat(dir->searchname, "\\");
	  namelen += 1;
     }

     strcat(dir->searchname, "*");
     namelen += 1;
     
     dir->reset = 1;
     dir->dirhandle = HDIR_CREATE;
     cnt = 1;
     ret = DosFindFirst(dir->searchname, &dir->dirhandle,
			FILE_ARCHIVED | FILE_DIRECTORY | FILE_SYSTEM
			  | FILE_HIDDEN | FILE_READONLY,
			&buf, sizeof(buf), &cnt, 1);
     if (ret != 0) {
	  free(dir->searchname);
	  free(dir);
	  return NULL;
     } else
	  return dir;
}
