#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <fcntl.h>

extern int *__textio;
extern char __textbuf[8096];

int read (int fd, char *buf, int nbytes)
{
   ULONG rc;
   ULONG BytesRead;

   if (__textio[fd] & O_BINARY)
   {
      rc = DosRead (fd, (void *)buf, nbytes, &BytesRead);

      if (rc && BytesRead == 0)
      {
         if (rc == ERROR_INVALID_HANDLE)
         {
            errno = EBADF;
            return (-1);
         }

         if (rc == ERROR_ACCESS_DENIED || rc == ERROR_LOCK_VIOLATION)
         {
            errno = EACCES;
            return (-1);
         }

         errno = EIO;
         return (-1);
      }

      return (BytesRead);
   }
   else
   {
      char *tbuf;
      int bcount = nbytes;
      register char c;
      int leave_early = 0;

      while (bcount)
      {
         int thistime = bcount > 8096 ? 8096 : bcount;

         rc = DosRead (fd, (void *)__textbuf, thistime, &BytesRead);

         if (BytesRead == 0)
            return (nbytes - bcount);

         if (rc)
         {
            if (rc == ERROR_INVALID_HANDLE)
            {
               errno = EBADF;
               return (-1);
            }

            if (rc == ERROR_ACCESS_DENIED || rc == ERROR_LOCK_VIOLATION)
            {
               errno = EACCES;
               return (-1);
            }

            errno = EIO;
            return (-1);
         }

         if (BytesRead < thistime) leave_early = 1;

         tbuf = (char *)__textbuf;

         for (thistime = BytesRead; 0 < thistime && 0 < bcount; --thistime)
         {
            c = *tbuf++;
            if (c == 0x1a)
               return (nbytes - bcount);

            if (c == '\r')
            {
            }
            else
            {
               *buf++ = c;
               --bcount;
            }
         }

         /* This is for device reads that don't have enough data ready */
         if (leave_early) return (nbytes - bcount);
      }
      return (nbytes - bcount);
   }
}

