#include <signal.h>
#include <errno.h>
extern int __signal_mask;

int sigprocmask (int how, const sigset_t *set, sigset_t *oset)
{
   if (set)
   {
      switch (how)
      {
         case SIG_BLOCK:
            if (oset)
               *oset = __signal_mask;
            __signal_mask |= *set & 0xFFFAFEFF;
            return (0);

         case SIG_UNBLOCK:
            if (oset)
               *oset = __signal_mask;
            __signal_mask &= *set & 0xFFFAFEFF;
            return (0);

         case SIG_SETMASK:
            if (oset)
               *oset = __signal_mask;
            __signal_mask = *set & 0xFFFAFEFF;
            return (0);

         default:
            errno = EINVAL;
            return (-1);
      }
   }

   errno = EINVAL;
   return (-1);
}


