#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSMISC
#include <os2.h>
#include <errno.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>

#include "../mkerr.h"

extern char **environ;

static char *mkargv (const char * const *argv)
{
  int i, len;
  char *p, *result;

  /* Validation */
  if (argv == 0 || argv[0] == 0)
    return 0;

  /* Count required length */
  for (i=0, len=0; argv[i] != 0; i++)
    len += strlen(argv[i]) + 1;
  len += 1;

  /* Create a return data block */
  result = (char *) malloc(len);
  if (result == 0)
    return 0;

  /* Fill the argv[0] section */
  p = result;
  strcpy(p, argv[0]);
  p += strlen(p);
  *p++ = '\0';

  /* Fill the argv[1..n] section */
  for (i=1; argv[i]; i++)
    {
      /* BUG: Args need to be quoted */
      strcpy(p, argv[i]);
      p += strlen(p);
      *p++ = ' ';
    }

  /* Remove final ' ' (or '\0') and replace with terminator */
  p[-1] = '\0';
  p[0] = '\0';

  /* Return new array */
  return result;
}

static char *mkenv (const char * const *env)
{
  int i, len;
  char *p, *result;
  for (i=0, len=0; env[i] != 0; i++)
    len += strlen(env[i]) + 1;
  len++;
  result = (char *) malloc(len);
  if (result == 0)
    return 0;
  for (i=0, p = result; env[i] != 0; i++)
    {
      strcpy(p, env[i]);
      p += strlen(env[i]) + 1;
    }
  *p = '\0';
  return result;
}

int _spawn (int modeflag, int p, const char *path, const char * const *argv,
	    const char * const *envp)
{
  int pathlen = path ? strlen(path) : 0;
  int maxpath = pathlen+512;
  char base_name[maxpath];
  char exe_name[maxpath];
  ULONG rc;
  char *os2argv, *os2env;
  int exec_mode;
  RESULTCODES return_codes;

  if (!path) 
    reterr(EINVAL);

  /* Fill exe_name with the name of the executable */
  if (strchr(path, '\\') || strchr(path, ':') || p == _SPAWN_NO_SEARCH_PATH)
    {
      /* Path provided or no path-search requested */
      /* Use given path unconditionally. */
      strcpy(exe_name, path);
      if (access(exe_name, X_OK) == -1)
	strcat(exe_name, ".EXE");
    }
  else
    {
      char *env_path = getenv ("PATH");
      /* Path not provided, $PATH search requested */
      strcpy (base_name, path);
      if (env_path)
	rc = DosSearchPath (SEARCH_CUR_DIRECTORY,
			    (PSZ) env_path,
			    (PSZ) base_name,
			    (PBYTE) exe_name,
			    sizeof(exe_name));
      else
	rc = DosSearchPath (SEARCH_ENVIRONMENT | SEARCH_CUR_DIRECTORY,
			    (PSZ) "PATH",
			    (PSZ) base_name,
			    (PBYTE) exe_name,
			    sizeof(exe_name));
      if (rc)
	{
	  /* Path not found.  Try with .exe added */
	  strcat (base_name, ".EXE");
	  if (env_path)
	    rc = DosSearchPath (SEARCH_CUR_DIRECTORY,
				(PSZ) env_path,
				(PSZ) base_name,
				(PBYTE) exe_name,
				sizeof(exe_name));
	  else
	    rc = DosSearchPath (SEARCH_ENVIRONMENT | SEARCH_CUR_DIRECTORY,
				(PSZ) "PATH",
				(PSZ) base_name,
				(PBYTE) exe_name,
				sizeof(exe_name));
	  if (rc)
	    {
	      /* Decode OS/2 error into errno variable */
	      switch (rc) {
	      case ERROR_FILE_NOT_FOUND:
	      case ERROR_PATH_NOT_FOUND:
		reterr(ENOENT);
	      case ERROR_NOT_ENOUGH_MEMORY:
		reterr(ENOMEM);
	      default:
		reterr(EIO);
	      }
	    }
	}
    }

  /* Flatten argv into an OS/2 argv */
  /* (argv and envp may be larger than 4K, so don't even */
  /* we can't use alloca) */
  if (argv == 0)
    reterr(EINVAL);
  os2argv = mkargv(argv);
  if (os2argv == 0)
    reterr(ENOMEM);

  /* Flatten envp into an OS/2 env */
  os2env = mkenv(envp ? envp : (const char * const *) environ);
  if (os2env == 0)
    reterr(ENOMEM);

  /* Determine the execution mode */
  switch (modeflag)
    {
    case P_WAIT:
      exec_mode = EXEC_SYNC;
      break;
    case P_NOWAIT:
      exec_mode = EXEC_ASYNCRESULT;
      break;
    default:
      /* oops... */
      reterr(EINVAL);
    }

  /* Execute the program */
  rc = DosExecPgm (0, 0, exec_mode,
		   os2argv, os2env,
		   &return_codes,
		   exe_name);

  /* Diagnose failures */
  if (rc)
    {
      switch (rc)
	{
	case ERROR_FILE_NOT_FOUND:
	case ERROR_PATH_NOT_FOUND:
	  reterr(ENOENT);
	default:
	  reterr(EIO);
	}
    }

  /* Depending on the execution mode, return a value */
  switch (modeflag)
    {
    default: /* This case is never taken.  See above */
    case P_WAIT:
      return return_codes.codeResult;
    case P_NOWAIT:
      return return_codes.codeTerminate;
    }
}

char **_alloc_argv(va_list va)
{
  int i = 2;
  char *p;
  for (;;)
    {
      p = va_arg(va, char *);
      if (p == 0) break;
      i++;
    }
  return (char **) malloc( sizeof(char **) * i );
}

void _fill_argv(const char *arg0, const char **argv, va_list va)
{
  char *p;
  *argv++ = arg0;
  for (;;)
    {
      p = va_arg(va, char *);
      *argv++ = p;
      if (p == 0) break;
    }
}
