#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

int writev (int fd, const struct iovec *iov, int iovcnt)
{
   int i;
   int accum = 0;

   for (i = 0; i < iovcnt; ++i)
   {
      register count = iov[i].iov_len;
      register thistime;

      while (count)
      {
         if ((thistime = write (fd, iov[i].iov_base, count)) <= 0)
            return (-1);
         count -= thistime;
         accum += thistime;
      }
   }
   return (accum);
}

