#include <os2.h>
#include <stdio.h>
#define INCL_CMNLIB
#include <common.h>
#include "rc.h"
#include "help.h"
#include "life.h"

//-------------------------------------------------------------------------
// Beginning of 16-bit declarations
//-------------------------------------------------------------------------
//-------------------------------------------------------------------------
// We need access to the 16-bit API DosGetInfoSeg() so that we can determine
// the id of the current session.  Though the documentation for
// DosQuerySysInfo() says that you can specify the QSV_FOREGROUND_FS_SESSION
// parameter to get this, that constant is not defined in the 2.0 toolkit
// and hard-coding its value - 24 - returns an error.
//
// Why do we need to know the session id?  See the notes below.  :)
//-------------------------------------------------------------------------
typedef struct _GINFOSEG {
    ULONG   time;               /* time in seconds                           */
    ULONG   msecs;              /* milliseconds                              */
    UCHAR   hour;               /* hours                                     */
    UCHAR   minutes;            /* minutes                                   */
    UCHAR   seconds;            /* seconds                                   */
    UCHAR   hundredths;         /* hundredths                                */
    USHORT  timezone;           /* minutes from UTC                          */
    USHORT  cusecTimerInterval; /* timer interval (units = 0.0001 seconds)   */
    UCHAR   day;                /* day                                       */
    UCHAR   month;              /* month                                     */
    USHORT  year;               /* year                                      */
    UCHAR   weekday;            /* day of week                               */
    UCHAR   uchMajorVersion;    /* major version number                      */
    UCHAR   uchMinorVersion;    /* minor version number                      */
    UCHAR   chRevisionLetter;   /* revision letter                           */
    UCHAR   sgCurrent;          /* current foreground session                */
    UCHAR   sgMax;              /* maximum number of sessions                */
    UCHAR   cHugeShift;         /* shift count for huge elements             */
    UCHAR   fProtectModeOnly;   /* protect mode only indicator               */
    USHORT  pidForeground;      /* pid of last process in forground session  */
    UCHAR   fDynamicSched;      /* dynamic variation flag                    */
    UCHAR   csecMaxWait;        /* max wait in seconds                       */
    USHORT  cmsecMinSlice;      /* minimum timeslice (milliseconds)          */
    USHORT  cmsecMaxSlice;      /* maximum timeslice (milliseconds)          */
    USHORT  bootdrive;          /* drive from which the system was booted    */
    UCHAR   amecRAS[32];        /* system trace major code flag bits         */
    UCHAR   csgWindowableVioMax;/* maximum number of VIO windowable sessions */
    UCHAR   csgPMMax;           /* maximum number of pres. services sessions */
} GINFOSEG;
typedef GINFOSEG FAR *PGINFOSEG;

USHORT APIENTRY16 DOS16GETINFOSEG(PSEL _Seg16 pselGlobal,PSEL _Seg16 pselLocal);
//-------------------------------------------------------------------------
// End of 16-bit declarations
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// CLS_SAVER - class of the screen saver window.  The Settings window is a
//             dialog, so it has no class.  :)
// PRF_APPNAME - application name for the Prf*() functions.
// PRF_SETTINGS - key name for the settings info.
// BCOORD(pcdData,usX,usY) - converts a 2-d coordinate into a 1-d array index
//                           for the board
// PCOORD(ppPattern,usX,usY) - converts a 2-d coordinate into a 1-d array
//                             index for a pattern
// TID_LIFECLICKS - timer id for the screen saver.
// TID_SECONDS - timer id for the inactivity timer.
// TM_TIMEOUT - timeout value for TID_LIFECLICKS.
// MAX_COLORS - number of colors in aulColors[].
// MAX_MARGIN - defines the boundaries of the centers of the patterns that
//              are generated.  Used to avoid boundary checks when gen'ing
//              the universe.
// MAX_TICKS - modulus factor when calculating the number of ticks for the
//             current universe.
// BASE_TICKS - base number of ticks for every universe.  A random number
//              from 0-(MAX_TICKS-1) is added to this to get the lifetime of
//              each universe.
// PATTERNS_FILE - name of the patterns file
//-------------------------------------------------------------------------
#define CLS_SAVER                "LifeSaver"

#define PRF_APPNAME              "Life Saver"
#define PRF_SETTINGS             "Settings"

#define BCOORD(psdData,usX,usY) (((usY)*psdData->szlBoard.cx)+(usX))
#define PCOORD(ppPattern,usX,usY) (((usY)*ppPattern->szlPattern.cx)+(usX))

#define TID_LIFECLICKS           1
#define TID_SECONDS              2

#define TM_TIMEOUT               1000

#define MAX_COLORS               46
#define MAX_MARGIN               3

#define MAX_TICKS                50
#define BASE_TICKS               50

#define MAX_PATTERNS             256
#define PATTERNS_FILE            "LIFE.PAT"

typedef VOID (* _Optlink PFNASYNC)(PVOID);

//-------------------------------------------------------------------------
// Settings information
//-------------------------------------------------------------------------
typedef struct _SETTINGS {
   USHORT usSzStruct;
   ULONG ulSaveTime;
   BOOL bDisable;
} SETTINGS, *PSETTINGS;

//-------------------------------------------------------------------------
// Patterns loaded from PATTERNS.LFE
//-------------------------------------------------------------------------
typedef struct _PATTERN {
   SIZEL szlPattern;
   BYTE abData[1024];
} PATTERN, *PPATTERN;

//-------------------------------------------------------------------------
// Instance data for the saver window
//-------------------------------------------------------------------------
typedef struct _SAVERDATA {
   USHORT usSzStruct;
   HAB habAnchor;
   HWND hwndOwner;

   SETTINGS sSettings;
   ULONG ulSeconds;
   HWND hwndFocus;
   PHOOKDATA phdHook;

   HPS hpsPaint;
   HPAL hpPalette;
   HBITMAP hbmSpace;
   SIZEL szlSpace;
   SIZEL szlBoard;
   PSHORT psBoard;
   PSHORT psNew;
   ULONG ulMaxTicks;
   ULONG ulRoamer;
   ULONG ulNumTicks;

   BOOL bPatternsLoaded;
   USHORT usNumPatterns;
   PPATTERN appPatterns[MAX_PATTERNS];
} SAVERDATA, *PSAVERDATA;

//-------------------------------------------------------------------------
// Instance data for the client window
//-------------------------------------------------------------------------
typedef struct _CLIENTDATA {
   USHORT usSzStruct;
   HAB habAnchor;
   HWND hwndSaver;
   HWND hwndHelp;
   HPOINTER hpIcon;
   PSAVERDATA psdData;
} CLIENTDATA, *PCLIENTDATA;

#include "proto.h"
