/************************************************************
    playall.cmd

    REXX procedure to play all *.wav *.mid
    usage: playall directory [wav] [midi] [rec]


    Marc E.E. van Woerkom, 1/94
 ************************************************************/


parse arg dir arg1 arg2 arg3 /* copy argv[1] and remove */

say
if dir = '' then do
    say 'PlayAll seeks and plays all soundfiles'
    say
    say 'usage: playall path [wav] [midi] [rec]'
    exit 0
end

if dir = '.' then dir = directory()                /* current dir */


dowav  = 0
domidi = 0
dorec  = 0


parse upper arg dummy arg1 arg2 arg3  /* copy argv[1..3] */

if arg1 = 'WAV'  then dowav  = 1

if arg1 = 'MIDI' then domidi = 1
if arg2 = 'MIDI' then domidi = 1

if arg1 = 'REC'  then dorec  = 1
if arg2 = 'REC'  then dorec  = 1
if arg3 = 'REC'  then dorec  = 1


if (\dowav) & (\domidi) then do
   dowav  = 1
   domidi = 1
end


files = ''                                         /* message */
if dowav  then files = ' *.wav'
if domidi then files = files' *.mid'


opt = 'O'                                          /* dir tree options       */
if dorec then do                                   /* F: files only          */
    opt = opt'S'                                   /* O: only qualified name */
    recstr = 'and beneath '                        /* S: recurse             */
end
else recstr = ''


say '(Playing all'files 'files from' dir recstr'...'
say


rc = call RxFuncAdd('SysLoadFuncs', 'RexxUtil',,   /* register REXX Utils */
                    'SysLoadFuncs')
rc = call SysLoadFuncs()                           /* and initialize them */


rc = call RxFuncAdd('mciRxInit', 'MCIAPI',,        /* register MCI REXX API */
                    'mciRxInit')
rc = call mciRxInit()                              /* and initialize it */


if dowav then do
    rc = mciRxSendString('open waveaudio',         /* open digital audio */
                         'alias wave shareable wait',,
                         'RetStr', '0', '0')
    if rc <> 0 then do
        rc2 = mciRxGetErrorString(rc, 'ErrStVar')
        say 'ERROR! rc =' rc ', ErrStVar =' ErrStVar
        exit rc2
    end

    rc = mciRxSendString('info wave',              /* ask for product info */
                         'product wait',,
                         'waveinfo', '0', '0')

    rc = mciRxSendString('close wave wait',,       /* close device "wave" */
                         'RetStr', '0', '0')

    say '    Waveaudio device is' waveinfo
end


if domidi then do
    rc = mciRxSendString('open sequencer',         /* open MIDI device */
                         'alias midi2 shareable wait',,
                         'RetStr', '0', '0')

    if rc <> 0 then do
        rc2 = mciRxGetErrorString(rc, 'ErrStVar')
        say 'ERROR! rc =' rc ', ErrStVar =' ErrStVar
        exit rc2
    end

    rc = mciRxSendString('info midi2',             /* ask for product info */
                         'product wait',,
                         'midi2info', '0', '0')

    rc = mciRxSendString('close midi2 wait',,      /* close device "midi" */
                         'RetStr', '0', '0')

    say '    MIDI device is' midi2info
end

if Right(dir, 1) = '\' then
    mask = dir'*.*'
else
    mask = dir'\*.*'

rc = call SysFileTree(mask, 'file', opt)           /* read dir tree */

if file.0 = 0 then do
    say '    No files found!'
    rc = 0
end

do i=1 to file.0
    ext = Translate(Right(file.i, 4))
 
    if dowav & (ext = '.WAV') then do
        say
        say '    File' file.i':'

        rc = mciRxSendString('open waveaudio',     /* open digital audio */
                             'alias wave shareable wait',,
                             'RetStr', '0', '0')

        rc = mciRxSendString('set wave time',      /* set time format to ms */
                             'format ms wait',,
                             'RetStr', '0', '0')

        rc = mciRxSendString('load wave' file.i 'wait',,   /* play *.wav */
                             'RetStr', '0', '0')
 
        rc = mciRxSendString('status wave length wait',,   /* query length */
                             'RetStr', '0', '0')

        if rc = 0 then do
            time = RetStr / 1000.0
            say '    Playing time is' time 's'
        end

        rc = mciRxSendString('play wave wait',,    /* play file */
                             'RetStr', '0', '0')

        rc = mciRxSendString('close wave wait',,   /* close device "wave" */
                             'RetStr', '0', '0')
    end

    if domidi & (ext = '.MID') then do
        say
        say '    File' file.i':'

        rc = mciRxSendString('open sequencer',     /* open MIDI device */
                             'alias midi2 shareable wait',,
                             'RetStr', '0', '0')

        rc = mciRxSendString('set midi2 time',     /* set time format to ms */
                             'format ms wait',,
                             'RetStr', '0', '0')

        rc = mciRxSendString('load midi2' file.i 'wait',,   /* play *.mid */
                             'RetStr', '0', '0')

        rc = mciRxSendString('status midi2 length wait',,   /* query length */
                             'RetStr', '0', '0')
        if rc = 0 then do
            time = RetStr / 1000.0
            say '    Playing time is' time 's'
        end

        rc = mciRxSendString('play midi2 wait',,   /* play file */
                             'RetStr', '0', '0')

        rc = mciRxSendString('close midi2 wait',,  /* close device "midi" */
                             'RetStr', '0', '0')
    end
end

say
if rc = 0 then
    say '... done.)'
else
    say '... playing aborted!)'

call mciRxExit

exit rc                                            /* exit with rc code */
