#define INCL_PM

#include "idialog.hpp"

#include <os2.h>

IDialogWindow::IDialogWindow(unsigned long ID):
               IFrameWindow(IResourceId(ID)){

   handleEventsFor(this);
}

IDialogWindow::IDialogWindow(unsigned long ID, IWindow *Parent, IWindow *Owner):
               IFrameWindow(IResourceId(ID),Parent,Owner){

   handleEventsFor(this);
}


IDialogWindow::~IDialogWindow(){
}

IDialogWindow& IDialogWindow::setItemText(unsigned long ID,char *Text){
   WinSetDlgItemText(handle(),ID,Text);
return *this;
}

IDialogWindow& IDialogWindow::sendItemMessage(unsigned long ID,unsigned long iMess,
               unsigned long mp1, unsigned long mp2){
   WinSendMsg(WinWindowFromID(handle(),ID),
              iMess,MPFROMLONG(mp1),MPFROMLONG(mp2) );
return *this;
}

IDialogWindow& IDialogWindow::sendItemMessage(unsigned long ID,unsigned long iMess,
               unsigned short int si1,unsigned short int si2, unsigned long mp2){
   WinSendMsg(WinWindowFromID(handle(),ID),
             iMess,MPFROM2SHORT(si1,si2),MPFROMLONG(mp2) );
return *this;
}


IDialogWindow& IDialogWindow::sendItemMessage(unsigned long ID,unsigned long iMess,
                        void* mp1, void* mp2){
   WinSendMsg(WinWindowFromID(handle(),ID),
             iMess,mp1, mp2);
return *this;
}


IDialogWindow& IDialogWindow::queryItemText(unsigned long ID,unsigned long maxLen,char *retBuf){
   WinQueryDlgItemText(handle(),ID,maxLen,retBuf);
return *this;
}


unsigned long IDialogWindow::queryItemTextLength(unsigned long ID){
   return WinQueryDlgItemTextLength(handle(),ID);
}



Boolean IDialogWindow::dispatchHandlerEvent(IEvent& evt){
   HWND hwnd;
   HENUM henum;
   PSWP pswp;
   Boolean ShowState;
   SWP winPos,Pos;
   int cx,cy;

   if(evt.eventId()==WM_MINMAXFRAME){
      henum=WinBeginEnumWindows(handle());
      pswp=(PSWP)evt.parameter1().asUnsignedLong();
      if((pswp->fl)&SWP_MINIMIZE)
         ShowState=false;
      else
         ShowState=true;

      WinQueryWindowPos(handle(),&Pos);

      while(hwnd=WinGetNextWindow(henum)){
         WinQueryWindowPos(hwnd,&winPos);

         /* cx, cy, y, x */
//         cx=winrect.xRight-winrect.xLeft;
//         cy=winrect.yTop-winrect.yBottom;
         if( ((winPos.x)<=pswp->cx)&&
             ((winPos.y)<=pswp->cy) )
                 WinShowWindow(hwnd,ShowState);
      }
      WinEndEnumWindows(henum);
   }


return IFrameHandler::dispatchHandlerEvent(evt);
}

//-------------------------------------------------------

Boolean ControlHander::dispatchHandlerEvent(IEvent& evt){
   if( evt.eventId()==WM_CONTROL){
      IControlEvent controlEvnt(evt);
      Boolean rc=control(controlEvnt);
      evt.setResult(controlEvnt.result() );
      return rc;
   }
   return false;
}

Boolean ControlHander::control(const IControlEvent &control){
   return false;
}

