#include <iostream.h>
#include <io.h>
#include <fcntl.h>
#include <malloc.h>

int load(const char *szName, char* &bitmap) {
  int fh=_open(szName,O_RDONLY | O_BINARY);
  if (fh == -1) {
    cout << "Error opening file " << szName << ".\n";
    return 0;
  }

  int length=_filelength(fh);
  if (length == -1) {
    cout << "Error determining length for " << szName << ".\n";
    _close(fh);
    return 0;
  }
  if (!length) {
    cout << szName << " has zero filesize.\n";
    _close(fh);
    return 0;
  }

  bitmap=(char *) malloc(length);
  if (!bitmap) {
    cout << "Error allocating " << length << " bytes.\n";
    _close(fh);
    return 0;
  }

  int bytesread=_read(fh,bitmap,length);

  if (!bytesread) {
    cout << "Read past end of file " << szName << ".\n";
    free(bitmap);
    _close(fh);
    return 0;
  }
  if (bytesread == -1) {
    cout << "Error reading file " << szName << ".\n";
    free(bitmap);
    _close(fh);
    return 0;
  }
  if (bytesread != length) {
    cout << "Could only read " << bytesread << " of " << length << " bytes.\n";
    free(bitmap);
    _close(fh);
    return 0;
  }

  if (_close(fh)) {
    cout << "Error closing " << szName << ".\n";
    free(bitmap);
    return 0;
  }
 
  return length;
}
