
/*
 *           PVM 3.2:  Parallel Virtual Machine System 3.2
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.2 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	pkt.h
 *
 *	Packet buffers.
 *
$Log: pkt.h,v $
 * Revision 1.1  1993/08/30  23:26:49  manchek
 * Initial revision
 *
 */

struct pkt {
	struct pkt *pk_link;		/* queue or 0 */
	struct pkt *pk_rlink;
	struct pkt *pk_tlink;		/* scheduling queue or 0 */
	struct pkt *pk_trlink;
	int pk_src;					/* source tid */
	int pk_dst;					/* dest tid */
	int pk_flag;				/* flags */
	char *pk_buf;				/* buffer or zero if master pkt */
	int pk_max;					/* size of buffer */
	char *pk_dat;				/* data */
	int pk_len;					/* length of data */
	struct hostd *pk_hostd;		/* receiving host */
	int pk_seq;					/* seq num */
	int pk_ack;					/* ack num */
	struct timeval pk_rtv;		/* time to retry */
	struct timeval pk_rta;		/* next-retry accumulator */
	struct timeval pk_rto;		/* total time spent on pkt */
	struct timeval pk_at;		/* time pkt first sent */
	int pk_nrt;					/* retry count */
};

#define	PF_STARTED	256		/* have started sending pkt to task */

struct pkt *pk_new __ProtoGlarp__((int n));
void pk_free __ProtoGlarp__((struct pkt *p));

