/*------------------------------------------------------------------
 * roxsem.c :
 *------------------------------------------------------------------
 * 09-03-93 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*------------------------------------------------------------------
 * os/2 includes
 *------------------------------------------------------------------*/
#if defined(OPSYS_OS2)
   #define INCL_BASE
   #include <os2.h>
#endif

/*------------------------------------------------------------------
 * rexx includes
 *------------------------------------------------------------------*/
#define INCL_REXXSAA
#if defined(OPSYS_AIX)
   #include <rexxtype.h>
#endif
#include <rexxsaa.h>

/*------------------------------------------------------------------
 * rox includes
 *------------------------------------------------------------------*/
#include "roxapi.h"

/*------------------------------------------------------------------
 * write an integer to a pre-allocated REXX string
 *------------------------------------------------------------------*/
static void long2rxs(
   long      val,
   PRXSTRING pRxs
   )
   {
   sprintf(pRxs->strptr,"%ld",(long)val);
   pRxs->strlength = strlen(pRxs->strptr);
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemMutexInit(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   APIRET   rc;
   HMTX     hMtx;
   RXSTRING name;
   RXSTRING valu;

   rc = DosCreateMutexSem(NULL,&hMtx,0,0);
   if (rc)
      hMtx = 0;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   valu.strptr    = malloc(4);
   valu.strlength = 4;

   memcpy(valu.strptr,&hMtx,4);

   RoxVariableSet(object,&name,&valu);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemMutexDeinit(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HMTX     hMtx;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hMtx,valu.strptr,4);

   DosCloseMutexSem(hMtx);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemMutexQuery(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HMTX     hMtx;
   PID      pid;
   TID      tid;
   ULONG    count;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hMtx,valu.strptr,4);

   count = 0;

   DosQueryMutexSem(hMtx,&pid,&tid,&count);

   long2rxs(count,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemMutexRequest(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HMTX     hMtx;
   APIRET   rc;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hMtx,valu.strptr,4);

   rc = DosRequestMutexSem(hMtx,-1);

   long2rxs(rc,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemMutexRelease(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HMTX     hMtx;
   APIRET   rc;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hMtx,valu.strptr,4);

   rc = DosReleaseMutexSem(hMtx);

   long2rxs(rc,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventInit(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   APIRET rc;
   HEV    hEv;
   RXSTRING name;
   RXSTRING valu;

   rc = DosCreateEventSem(NULL,&hEv,0,1);
   if (rc)
      hEv = 0;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   valu.strptr    = malloc(4);
   valu.strlength = 4;

   memcpy(valu.strptr,&hEv,4);

   RoxVariableSet(object,&name,&valu);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventDeinit(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HEV      hEv;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hEv,valu.strptr,4);

   DosCloseEventSem(hEv);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventQuery(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HEV      hEv;
   ULONG    count;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hEv,valu.strptr,4);

   count = 0;

   DosQueryEventSem(hEv,&count);

   long2rxs(count,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventReset(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HEV      hEv;
   ULONG    count;
   APIRET   rc;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hEv,valu.strptr,4);

   rc = DosResetEventSem(hEv,&count);

   long2rxs(rc,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventPost(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HEV      hEv;
   APIRET   rc;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hEv,valu.strptr,4);

   rc = DosPostEventSem(hEv);

   long2rxs(rc,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxSemEventWait(
   void      *object,
   PUCHAR     methodName,
   ULONG      argc,
   PRXSTRING  argv,
   PRXSTRING  retString
   )
   {
   HEV      hEv;
   APIRET   rc;
   RXSTRING name;
   RXSTRING valu;

   name.strptr    = "handle";
   name.strlength = strlen(name.strptr);

   RoxVariableGet(object,&name,&valu);
   memcpy(&hEv,valu.strptr,4);

   rc = DosWaitEventSem(hEv,-1);

   long2rxs(rc,retString);

   return 0;
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
void roxAddClass(
   PSZ class
   )
   {
   RXSTRING  parm[1];
   RXSTRING  result;
   void     *buff;

   parm[0].strptr      = class;
   parm[0].strlength   = strlen(parm[0].strptr);

   buff                = malloc(256);
   result.strptr       = buff;
   result.strlength    = 0;

   RoxAddClass(NULL,1,parm,NULL,&result);

   if (result.strptr != buff)
     osFree(result.strptr);

   free(buff);
   }

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
void roxClassAddMethodDll(
   PSZ class,
   PSZ method,
   PSZ dll,
   PSZ entry
   )
   {
   RXSTRING  parm[4];
   RXSTRING  result;
   void     *buff;

   parm[0].strptr      = class;
   parm[0].strlength   = strlen(parm[0].strptr);
   parm[1].strptr      = method;
   parm[1].strlength   = strlen(parm[1].strptr);
   parm[2].strptr      = dll;
   parm[2].strlength   = strlen(parm[2].strptr);
   parm[3].strptr      = entry;
   parm[3].strlength   = strlen(parm[3].strptr);

   buff                = malloc(256);
   result.strptr       = buff;
   result.strlength    = 0;

   RoxClassAddMethodDll(NULL,4,parm,NULL,&result);

   if (result.strptr != buff)
     osFree(result.strptr);

   free(buff);
   }

/*------------------------------------------------------------------
 * DLL entrypoint function named "RoxDLLEntryPoint"
 *------------------------------------------------------------------*/
ULONG APIENTRY RoxDllEntryPoint(
   ULONG init
   )
   {
   if (init)
      {
      roxAddClass("MutexSem");
      roxClassAddMethodDll("MutexSem", "init",    "RoxSem", "RoxSemMutexInit");
      roxClassAddMethodDll("MutexSem", "deinit",  "RoxSem", "RoxSemMutexDeinit");
      roxClassAddMethodDll("MutexSem", "query",   "RoxSem", "RoxSemMutexQuery");
      roxClassAddMethodDll("MutexSem", "request", "RoxSem", "RoxSemMutexRequest");
      roxClassAddMethodDll("MutexSem", "release", "RoxSem", "RoxSemMutexRelease");

      roxAddClass("EventSem");
      roxClassAddMethodDll("EventSem", "init",    "RoxSem", "RoxSemEventInit");
      roxClassAddMethodDll("EventSem", "deinit",  "RoxSem", "RoxSemEventDeinit");
      roxClassAddMethodDll("EventSem", "query",   "RoxSem", "RoxSemEventQuery");
      roxClassAddMethodDll("EventSem", "reset",   "RoxSem", "RoxSemEventReset");
      roxClassAddMethodDll("EventSem", "post",    "RoxSem", "RoxSemEventPost");
      roxClassAddMethodDll("EventSem", "wait",    "RoxSem", "RoxSemEventWait");
      }

   return 0;
   }

