/* pmterm.h
   Copyright (C) 1993, 1994 Eberhard Mattes.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "pmlib.h"

void pm_send (const void *src, unsigned size);
void pm_send_collect (const void *src, unsigned size);
void pm_send_flush (void);
void *pm_receive (int serial, void *dst, int *size, int may_paint);
void pm_default_menu (void);

#define XDISPLAY
#define ROOT_WINDOW		((Window *)0)
#define FONT_TYPE		XFontStruct
#define FRAME_X_WINDOW(f)	((unsigned long)f)

/* Number of planes. */
extern int x_screen_planes;

struct x_display
{
  FONT_TYPE *font;
  int internal_border_width;
  int pixel_height;
  int pixel_width;
  int line_height;
  unsigned background_color;
  unsigned foreground_color;

  /* Table of parameter faces for this frame.  */
  struct face **param_faces;
  int n_param_faces;

  /* Table of computed faces for this frame. */
  struct face **computed_faces;
  int n_computed_faces;		/* How many are valid */
  int size_computed_faces;	/* How many are allocated */

  int left_pos;
  int top_pos;
};

extern Display *x_current_display;
extern int pm_serial;
extern int pm_menu_bar_cookie;

#define PIXEL_WIDTH(f)  ((f)->display.x->pixel_width)
#define PIXEL_HEIGHT(f) ((f)->display.x->pixel_height)

#define FONT_WIDTH(f)   ((f)->max_bounds.width)
#define FONT_HEIGHT(f)  ((f)->ascent + (f)->descent)
#define FONT_BASE(f)    ((f)->ascent)

#define FRAME_PARAM_FACES(f) ((f)->display.x->param_faces)
#define FRAME_N_PARAM_FACES(f) ((f)->display.x->n_param_faces)
#define FRAME_DEFAULT_PARAM_FACE(f) (FRAME_PARAM_FACES (f)[0])
#define FRAME_MODE_LINE_PARAM_FACE(f) (FRAME_PARAM_FACES (f)[1])

#define FRAME_COMPUTED_FACES(f) ((f)->display.x->computed_faces)
#define FRAME_N_COMPUTED_FACES(f) ((f)->display.x->n_computed_faces)
#define FRAME_SIZE_COMPUTED_FACES(f) ((f)->display.x->size_computed_faces)
#define FRAME_DEFAULT_FACE(f) ((f)->display.x->computed_faces[0])
#define FRAME_MODE_LINE_FACE(f) ((f)->display.x->computed_faces[1])
